/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.taglib;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.fw.web.struts.form.ActionFormUtil;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.taglib.TagUtils;

public class PageLinksTag
extends TagSupport {
    private static final long serialVersionUID = 9017738370826462823L;
    private static Log log = LogFactory.getLog(PageLinksTag.class);
    protected String id = null;
    protected String action = null;
    protected String name = null;
    protected String rowProperty = null;
    protected String indexProperty = null;
    protected String totalProperty = null;
    protected String scope = null;
    protected boolean submit = false;
    protected boolean forward = false;
    protected String event = DEFAULT_EVENT;
    protected boolean resetIndex = false;
    protected String currentPageIndex = CURRENT_PAGE_INDEX;
    protected String totalPageCount = TOTAL_PAGE_COUNT;
    protected static String ERROR_MESSAGE_ACTION_REQUIRED = "Action attribute is required when submit attribute is \"false\".";
    protected static String WARN_MESSAGE_ILLEGAL_ROW = "Row param is illegal.";
    protected static String PAGE_LINKS_PREFIX = "pageLinks.";
    protected static String PREV_LINKS = "prev";
    protected static String NEXT_LINKS = "next";
    protected static String CHAR_LINKS = ".char";
    protected static String MAX_DSP_SIZE = "maxDirectLinkCount";
    protected static String PAGELINKS_JAVASCRIPT_KEY = "pageLinksJavaScriptKey";
    protected static String FORWARD_NAME = "forward_pageLinks";
    protected static String DEFAULT_EVENT = "event";
    protected static String TOTAL_PAGE_COUNT = "totalPageCount";
    protected static String CURRENT_PAGE_INDEX = "currentPageIndex";
    protected Map<String, String> links = new HashMap<String, String>();
    protected int maxLinkNo = 1;
    protected int maxPageCount = 10;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRowProperty() {
        return this.rowProperty;
    }

    public void setRowProperty(String rowProperty) {
        this.rowProperty = rowProperty;
    }

    public String getIndexProperty() {
        return this.indexProperty;
    }

    public void setIndexProperty(String indexProperty) {
        this.indexProperty = indexProperty;
    }

    public String getTotalProperty() {
        return this.totalProperty;
    }

    public void setTotalProperty(String totalProperty) {
        this.totalProperty = totalProperty;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean getSubmit() {
        return this.submit;
    }

    public void setSubmit(boolean submit) {
        this.submit = submit;
    }

    public boolean getForward() {
        return this.forward;
    }

    public void setForward(boolean forward) {
        this.forward = forward;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public boolean getResetIndex() {
        return this.resetIndex;
    }

    public void setResetIndex(boolean resetIndex) {
        this.resetIndex = resetIndex;
    }

    public String getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    public void setCurrentPageIndex(String currentPageIndex) {
        this.currentPageIndex = currentPageIndex;
    }

    public String getTotalPageCount() {
        return this.totalPageCount;
    }

    public void setTotalPageCount(String totalPageCount) {
        this.totalPageCount = totalPageCount;
    }

    public int doStartTag() throws JspException {
        if (!this.submit && (this.action == null || "".equals(this.action))) {
            log.error((Object)ERROR_MESSAGE_ACTION_REQUIRED);
            throw new JspException(ERROR_MESSAGE_ACTION_REQUIRED);
        }
        this.getLinkProperty();
        Object objRow = this.lookup(this.pageContext, this.name, this.rowProperty, this.scope);
        int row = this.getInt(objRow);
        if (row <= 0) {
            if (log.isWarnEnabled()) {
                log.warn((Object)WARN_MESSAGE_ILLEGAL_ROW);
            }
            return 1;
        }
        Object objIndex = this.lookup(this.pageContext, this.name, this.indexProperty, this.scope);
        int startIndex = this.getInt(objIndex);
        Object objTotal = this.lookup(this.pageContext, this.name, this.totalProperty, this.scope);
        int totalCount = this.getInt(objTotal);
        StringBuilder sb = new StringBuilder();
        this.attributePageCount(this.getPageIndex(row, startIndex), this.getPageCount(row, totalCount));
        if (this.submit) {
            this.defineHtml(row, startIndex, totalCount);
            this.addPrevSubmit(sb, row, startIndex, totalCount);
            this.addDirectSubmit(sb, row, startIndex, totalCount);
            this.addNextSubmit(sb, row, startIndex, totalCount);
        } else {
            this.addPrevLink(sb, row, startIndex, totalCount);
            this.addDirectLink(sb, row, startIndex, totalCount);
            this.addNextLink(sb, row, startIndex, totalCount);
        }
        if (this.id == null || "".equals(this.id)) {
            try {
                JspWriter writer = this.pageContext.getOut();
                writer.println(sb.toString());
            }
            catch (IOException e) {
                log.error((Object)e.getMessage());
                throw new JspTagException(e.toString());
            }
        } else {
            this.pageContext.setAttribute(this.id, (Object)sb.toString());
        }
        return 1;
    }

    protected void defineHtml(int row, int startIndex, int totalCount) throws JspException {
        JspWriter writer = this.pageContext.getOut();
        try {
            if (!this.getPageContextFlg(this.pageContext, PAGELINKS_JAVASCRIPT_KEY + this.rowProperty)) {
                writer.println("<input type=\"hidden\" name=\"" + this.rowProperty + "\" value=\"" + row + "\"/>");
                this.setPageContextFlg(this.pageContext, PAGELINKS_JAVASCRIPT_KEY + this.rowProperty);
            }
            if (!this.getPageContextFlg(this.pageContext, PAGELINKS_JAVASCRIPT_KEY + this.indexProperty)) {
                writer.println("<input type=\"hidden\" name=\"" + this.indexProperty + "\" value=\"" + startIndex + "\"/>");
                this.setPageContextFlg(this.pageContext, PAGELINKS_JAVASCRIPT_KEY + this.indexProperty);
            }
            if (!this.getPageContextFlg(this.pageContext, PAGELINKS_JAVASCRIPT_KEY + this.event) && this.forward) {
                writer.println("<input type=\"hidden\" name=\"" + this.event + "\" value=\"\"/>");
                this.setPageContextFlg(this.pageContext, PAGELINKS_JAVASCRIPT_KEY + this.event);
            }
            if (!this.getPageContextFlg(this.pageContext, PAGELINKS_JAVASCRIPT_KEY + "resetIndex") && this.resetIndex) {
                int endIndex;
                if (!"startIndex".equals(this.indexProperty)) {
                    writer.println("<input type=\"hidden\" name=\"startIndex\" value=\"" + startIndex + "\"/>");
                }
                if ((endIndex = startIndex + row - 1) > totalCount) {
                    writer.println("<input type=\"hidden\" name=\"endIndex\" value=\"" + (totalCount - 1) + "\"/>");
                } else {
                    writer.println("<input type=\"hidden\" name=\"endIndex\" value=\"" + endIndex + "\"/>");
                }
                this.setPageContextFlg(this.pageContext, PAGELINKS_JAVASCRIPT_KEY + "resetIndex");
            }
            String formName = ActionFormUtil.getActionFormName((HttpServletRequest)this.pageContext.getRequest());
            if (!this.getPageContextFlg(this.pageContext, PAGELINKS_JAVASCRIPT_KEY)) {
                writer.println("<script type=\"text/javascript\">");
                writer.println("<!--");
                writer.println("  function pageLinkSubmit(rowObj, indexObj, row, startIndex){");
                writer.println("    rowObj.value = row;");
                writer.println("    indexObj.value = startIndex;");
                if (this.forward) {
                    writer.print("    document.");
                    writer.print(formName);
                    writer.print(".");
                    writer.print(this.event);
                    writer.print(".value = \"");
                    writer.print(FORWARD_NAME);
                    writer.println("\";");
                }
                writer.print("    document.");
                writer.print(formName);
                writer.println(".submit();");
                writer.println("  }");
                writer.println("// -->");
                writer.println("</script>");
                this.setPageContextFlg(this.pageContext, PAGELINKS_JAVASCRIPT_KEY);
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
            throw new JspTagException(e.toString());
        }
    }

    protected void addPrevSubmit(StringBuilder sb, int row, int startIndex, int totalCount) {
        String formName = ActionFormUtil.getActionFormName((HttpServletRequest)this.pageContext.getRequest());
        for (int i = this.maxLinkNo; i > 0; --i) {
            String linkKey = PREV_LINKS + i + CHAR_LINKS;
            String linkValue = this.links.get(linkKey);
            if (linkValue == null || "".equals(linkValue)) continue;
            int index = startIndex - i * row;
            if (index < 0) {
                sb.append(linkValue + "&nbsp;");
                continue;
            }
            sb.append("<a href=\"#\" onclick=\"pageLinkSubmit(");
            sb.append("document.");
            sb.append(formName);
            sb.append(".");
            sb.append(this.rowProperty);
            sb.append(",");
            sb.append("document.");
            sb.append(formName);
            sb.append(".");
            sb.append(this.indexProperty);
            sb.append(",");
            sb.append(row);
            sb.append(",");
            sb.append(index);
            sb.append(")\">");
            sb.append(linkValue);
            sb.append("</a>&nbsp;");
        }
    }

    protected void addDirectSubmit(StringBuilder sb, int row, int startIndex, int totalCount) {
        String formName = ActionFormUtil.getActionFormName((HttpServletRequest)this.pageContext.getRequest());
        String directLinkNo = this.links.get(MAX_DSP_SIZE);
        if (directLinkNo != null) {
            try {
                this.maxPageCount = Integer.parseInt(directLinkNo);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int pageCount = this.getPageCount(row, totalCount);
        int pageIndex = this.getPageIndex(row, startIndex);
        int startPage = 0;
        int endPage = 0;
        if (pageCount > this.maxPageCount && pageIndex > this.maxPageCount / 2) {
            endPage = this.maxPageCount;
            startPage = pageIndex - endPage / 2 - 1;
            if (startPage + endPage > pageCount) {
                startPage = pageCount - endPage;
            }
        } else {
            endPage = pageCount < this.maxPageCount ? pageCount : this.maxPageCount;
            startPage = 0;
        }
        int size = startPage + endPage;
        for (int i = startPage; i < size; ++i) {
            int idx = i + 1;
            if (pageIndex == idx) {
                sb.append("<b>");
                sb.append(idx);
                sb.append("</b>&nbsp;");
                continue;
            }
            sb.append("<a href=\"#\" onclick=\"pageLinkSubmit(");
            sb.append("document.");
            sb.append(formName);
            sb.append(".");
            sb.append(this.rowProperty);
            sb.append(",");
            sb.append("document.");
            sb.append(formName);
            sb.append(".");
            sb.append(this.indexProperty);
            sb.append(",");
            sb.append(row);
            sb.append(",");
            sb.append(i * row);
            sb.append(")\">");
            sb.append(idx);
            sb.append("</a>&nbsp;");
        }
    }

    protected void addNextSubmit(StringBuilder sb, int row, int startIndex, int totalCount) {
        String formName = ActionFormUtil.getActionFormName((HttpServletRequest)this.pageContext.getRequest());
        for (int i = 1; i <= this.maxLinkNo; ++i) {
            String linkKey = NEXT_LINKS + i + CHAR_LINKS;
            String linkValue = this.links.get(linkKey);
            if (linkValue == null || "".equals(linkValue)) continue;
            int index = startIndex + i * row;
            if (index > totalCount - 1) {
                sb.append(linkValue + "&nbsp;");
                continue;
            }
            sb.append("<a href=\"#\" onclick=\"pageLinkSubmit(");
            sb.append("document.");
            sb.append(formName);
            sb.append(".");
            sb.append(this.rowProperty);
            sb.append(",");
            sb.append("document.");
            sb.append(formName);
            sb.append(".");
            sb.append(this.indexProperty);
            sb.append(",");
            sb.append(row);
            sb.append(",");
            sb.append(index);
            sb.append(")\">");
            sb.append(linkValue);
            sb.append("</a>&nbsp;");
        }
    }

    protected void addPrevLink(StringBuilder sb, int row, int startIndex, int totalCount) {
        TagUtils tagUtils = TagUtils.getInstance();
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        String url = null;
        url = response.encodeURL(tagUtils.getActionMappingURL(this.action, this.pageContext));
        for (int i = this.maxLinkNo; i > 0; --i) {
            String linkKey = PREV_LINKS + i + CHAR_LINKS;
            String linkValue = this.links.get(linkKey);
            if (linkValue == null || "".equals(linkValue)) continue;
            int index = startIndex - i * row;
            if (index < 0) {
                sb.append(linkValue + "&nbsp;");
                continue;
            }
            sb.append("<a href=\"" + url);
            if (url.indexOf("?") < 0) {
                sb.append("?");
            } else {
                sb.append("&");
            }
            sb.append(this.rowProperty);
            sb.append("=");
            sb.append(row);
            sb.append("&");
            sb.append(this.indexProperty);
            sb.append("=");
            sb.append(index);
            sb.append("\">");
            sb.append(linkValue);
            sb.append("</a>&nbsp;");
        }
    }

    protected void addDirectLink(StringBuilder sb, int row, int startIndex, int totalCount) {
        TagUtils tagUtils = TagUtils.getInstance();
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        String url = null;
        url = response.encodeURL(tagUtils.getActionMappingURL(this.action, this.pageContext));
        String directLinkNo = this.links.get(MAX_DSP_SIZE);
        if (directLinkNo != null) {
            try {
                this.maxPageCount = Integer.parseInt(directLinkNo);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int pageCount = this.getPageCount(row, totalCount);
        int pageIndex = this.getPageIndex(row, startIndex);
        int startPage = 0;
        int endPage = 0;
        if (pageCount > this.maxPageCount && pageIndex > this.maxPageCount / 2) {
            endPage = this.maxPageCount;
            startPage = pageIndex - endPage / 2 - 1;
            if (startPage + endPage > pageCount) {
                startPage = pageCount - endPage;
            }
        } else {
            endPage = pageCount < this.maxPageCount ? pageCount : this.maxPageCount;
            startPage = 0;
        }
        int size = startPage + endPage;
        for (int i = startPage; i < size; ++i) {
            int idx = i + 1;
            if (pageIndex == idx) {
                sb.append("<b>");
                sb.append(idx);
                sb.append("</b>&nbsp;");
                continue;
            }
            sb.append("<a href=\"" + url);
            if (url.indexOf("?") < 0) {
                sb.append("?");
            } else {
                sb.append("&");
            }
            sb.append(this.rowProperty);
            sb.append("=");
            sb.append(row);
            sb.append("&");
            sb.append(this.indexProperty);
            sb.append("=");
            sb.append(i * row);
            sb.append("\">");
            sb.append(idx);
            sb.append("</a>&nbsp;");
        }
    }

    protected void addNextLink(StringBuilder sb, int row, int startIndex, int totalCount) {
        TagUtils tagUtils = TagUtils.getInstance();
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        String url = null;
        url = response.encodeURL(tagUtils.getActionMappingURL(this.action, this.pageContext));
        for (int i = 1; i <= this.maxLinkNo; ++i) {
            String linkKey = NEXT_LINKS + i + CHAR_LINKS;
            String linkValue = this.links.get(linkKey);
            if (linkValue == null || "".equals(linkValue)) continue;
            int index = startIndex + i * row;
            if (index > totalCount - 1) {
                sb.append(linkValue + "&nbsp;");
                continue;
            }
            sb.append("<a href=\"" + url);
            if (url.indexOf("?") < 0) {
                sb.append("?");
            } else {
                sb.append("&");
            }
            sb.append(this.rowProperty);
            sb.append("=");
            sb.append(row);
            sb.append("&");
            sb.append(this.indexProperty);
            sb.append("=");
            sb.append(index);
            sb.append("\">");
            sb.append(linkValue);
            sb.append("</a>&nbsp;");
        }
    }

    private void getLinkProperty() {
        Enumeration enume = PropertyUtil.getPropertyNames((String)PAGE_LINKS_PREFIX);
        while (enume.hasMoreElements()) {
            String propName = (String)enume.nextElement();
            String id = propName.substring(PAGE_LINKS_PREFIX.length());
            String link = PropertyUtil.getProperty((String)propName);
            if (id != null && (id.startsWith(PREV_LINKS) || id.startsWith(NEXT_LINKS))) {
                String strLinkNo = id.substring(4, id.lastIndexOf(CHAR_LINKS));
                int intLinkNo = 0;
                try {
                    intLinkNo = Integer.parseInt(strLinkNo);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                if (intLinkNo > this.maxLinkNo) {
                    this.maxLinkNo = intLinkNo;
                }
                this.links.put(id, link);
                continue;
            }
            if (!MAX_DSP_SIZE.equals(id)) continue;
            this.links.put(id, link);
        }
    }

    protected int getPageIndex(int row, int startIndex) {
        int pageIndex = 0;
        pageIndex = row > 0 ? startIndex / row + 1 : 0;
        if (row > 0 && startIndex % row > 0) {
            ++pageIndex;
        }
        return pageIndex;
    }

    protected int getPageCount(int row, int totalCount) {
        int pageCount = 0;
        if (row > 0) {
            pageCount = totalCount / row;
            if (totalCount % row > 0) {
                ++pageCount;
            }
        } else {
            pageCount = 1;
        }
        return pageCount;
    }

    protected boolean getPageContextFlg(PageContext pageContext, String key) {
        Object obj = pageContext.getAttribute(key);
        Boolean bol = new Boolean(false);
        if (obj != null && obj instanceof Boolean) {
            bol = (Boolean)obj;
        }
        return bol;
    }

    protected void setPageContextFlg(PageContext pageContext, String key) {
        pageContext.setAttribute(key, (Object)true);
    }

    protected Object lookup(PageContext pageContext, String name, String property, String scope) throws JspException {
        if (property == null || "".equals(property)) {
            return null;
        }
        Object retObj = null;
        retObj = name != null && !"".equals(name) ? TagUtils.getInstance().lookup(pageContext, name, property, scope) : TagUtils.getInstance().lookup(pageContext, property, scope);
        return retObj;
    }

    protected int getInt(Object obj) throws JspException {
        int retInt = 0;
        String value = ObjectUtils.toString((Object)obj);
        if (!"".equals(value)) {
            try {
                retInt = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                log.error((Object)e.getMessage());
                throw new JspException((Throwable)e);
            }
        }
        return retInt;
    }

    protected void attributePageCount(int now, int total) {
        if (total <= 0) {
            now = 0;
        }
        if (this.currentPageIndex != null && !"".equals(this.currentPageIndex)) {
            this.pageContext.setAttribute(this.currentPageIndex, (Object)now);
        } else {
            this.pageContext.setAttribute(CURRENT_PAGE_INDEX, (Object)now);
        }
        if (this.totalPageCount != null && !"".equals(this.totalPageCount)) {
            this.pageContext.setAttribute(this.totalPageCount, (Object)total);
        } else {
            this.pageContext.setAttribute(TOTAL_PAGE_COUNT, (Object)total);
        }
    }

    public void release() {
        super.release();
        this.id = null;
        this.action = null;
        this.name = null;
        this.rowProperty = null;
        this.indexProperty = null;
        this.totalProperty = null;
        this.scope = null;
        this.submit = false;
        this.forward = false;
        this.event = DEFAULT_EVENT;
        this.resetIndex = false;
        this.currentPageIndex = CURRENT_PAGE_INDEX;
        this.totalPageCount = TOTAL_PAGE_COUNT;
    }
}

