/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.init;

import jp.terasoluna.fw.batch.core.AbstractCollector;
import jp.terasoluna.fw.batch.core.CollectedDataHandler;
import jp.terasoluna.fw.batch.core.CollectorException;
import jp.terasoluna.fw.batch.core.CollectorResult;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.batch.springsupport.transaction.TransactionalJobStatus;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 񓯊WuÑWu˗擾pNXB
 *
 */
public class JobRequestInfoCollector extends AbstractCollector {

    /**
     * OCX^XB
     */
    private static Log log = LogFactory
            .getLog(JobRequestInfoCollector.class);
    
    /**
     * WuǗe[unhNX̃CX^XB
     */
    protected JobControlTableHandler jobControlTableHandler = null;

    /**
     * WuǗe[ůĎibjB
     */
    private long intervalSeconds = 0L;

    /**
     * tbVJEgB
     */
    private int refreshCount = 0;

    /**
     * sWu`t@CpXB
     */
    protected String jobBeanPath = null;

    /**
     * Wu˗擾AĎ̎sB<BR>
     * WuĎs擾Ώۂ̃Wuꍇ̓f[NpWuBean`
     * ̊ĎԂҋ@AĎ擾sB<BR>
     * Wu˗̎擾͒O擾WuNGXgԍ傫̂
     * 邪̏̓f[NpWuBean`̃tbVԍ̉񐔖
     * ɃtbVB
     * 
     *
     * @param jobContext WuReLXg
     * @param collectedDataHandler [JL[
     * @param jobStatus 
     * @return RN^
     */
    @Override
    protected CollectorResult doCollect(JobContext jobContext, 
            CollectedDataHandler collectedDataHandler,
            JobStatus jobStatus) {

        int collected = 0;
        int selectCount = 0;
        JobInfo jobControlInfo = null;
        
        TransactionalJobStatus transactionalJobStatus = 
            (TransactionalJobStatus) jobStatus;

        while (true) {
            
            jobControlInfo = getJobMessageInfo(selectCount, jobControlInfo);

            if (jobControlInfo == null) {
                try {
                    Thread.sleep(intervalSeconds * 1000);
                    selectCount = 0;
                } catch (InterruptedException e) {
                    throw new CollectorException(e, null);
                }
            } else {
                transactionalJobStatus.beginTransaction();
                //L[ɓOɃWuN󋵂JnɍXVB
                int count = updateJobStart(jobControlInfo);
                
                // XVɐꍇ̂݌ʂL[ɓB
                if (count == 1) {
                    collectedDataHandler.handle(jobControlInfo, collected++);
                    transactionalJobStatus.commit();
                } else {
                    transactionalJobStatus.rollback();
                }
                
                if (jobBeanPath != null) {
                    overrideDescriptionPath(jobControlInfo);
                }

                // f[I`FbN
                if (AbstractJobControlInfo.STOP_DEMON.equals(jobControlInfo
                        .getJobId())) {
                    if (log.isDebugEnabled()) {
                        log.debug("stopped batch daemon ");
                    }
                    collectedDataHandler.close();
                    return 
                        new CollectorResult(ReturnCode.NORMAL_END, collected);
                }
                
                // e[ǔʒuB
                if (selectCount >= refreshCount) {
                    selectCount = 0;
                } else {
                    selectCount++;
                }
            }
        }
    }

    
    /**
     * L[ɓOɃWuN󋵂JnɍXV
     * 
     * @param jobInfo ΏۃWu
     * @return XVs
     */
    protected int updateJobStart(JobInfo jobInfo) {
        return jobControlTableHandler.updateJobStart(jobInfo);
    }
    
    /**
     * Ώۃf[^̎擾
     * 
     * @param selectCount 擾f[^
     * @param jobInfo ΏۃWu
     * @return ΏۃWu
     */
    protected JobInfo getJobMessageInfo(int selectCount, JobInfo jobInfo) {
        // Wu˗̎擾
        if (selectCount == 0) {
            return jobControlTableHandler.getJobRequestData();
        } else {
            return jobControlTableHandler.getJobRequestData(jobInfo);
        }
    }

    /**
     * WuBean`pX̏㏑
     * 
     * @param jobInfo ΏۃWu 
     */
    protected void overrideDescriptionPath(JobInfo jobInfo) {
        // ㏑͂Ȃ
    }
    
    /**
     * WuǗe[unhNX̃CX^Xݒ肷B
     *
     * @param jobControlTableHandler WuǗe[unhNX̃CX^
     * X
     */
    public void setJobControlTableHandler(
            JobControlTableHandler jobControlTableHandler) {
        this.jobControlTableHandler = jobControlTableHandler;
    }

    /**
     * Ďݒ肷B
     *
     * @param intervalSeconds Ďibj
     */
    public void setIntervalSeconds(long intervalSeconds) {
        this.intervalSeconds = intervalSeconds;
    }
    
    /**
     * tbVJEgݒ肷B
     * @param refreshCount tbVJEgB
     */
    public void setRefreshCount(int refreshCount) {
        this.refreshCount = refreshCount;
    }
    
    /**
     * sWu`t@CpXB
     * 
     * @param jobBeanPath sWu`t@CpX
     */
    public void setJobBeanPath(String jobBeanPath) {
        throw new UnsupportedOperationException();
    }
}
