/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.validation;

import org.springframework.validation.BindException;

import jp.terasoluna.fw.batch.core.JobException;

/**
 * ̓`FbNpONXB
 * 
 * <p>̓`FbNA̓`FbNG[oꂽꍇA
 * ̗O𔭐<code>Collector</code>𒆒fB</p>
 * <p>̃NXł́A<code>BindException</code>AOɓ͂ꂽĂ
 * ̓f[^AێB</p>
 * <p>̓`FbNG[̏ڍׂȓe͌O<code>BindException</code>
 * 邱Ƃŕ͂邱ƂłB</p>
 *
 */
public class ValidateException extends JobException {

    /**
     * Serializablepo[WID
     */
    private static final long serialVersionUID = -841154748141051078L;

    /**
     * ̓f[^
     */
    private Object inputData = null;

    /**
     * RXgN^B
     *
     * @param bindException O
     */
    public ValidateException(BindException bindException) {
        super(bindException);
    }

    /**
     * RXgN^B
     *
     * @param bindException O
     * @param inputData ̓f[^
     */
    public ValidateException(BindException bindException, Object inputData) {
        super(bindException);
        this.inputData = inputData;
    }

    /**
     * ̓f[^擾B
     *
     * @return ̓f[^
     */
    public Object getInputData() {
        return inputData;
    }

}
