/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.oxm.xsd.xerces;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;

import jp.terasoluna.fw.oxm.xsd.exception.IllegalSchemaDefinitionException;
import jp.terasoluna.fw.oxm.xsd.exception.UnknownXMLDataException;
import jp.terasoluna.fw.oxm.xsd.message.ErrorMessage;
import jp.terasoluna.fw.oxm.xsd.message.ErrorMessages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;

/**
 * XMLf[^̃p[X̏ڍׂȃG[ƂāAtB[h߁AXMLErrorReporter̊gsNXB
 * <p>
 * tB[hƂ́A``FbÑG[ӏ肷邽߂̏łB<br>
 * X^bNɊi[ĂvfɃCfbNXthbgi"."jŘAA tB[h𐶐B<br>
 * vf̐P̏ꍇłAKCfbNXtB ɂ̓CfbNXtȂB<br>
 * G[ꍇɐtB[h̃TvȉɋLB
 * </p>
 * <p>
 * yXMLf[^̃Tvz <br>
 * <code><pre>
 *   &lt;sample-dto param-d=&quot;...&quot;&gt;
 *     &lt;param-a&gt;
 *       &lt;param-b&gt;
 *         &lt;param-c&gt;...&lt;/param-c&gt;
 *       &lt;/param-b&gt;
 *     &lt;/param-a&gt;
 *   &lt;/sample-dto&gt;
 * </pre></code>
 * </p>
 * <p>
 * LXMLf[^param-cvfɕsȒl͂ꂽꍇɐtB[hȉɋLB<br>
 * tB[hF<code><b>sample-dto[0].param-a[0].param-b[0].param-c[0]</code></b><br>
 * vf̐PłCfbNXtĂB
 * </p>
 * <p>
 * LXMLf[^param-dɕsȒl͂ꂽꍇɐtB[hȉɋLB<br>
 * tB[hF<code><b>sample-dto[0].param-a[0].param-b[0].param-d</code></b><br>
 * ɂ̓CfbNXtĂȂB
 * </p>
 * <p>
 * <b>``FbNŐG[R[h</b>
 * <p>
 * ``FbNŔG[R[ḧꗗȉɋLB<br>
 * <table border="1" CELLPADDING="8">
 * <tr>
 * <th>G[R[h</th>
 * <th>u</th>
 * <th></th>
 * </tr>
 * <tr>
 * <td>typeMismatch.number</td>
 * <td>{͂ꂽl, f[^^}</td>
 * <td>sȐl͂ꂽꍇ</td>
 * </tr>
 * <tr>
 * <td>typeMismatch.boolean</td>
 * <td>{͂ꂽl, f[^^}</td>
 * <td>sbooleanl͂ꂽꍇ</td>
 * </tr>
 * <tr>
 * <td>typeMismatch.date</td>
 * <td>{͂ꂽl, f[^^}</td>
 * <td>sȓt͂ꂽꍇ</td>
 * </tr>
 * <tr>
 * <td>typeMismatch.numberMaxRange</td>
 * <td>{͂ꂽl, f[^^̍ől, f[^^}</td>
 * <td>`ꂽ^̍ől傫l͂ꂽꍇ</td>
 * </tr>
 * <tr>
 * <td>typeMismatch.numberMinRange</td>
 * <td>{͂ꂽl, f[^^̍ŏl, f[^^}</td>
 * <td>`ꂽ^̍ŏl菬l͂ꂽꍇ</td>
 * </tr>
 * </table>
 * </p>
 * <p>
 * <b>``FbNTv</b>
 * </p>
 * <p>
 * XL[}`t@CXMLf[^̌``
 * </p>
 * <p>
 * yXL[}`t@Cݒz<br>
 * <code><pre>
 *    &lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot;?&gt;
 *    &lt;xs:schema xmlns:xs=&quot;http://www.w3.org/2001/XMLSchema&quot;&gt;
 *      &lt;xs:element name=&quot;int-param&quot; type=&quot;int-param-type&quot;/&gt;
 *      &lt;xs:complexType name=&quot;int-param-type&quot;&gt;
 *        &lt;xs:sequence&gt;
 *          &lt;xs:element name=&quot;param1&quot; type=&quot;xs:int&quot; /&gt;
 *          &lt;xs:element name=&quot;param2&quot; type=&quot;xs:int&quot; /&gt;
 *        &lt;/xs:sequence&gt;
 *      &lt;xs:attribute name=&quot;param3&quot; type=&quot;xs:int&quot;/&gt;
 *      &lt;/xs:complexType&gt;
 *    &lt;/xs:schema&gt;
 * </pre></code>
 * </p>
 * <p>
 * vf(param2)Ƒ(param3)ɕsȒli[ꂽXMLf[^͂
 * </p>
 * <p>
 * y͂XMLf[^z<br>
 * <code><pre>
 *   &lt;int-param param3=&quot;30b&quot;&gt;
 *   &lt;param1&gt;100&lt;/param1&gt; 
 *   &lt;param2&gt;20a&lt;/param2&gt;
 *   &lt;/int-param&gt;
 * </pre></code>
 * </p>
 * <p>
 * ``FbNŃG[AG[bZ[Wi[ꂽCX^XB<br>
 * G[bZ[W̓K؂ȃnhOsƁB
 * </p>
 * <p>
 * yparam2̃G[bZ[Wi[ꂽCX^Xz<br>
 * <code><pre>
 *    tB[hFint-param[0].param2[0]
 *    G[R[hFtypeMismatch.number
 *    uF{20a, integer}
 * </pre></code>
 * </p>
 * <p>
 * yparam3̃G[bZ[Wi[ꂽCX^Xz<br>
 * <code><pre>
 *    tB[hFint-param[0].param3
 *    G[R[hFtypeMismatch.number
 *    uF{30b, integer}
 * </pre></code>
 * </p>
 * <p>
 * <b>nullli󕶎j̋e</b>
 * </p>
 * <p>
 * XMLXL[}̎dlł́Al^̗vf̒lnullle邱Ƃ͂łȂB<br>
 * l^̗vf̒lnullleꍇ́AƎ̃f[^^錾邱ƁB<br>
 * Ǝ̃f[^^錾ꍇ́AAllowEmptyt邱ƁBiG[̃nhOs߂ɕKvj<br>
 * nulllƂ́Au<code>&lt;param&gt;&lt;/param&gt;</code>v̂悤ɗvf̒lƂċ󕶎ݒ肳邱ƂwB
 * </p>
 * <p>
 * yl^̗vfuparamvnullleꍇ̃XL[}`t@Cݒz<br>
 * <code><pre>
 *     &lt;xs:simpleType name=&quot;integerAllowEmpty&quot;&gt;
 *       &lt;xs:union&gt;
 *         &lt;xs:simpleType&gt;
 *           &lt;xs:restriction base=&quot;xs:string&quot;&gt;
 *             &lt;xs:enumeration value=&quot;&quot; /&gt;
 *           &lt;/xs:restriction&gt;
 *         &lt;/xs:simpleType&gt;
 *         &lt;xs:simpleType&gt;
 *           &lt;xs:restriction base=&quot;xs:integer&quot; /&gt;
 *         &lt;/xs:simpleType&gt;
 *       &lt;/xs:union&gt;
 *     &lt;/xs:simpleType&gt;
 *     &lt;xs:element name=&quot;param&quot; type=&quot;integerAllowEmpty&quot; /&gt;
 * </pre></code>
 * </p>
 * 
 * @see jp.terasoluna.fw.oxm.xsd.xerces.SchemaValidatorImpl
 * @see jp.terasoluna.fw.oxm.xsd.message.ErrorMessages
 * @see jp.terasoluna.fw.oxm.xsd.message.ErrorMessage
 * @see jp.terasoluna.fw.oxm.xsd.xerces.XMLSchemaValidatorEx
 * 
 */
public class XMLErrorReporterEx extends XMLErrorReporter {

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(XMLErrorReporterEx.class);

    /**
     * XML̗vfƂɍŏICfbNXMap`ŎCX^XB
     * <p>
     * CfbNX̗vfŃCfbNXlێB<br>
     * w肷vf͏ʃ^O܂݁Aŉʃ^OɑΉvf̃CfbNX擾łB
     * </p>
     */
    private Map<String, Integer> tagIndex = new HashMap<String, Integer>();

    /**
     * ̗͒vfێX^bNB
     * <p>
     * tB[h񐶐̍ۂɎgpB
     * </p>
     */
    private Stack<String> tagStack = new Stack<String>();

    /**
     * ``FbÑG[bZ[Wi[CX^XB
     */
    private ErrorMessages errorMessages = null;

    /**
     * \[Xohst@C̐ړ
     */
    protected static final String XERCES_RESOURCE_BUNDLE_PREFIX = "org/apache/xerces/impl/msg/XMLSchemaMessages";

    /**
     * nulleꍇɒ`Ǝ̃f[^^̖ɕt镶
     */
    protected static final String ALLOW_EMPTY_SUFFIX = "AllowEmpty";

    /**
     * bZ[WohsȂƂɎgpG[R[h̃vtBbNX
     */
    protected static final String ERROR_CODE_PREFIX = "typeMismatch";

    /**
     * ``FbNőɕsȃf[^^̒l͂ꂽꍇɁAo͂G[R[hB
     */
    protected static final String ATTRIBUTE_ERROR_CODE = "cvc-attribute.3";

    /**
     * ``FbNŗvfɕsȃf[^^̒l͂ꂽꍇɁAo͂G[R[hB
     */
    protected static final String ELEMENT_ERROR_CODE = "cvc-type.3.1.3";

    /**
     * ``FbNŕsȃf[^^̒l͂ꂽꍇɁAo͂G[R[h
     */
    protected static final String DATATYPE_ERROR_CODE = "cvc-datatype-valid.1.2.1";

    /**
     * ``FbNunion`̃G[ꍇɁAo͂G[R[h
     * <p>
     * l^nulleƎ̃f[^^̐錾ɂunion`p̂ŁA sȒl͂ꂽꍇÃG[
     * </p>
     */
    protected static final String UNION_ERROR_CODE = "cvc-datatype-valid.1.2.3";

    /**
     * ``FbNŐl^̍ől傫l͂ꂽꍇɏo͂G[R[h
     */
    protected static final String MAXINCLUSIVE_ERROR_CODE = "cvc-maxInclusive-valid";

    /**
     * ``FbNŐl^̍ŏl菬l͂ꂽꍇɏo͂G[R[h
     */
    protected static final String MININCLUSIVE_ERROR_CODE = "cvc-minInclusive-valid";

    /**
     * ``FbNŁAXMLf[^̌`ɖ肪ꍇɏo͂G[R[h̃vtBbNX
     */
    protected static final String XML_DATA_ERROR_CODE_PREFIX = "cvc-";

    /**
     * l^̃tB[hɕsȒl͂ꂽꍇ̃G[R[h
     */
    protected static final String NUMBER_ERROR_CODE = "number";

    /**
     * boolean^̃tB[hɕsȒl͂ꂽꍇ̃G[R[h
     */
    protected static final String BOOLEAN_ERROR_CODE = "boolean";

    /**
     * date^̃tB[hɕsȒl͂ꂽꍇ̃G[R[h
     */
    protected static final String DATE_ERROR_CODE = "date";

    /**
     * l^̃tB[hɁA`ꂽl^̍ől傫l͂ꂽꍇ̃G[R[h
     */
    protected static final String NUMBERMINRANGE_ERROR_CODE = "numberMinRange";

    /**
     * l^̃tB[hɁA`ꂽl^̍ŏl菬l͂ꂽꍇ̃G[R[h
     */
    protected static final String NUMBERMAXRANGE_ERROR_CODE = "numberMaxRange";

    /**
     * tB[h̃Zp[^
     */
    protected static final String FIELD_SEPARATOR = ".";

    /**
     * G[R[h̃Zp[^
     */
    protected static final String ERROR_CODE_SEPARATOR = ".";

    /**
     * boolean^ƂănhOXMLXL[}̃f[^^
     */
    protected static final String DATATYPE_BOOLEAN = "boolean";

    /**
     * t^ƂănhOXMLXL[}̃f[^^
     */
    protected static final List DATATYPE_DATE = Arrays.asList(new String[] {
            "date", "time", "dateTime" });

    /**
     * f[^^̃G[ŐG[bZ[W̃tB[hɁAǉ邽߁ACX^X̎QƂۑB
     */
    private ErrorMessage tmpErrorMessage = null;

    /**
     * RXgN^
     * 
     * @param errorMessages
     *            G[bZ[W̃Xg
     */
    public XMLErrorReporterEx(ErrorMessages errorMessages) {
        super();
        this.errorMessages = errorMessages;
    }

    /**
     * G[bZ[W̃Xgԋp
     * 
     * @return G[bZ[W̃Xg
     */
    public ErrorMessages getErrorMessages() {
        return errorMessages;
    }

    /**
     * ``FbNŔG[𗘗pāAG[bZ[W𐶐B
     * 
     * @param location
     *            XML̈ʒu擾IuWFNg
     * @param domain
     *            G[hC
     * @param key
     *            ``FbÑG[ŔG[R[h
     * @param arguments
     *            ``FbÑG[Ŕu
     * @param severity
     *            G[x
     * @throws XNIException
     *             p[TŔsO
     */
    @Override
    public void reportError(XMLLocator location, String domain, String key,
            Object[] arguments, short severity) throws XNIException {
        super.reportError(location, domain, key, arguments, severity);

        String[] options = null;

        if (arguments == null) {
            options = new String[] {};
        } else {
            // ``FbÑG[Ŕu擾
            options = new String[arguments.length];

            // G[bZ[W̒u𐶐
            for (int i = 0; i < arguments.length; i++) {
                if (arguments[i] == null) {
                    options[i] = null;
                } else {
                    options[i] = arguments[i].toString();
                }
            }
        }

        // ``FbNŔG[̏Oɏo͂
        errorLog(key, options);

        // G[bZ[W𐶐
        addErrorMessage(key, options);

    }

    /**
     * ͂ꂽvfɃCfbNXtĕԋpB
     * <p>
     * vfɂ́Az̗LɊւ炸[ ]tB
     * </p>
     * 
     * @param element
     *            vf
     * @return CfbNX̒ltꂽvf
     */
    protected String indexResolve(String element) {
        // CfbNX0n܂
        Integer index = 0;
        // CfbNX̃L[𐶐
        StringBuilder tagIndexKey = new StringBuilder(getField());
        tagIndexKey.append(element);
        // CfbNX̃L[ɑΉl擾
        Integer val = this.tagIndex.get(tagIndexKey.toString());
        // lo^Ăꍇ́ACfbNX̒lCNg
        if (val != null) {
            index = val + 1;
        }
        // CfbNX̃L[ƒlo^
        this.tagIndex.put(tagIndexKey.toString(), index);

        StringBuilder retStr = new StringBuilder();
        retStr.append(element);
        retStr.append("[");
        retStr.append(index);
        retStr.append("]");
        return retStr.toString();
    }

    /**
     * G[tB[hԋp
     * 
     * @return G[tB[h
     */
    private String getField() {
        StringBuilder key = new StringBuilder();
        for (String tagstr : tagStack) {
            // X^bNɊi[ĂlhbgŘA
            key.append(tagstr);
            key.append(FIELD_SEPARATOR);
        }
        return key.toString();
    }

    /**
     * ``FbNŔG[̏ϊAƎ̃G[bZ[WCX^X𐶐B
     * <p>
     * XercesŔf[^^̃G[ɊւĂ̂݁AƎ̃G[bZ[W𐶐B<br>
     * ȊÕG[ꍇ́AOX[B
     * <p>
     * <p>
     * XercesŃf[^^̃G[ꍇAvfEɊւG[B<br>
     * Ⴆ΁AvfōőlG[ꍇAf[^^̃G[ƗvfG[B<br>
     * 鑮Ńf[^^̃G[ꍇAf[^^̃G[Ƒ̃G[B
     * </p>
     * <p>
     * vfẼG[́Af[^^̃G[ƂقړẽG[̂ŁAG[bZ[W͐ȂB
     * </p>
     * f[^^̃G[̈ꗗȉɋLB<br>
     * <table border="1" CELLPADDING="8">
     * <tr>
     * <th>Xerces̃G[R[h</th>
     * <th>Ǝ̃G[R[h</th>
     * <th>Ǝ̒u</th>
     * <th></th>
     * </tr>
     * <tr>
     * <td>cvc-datatype-valid.1.2.1</td>
     * <td>typeMismatch.number<br>
     * typeMismatch.boolean<br>
     * typeMismatch.date</td>
     * <td>{sȒl, f[^^}</td>
     * <td>sȒl͂ꂽꍇ</td>
     * </tr>
     * <tr>
     * <td>cvc-maxInclusive-valid</td>
     * <td>typeMismatch.numberMaxRange</td>
     * <td>{sȒl, f[^^̍ől, f[^^}</td>
     * <td>l^̍ől傫l͂ꂽꍇ</td>
     * </tr>
     * <tr>
     * <td>cvc-minInclusive-valid</td>
     * <td>typeMismatch.numberMinRange</td>
     * <td>{sȒl, f[^^̍ŏl, f[^^}</td>
     * <td>l^̍ŏl菬l͂ꂽꍇ</td>
     * </tr>
     * <tr>
     * <td>cvc-datatype-valid.1.2.3</td>
     * <td>typeMismatch.numberMinRange</td>
     * <td>{sȒl, f[^^}</td>
     * <td>nullletB[hɁAsȒl͂ꂽꍇ</td>
     * </tr>
     * </table>
     * </p>
     * <p>
     * vfẼG[̈ꗗLɎB<br>
     * <table border="1" CELLPADDING="8">
     * <tr>
     * <th>XercesŔG[R[h</th>
     * <th></th>
     * </tr>
     * <tr>
     * <td>cvc-type.3.1.3</td>
     * <td>vfɕsȒl͂ꂽꍇ</td>
     * </tr>
     * <tr>
     * <td>cvc-attribute.3</td>
     * <td>ɕsȒl͂ꂽꍇ</td>
     * </tr>
     * </table>
     * </p>
     * <p>
     * ̃G[ꍇAuƂĊi[Ă鑮AG[bZ[W̃tB[hɕtB<br>
     * </p>
     * 
     * @param key
     *            G[R[h
     * @param options
     *            u
     */
    protected void addErrorMessage(String key, String[] options) {

        String messageID = null;

        // XercesŔG[bZ[W̃nhOs
        if (ELEMENT_ERROR_CODE.equals(key)) {
            // vf̃G[̓nhOȂ
            return;
        } else if (ATTRIBUTE_ERROR_CODE.equals(key)) {
            if (tmpErrorMessage != null) {
                // tB[hɑt
                StringBuilder fieldStr = new StringBuilder();
                fieldStr.append(tmpErrorMessage.getField());
                fieldStr.append(FIELD_SEPARATOR);
                fieldStr.append(options[1]);
                tmpErrorMessage.setField(fieldStr.toString());
            }
            // ̃G[̓nhOȂ
            return;
        } else if (DATATYPE_ERROR_CODE.equals(key)) {
            // tB[hɒ`Ăf[^^łȂl͂ꂽꍇɁÃG[
            if (DATATYPE_BOOLEAN.equals(options[1])) {
                messageID = ERROR_CODE_PREFIX + ERROR_CODE_SEPARATOR
                        + BOOLEAN_ERROR_CODE;
            } else if (DATATYPE_DATE.contains(options[1])) {
                messageID = ERROR_CODE_PREFIX + ERROR_CODE_SEPARATOR
                        + DATE_ERROR_CODE;
            } else {
                messageID = ERROR_CODE_PREFIX + ERROR_CODE_SEPARATOR
                        + NUMBER_ERROR_CODE;
            }
        } else if (UNION_ERROR_CODE.equals(key)
                && options[1].endsWith(ALLOW_EMPTY_SUFFIX)) {
            // l^nullletB[hɁAsȒl͂ꂽꍇɁÃG[
            // f[^^̕񂩂"AllowEmpty"폜āAuɊi[
            options[1] = (options[1]).substring(0, (options[1])
                    .indexOf(ALLOW_EMPTY_SUFFIX));
            messageID = ERROR_CODE_PREFIX + ERROR_CODE_SEPARATOR
                    + NUMBER_ERROR_CODE;
            // svȒu폜
            String[] tmpOptions = new String[2];
            System.arraycopy(options, 0, tmpOptions, 0, 2);
            options = tmpOptions;
        } else if (MAXINCLUSIVE_ERROR_CODE.equals(key)) {
            // ^̍ől傫l͂ꂽꍇɁÃG[
            messageID = ERROR_CODE_PREFIX + ERROR_CODE_SEPARATOR
                    + NUMBERMAXRANGE_ERROR_CODE;
        } else if (MININCLUSIVE_ERROR_CODE.equals(key)) {
            // ^̍ŏl菬l͂ꂽꍇɁÃG[
            messageID = ERROR_CODE_PREFIX + ERROR_CODE_SEPARATOR
                    + NUMBERMINRANGE_ERROR_CODE;
        } else if (key.startsWith(XML_DATA_ERROR_CODE_PREFIX)) {
            // XMLf[^̍\ɃG[ƍlꍇAOX[
            log.error("xml data is invalid.");
            throw new UnknownXMLDataException();
        } else {
            // XL[}̂ɖ肪ƍlꍇAOX[
            log.error("schema is invalid.");
            throw new IllegalSchemaDefinitionException();
        }

        ErrorMessage errorMessage = new ErrorMessage(messageID, "", options);

        // G[bZ[WɃtB[hݒ肷
        errorMessage.setField(getField().substring(0, getField().length() - 1));
        // G[bZ[W̃Xgɒǉ
        errorMessages.add(errorMessage);
        // G[bZ[W̎QƂۑ
        tmpErrorMessage = errorMessage;

    }

    /**
     * ``FbNŔG[̏Oɏo͂
     * 
     * @param key
     *            G[R[h
     * @param options
     *            u
     */
    protected void errorLog(String key, Object[] options) {

        StringBuilder buf = new StringBuilder();

        // sR[h̎擾
        String lineSeparator = System.getProperty("line.separator");

        buf.append("Schema error[]------------------------");
        buf.append(lineSeparator);
        // tB[h
        if (getField().length() > 0) {
            buf.append("xpath="
                    + getField().substring(0, getField().length() - 1));
        } else {
            buf.append("xpath=" + getField());
        }
        buf.append(lineSeparator);
        buf.append("getMessage=");
        // Xerces̃G[bZ[W
        buf.append(getMessage(key, options));
        buf.append(lineSeparator);
        buf.append("key=");
        buf.append(key);
        // Xerces̃G[R[h
        buf.append(lineSeparator);
        StringBuilder argNo = new StringBuilder();
        for (int i = 0; i < options.length; i++) {
            argNo.setLength(0);
            argNo.append("arg[");
            argNo.append(i);
            argNo.append("]=");
            buf.append(argNo.toString());
            // Xerces̒u
            buf.append(options[i]);
            buf.append(lineSeparator);
        }
        buf.append("-----------------------------------------");
        buf.append(lineSeparator);

        log.error(buf.toString());
    }

    /**
     * Xerces̃\[XohpĐbZ[WԋpB
     * 
     * @param key
     *            G[R[h
     * @param options
     *            u
     * @return G[bZ[W
     */
    private String getMessage(String key, Object[] options) {

        String message = null;
        try {
            // \[Xoh擾
            ResourceBundle bundle = ResourceBundle
                    .getBundle(XERCES_RESOURCE_BUNDLE_PREFIX);
            // G[R[hɑΉ郁bZ[W擾
            message = bundle.getString(key);
        } catch (MissingResourceException e) {
            return "[[" + e.getMessage() + "]]";
        }
        // v[XtH_uꂽbZ[W𐶐
        return MessageFormat.format(message, options);

    }

    /**
     * ͒̃tB[hێX^bNԋp
     * 
     * @return ͒̃tB[hێX^bN
     */
    public Stack<String> getTagStack() {
        return tagStack;
    }

}
