/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.controller;

import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.fw.web.rich.springmvc.controller.UnkownRequestNameController;
import jp.terasoluna.fw.web.rich.springmvc.exception.UnknownRequestNameException;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.rich.springmvc.controller.
 * UnkownRequestNameController} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * sȃNGXgNGXgĂꍇɎs
 * NGXgRg[B<br>
 * OFHTTPNGXgAHTTPX|XNulllɂȂȂB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.rich.springmvc.controller.
 * UnkownRequestNameController
 */
public class UnkownRequestNameControllerTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(UnkownRequestNameControllerTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public UnkownRequestNameControllerTest(String name) {
        super(name);
    }

    /**
     * testHandleRequest01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() request:gpȂ<br>
     *         () response:gpȂ<br>
     *         
     * <br>
     * ҒlF(ԕω) O:UnknownRequestNameException<br>
     *         
     * <br>
     * NGXgRg[ȂꍇɌĂ΂Rg[̃eXgB
     * KO𔭐B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testHandleRequest01() throws Exception {
        // O
        UnkownRequestNameController controller = 
            new UnkownRequestNameController();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        try {
            controller.handleRequest(request, response);
            fail();
        } catch (UnknownRequestNameException e) {
            // OK
        	return;
        }
    }
}
