/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.service.thin;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.service.thin.BLogicProperty} NX
 * ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * rWlXWbNo͏̌X̃vpeBێNXB<br>
 * BLogicIOPlugInŃrWlXWbNo͏`t@Cłblogic-io.xmlA
 * rWlXWbNɑ΂JavaBeanyяoJavaBeañvpeBݒێB
 * <p>
 * 
 * @see jp.terasoluna.fw.service.thin.BLogicProperty
 */
public class BLogicPropertyTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(BLogicPropertyTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public BLogicPropertyTest(String name) {
        super(name);
    }

    /**
     * testGetProperty01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () property:"property"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"property"<br>
     *         
     * <br>
     * BLogicPropertyɊi[Ăproperty𐳏Ɏ擾邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetProperty01() throws Exception {
        //rWlXWbNvpeB
        BLogicProperty blogicProperty = new BLogicProperty();

        //propertyݒ
        UTUtil.setPrivateField(blogicProperty, "property", "property");

        //eXgsEʊmF
        assertEquals("property", blogicProperty.getProperty());
    }

    /**
     * testSetProperty01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"property"<br>
     *         () property:null<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) property:"property"<br>
     *         
     * <br>
     * Ɏw肵lBLogicPropertypropertyɐɊi[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetProperty01() throws Exception {
        //rWlXWbNvpeB
        BLogicProperty blogicProperty = new BLogicProperty();

        //eXgs
        blogicProperty.setProperty("property");

        //eXgʊmF
        assertEquals("property", UTUtil.getPrivateField(blogicProperty,
                "property"));
    }

    /**
     * testGetBLogicProperty01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () blogicProperty:"blogicProperty"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"blogicProperty"<br>
     *         
     * <br>
     * BLogicPropertyɊi[ĂblogicProperty𐳏Ɏ擾邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetBLogicProperty01() throws Exception {
        //rWlXWbNvpeB
        BLogicProperty blogicProperty = new BLogicProperty();

        //blogicPropertyݒ
        UTUtil.setPrivateField(blogicProperty, "blogicProperty",
                "blogicProperty");

        //eXgsEʊmF
        assertEquals("blogicProperty", blogicProperty.getBLogicProperty());
    }

    /**
     * testSetBLogicProperty01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() blogicProperty:"blogicProperty"<br>
     *         () blogicProperty:null<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) blogicProperty:"blogicProperty"<br>
     *         
     * <br>
     * Ɏw肵lBLogicPropertyblogicPropertyɐɊi[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetBLogicProperty01() throws Exception {
        //rWlXWbNvpeB
        BLogicProperty blogicProperty = new BLogicProperty();

        //eXgs
        blogicProperty.setBLogicProperty("blogicProperty");

        //eXgʊmF
        assertEquals(
            "blogicProperty",
            UTUtil.getPrivateField(blogicProperty, "blogicProperty"));
    }

    /**
     * testGetSource01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () sourceOrDest:"source"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"source"<br>
     *         
     * <br>
     * BLogicPropertyɊi[ĂsourceOrDest𐳏Ɏ擾邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetSource01() throws Exception {
        //rWlXWbNvpeB
        BLogicProperty blogicProperty = new BLogicProperty();

        //sourceOrDestݒ
        UTUtil.setPrivateField(blogicProperty, "sourceOrDest", "source");

        //eXgsEʊmF
        assertEquals("source", blogicProperty.getSource());
    }

    /**
     * testSetSource01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() source:"source"<br>
     *         () sourceOrDest:null<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) sourceOrDest:"source"<br>
     *         
     * <br>
     * Ɏw肵lBLogicPropertysourceOrDestɐɊi[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetSource01() throws Exception {
        //rWlXWbNvpeB
        BLogicProperty blogicProperty = new BLogicProperty();

        //eXgs
        blogicProperty.setSource("source");

        //eXgʊmF
        assertEquals("source", UTUtil.getPrivateField(blogicProperty,
                "sourceOrDest"));
    }

    /**
     * testGetDest01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () sourceOrDest:"dest"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"dest"<br>
     *         
     * <br>
     * BLogicPropertyɊi[ĂsourceOrDest𐳏Ɏ擾邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetDest01() throws Exception {
        //rWlXWbNvpeB
        BLogicProperty blogicProperty = new BLogicProperty();

        //sourceOrDestݒ
        UTUtil.setPrivateField(blogicProperty, "sourceOrDest", "dest");

        //eXgsEʊmF
        assertEquals("dest", blogicProperty.getDest());
    }

    /**
     * testSetDest01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() dest:"dest"<br>
     *         () sourceOrDest:null<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) sourceOrDest:"dest"<br>
     *         
     * <br>
     * Ɏw肵lBLogicPropertysourceOrDestɐɊi[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetDest01() throws Exception {
        //rWlXWbNvpeB
        BLogicProperty blogicProperty = new BLogicProperty();

        //eXgs
        blogicProperty.setDest("dest");

        //eXgʊmF
        assertEquals("dest", UTUtil.getPrivateField(blogicProperty,
                "sourceOrDest"));
    }

}
