/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import jp.terasoluna.fw.web.struts.action.ActionMappingEx;
import jp.terasoluna.utlib.DynaActionFormCreator;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpSession;
import jp.terasoluna.utlib.PropertyTestCase;
import jp.terasoluna.utlib.UTUtil;

import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Msg;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.Var;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

/**
 * {@link jp.terasoluna.fw.web.struts.form.FieldChecksEx}
 * NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Validatorǉ[NXB
 * <p>
 *
 * @see jp.terasoluna.fw.web.struts.form.FieldChecksEx
 */
public class FieldChecksExTest06 extends PropertyTestCase {

    /**
     * ̃NX̃eXgŎgpDynaValidatorActionFormEx̐ݒt@CB
     */
    private static final String CONFIG_FILE_NAME =
        FieldChecksExTest06.class.getResource(
                "FieldChecksExTest.xml").getPath();

    /**
     * DynaValidatorActionFormEx𐶐digester̃[t@CB
     */
    private final static String RULES_FILE_NAME =
        FieldChecksExTest06.class.getResource(
                "FieldChecksExTest-rules.xml").getPath();

    /**
     * DynaValidatorActionFormEx𐶐NXB
     */
    private static final DynaActionFormCreator creator
        = new DynaActionFormCreator(RULES_FILE_NAME);

    /**
     * eXgɎgpDynaValidatorActionFormExCX^XB
     */
    private DynaValidatorActionFormEx formEx = null;

    /**
     * Ȉ̌^XgB
     */
    public Class[] validClassList = {
        Object.class,
        ValidatorAction.class,
        Field.class,
        ActionMessages.class,
        Validator.class,
        HttpServletRequest.class
    };

    /**
     * Ȉ̕B
     */
    public String validClassStr = "java.lang.Object," +
            "org.apache.commons.validator.ValidatorAction," +
            "org.apache.commons.validator.Field," +
            "org.apache.struts.action.ActionMessages," +
            "org.apache.commons.validator.Validator," +
            "javax.servlet.http.HttpServletRequest";

    /**
     * eXgŎgpANVtH[B
     */
    FieldChecksEx_ValidatorActionFormExStub01 form = null;

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(FieldChecksExTest06.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
        LogUTUtil.flush();
        deleteProperty("validation.hankaku.kana.list");
        deleteProperty("validation.zenkaku.kana.list");
        form = new FieldChecksEx_ValidatorActionFormExStub01();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public FieldChecksExTest06(String name) {
        super(name);
    }

    /**
     * testValidateArraysIndex01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:*<br>
     *         () field:var:indexedListProperty=null<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () session:not null<br>
     *         () ActionForm:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * fieldindexedListPropertynull̂ƂAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
//    public void testValidateArraysIndex01() throws Exception {
//        //eXgf[^ݒ
//        // ++++ beanIuWFNg ++++
//        String bean = null;
//        // ++++ ؐݒIuWFNg
//        ValidatorAction va = new ValidatorAction();
//        // ++++ ؃tB[h
//        Field field = new Field();
//        field.setIndexedListProperty(null);
//        // G[
//        ActionMessages errors = new ActionMessages();
//        // [HTTPNGXg
//        HttpServletRequest request = new MockHttpServletRequest();
//
//        // ValidatorResourcesCX^X
//        ValidatorResources validatorResources = new ValidatorResources();
//        // ValidatorCX^X
//        Validator validator = new Validator(validatorResources);
//
//        // eXgs
//        boolean result =
//            FieldChecksEx.validateArraysIndex(
//                    bean,
//                    va,
//                    field,
//                    errors,
//                    validator,
//                    request);
//        // eXgʊmF
//        // trueԋpĂ邱ƁB
//        assertTrue(result);
//        // G[񂪋ł邱ƁB
//        assertTrue(errors.isEmpty());
//    }

    /**
     * testValidateArraysIndex02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:*<br>
     *         () field:var:indexedListProperty=""<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () session:not null<br>
     *         () ActionForm:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * fieldindexedListProperty󕶎̂ƂA
     * true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
//    public void testValidateArraysIndex02() throws Exception {
//        //eXgf[^ݒ
//        // ++++ beanIuWFNg ++++
//        String bean = null;
//
//        // ++++ ؐݒIuWFNg
//        ValidatorAction va = new ValidatorAction();
//
//        // ++++ ؃tB[h
//        Field field = new Field();
//        field.setIndexedListProperty("");
//
//        // G[
//        ActionMessages errors = new ActionMessages();
//        // [HTTPNGXg
//        HttpServletRequest request = new MockHttpServletRequest();
//
//        // ValidatorResourcesCX^X
//        ValidatorResources validatorResources = new ValidatorResources();
//        // ValidatorCX^X
//        Validator validator = new Validator(validatorResources);
//
//        // eXgs
//        boolean result =
//            FieldChecksEx.validateArraysIndex(
//                    bean,
//                    va,
//                    field,
//                    errors,
//                    validator,
//                    request);
//        // eXgʊmF
//        // trueԋpĂ邱ƁB
//        assertTrue(result);
//        // G[񂪋ł邱ƁB
//        assertTrue(errors.isEmpty());
//    }

    /**
     * testValidateArraysIndex03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF̃Xg<br>
     *                nameFnot null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () session:not null<br>
     *         () ActionForm:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxFG[<br>
     *                    Class pattern length is zero.<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * vamethodParams̃Xg̏ꍇAtrue擾ł邱ƂmFB<br>
     * getParamClass̃eXg܂
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArraysIndex03() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams("");

        // ++++ ؃tB[h
        Field field = new Field();

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[O`FbN
        assertTrue(LogUTUtil.checkError("Class pattern length is zero."));
    }

    /**
     * testValidateArraysIndex04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsFtestClass<br>
     *                ݂ȂNX<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () session:not null<br>
     *         () ActionForm:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxFG[<br>
     *                    ONXFClassNotFoundException<br>
     *                    OxFG[<br>
     *                    bZ[WF<br>
     *                    "Can not get class pattern."<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * vamethodParamsɑ݂ȂNXꍇA
     * true擾ł邱ƂmFB<br>
     * getParamClass̃eXg܂
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArraysIndex04() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams("testClass");

        // ++++ ؃tB[h
        Field field = new Field();

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[O`FbN
        assertTrue(LogUTUtil.checkError("", new ClassNotFoundException()));
        assertTrue(LogUTUtil.checkError("Can not get class pattern."));
    }

    /**
     * testValidateArraysIndex05()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6SĐ<br>
     *                nameFnull<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () session:not null<br>
     *         () ActionForm:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF<br>
     *                    "Can not get validateMethod."<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * vanamenull̂ƂAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArraysIndex05() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName(null);

        // ++++ ؃tB[h
        Field field = new Field();

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[O`FbN
        assertTrue(LogUTUtil.checkError("Can not get validateMethod."));
    }

    /**
     * testValidateArraysIndex06()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6SĐ<br>
     *                nameF""<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () session:not null<br>
     *         () ActionForm:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF<br>
     *                    "Can not get validateMethod."<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * vaname󕶎̂ƂAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArraysIndex06() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName("");

        // ++++ ؃tB[h
        Field field = new Field();

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[O`FbN
        assertTrue(LogUTUtil.checkError("Can not get validateMethod."));
    }

    /**
     * testValidateArraysIndex07()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6SĐ<br>
     *                nameF"testArray"<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () session:not null<br>
     *         () ActionForm:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxFG[<br>
     *                    ONXF<br>
     *                    NoSuchMethodException<br>
     *                    OxFG[<br>
     *                    bZ[WF<br>
     *                    "Can not get validateMethod."<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * vaname擾\bhFieldChecksExA
     * ValidWhenɑ݂ȂꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArraysIndex07() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName("testArray");

        // ++++ ؃tB[h
        Field field = new Field();

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[O`FbN
        assertTrue(LogUTUtil.checkError("", new NoSuchMethodException()));
        assertTrue(LogUTUtil.checkError("Can not get validateMethod."));
    }

    /**
     * testValidateArraysIndex08()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF"java.lang.String"<br>
     *                nameF"stringLengthArray"<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () session:not null<br>
     *         () ActionForm:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxFG[<br>
     *                    ONXF<br>
     *                    NoSuchMethodException<br>
     *                    OxFG[<br>
     *                    bZ[WF<br>
     *                    "Can not get validateMethod."<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * vaɐݒ肳ꂽ`FbN\bḧƁA
     * methodParamsŎw肳ꂽvȂꍇA
     * true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArraysIndex08() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams("java.lang.String");
        va.setName("stringLengthArray");

        // ++++ ؃tB[h
        Field field = new Field();

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[O`FbN
        assertTrue(LogUTUtil.checkError("", new NoSuchMethodException()));
        assertTrue(LogUTUtil.checkError("Can not get validateMethod."));
    }

    /**
     * testValidateArraysIndex09()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6̏قȂ<br>
     *                nameF"stringLengthArray"<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () session:not null<br>
     *         () ActionForm:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxFG[<br>
     *                    ONXF<br>
     *                    NoSuchMethodException<br>
     *                    OxFG[<br>
     *                    bZ[WF<br>
     *                    "Can not get validateMethod."<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * vaɐݒ肳ꂽ`FbN\bḧƁA
     * methodParamsŎw肳ꂽvȂꍇA
     * true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArraysIndex09() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        String argStr = "javax.servlet.http.HttpServletRequest," +
            "org.apache.commons.validator.ValidatorAction," +
            "org.apache.commons.validator.Field," +
            "org.apache.struts.action.ActionMessages," +
            "org.apache.commons.validator.Validator," +
            "java.lang.Object";
        va.setMethodParams(argStr);
        va.setName("stringLengthArray");

        // ++++ ؃tB[h
        Field field = new Field();

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[O`FbN
        assertTrue(LogUTUtil.checkError("", new NoSuchMethodException()));
        assertTrue(LogUTUtil.checkError("Can not get validateMethod."));
    }

    /**
     * testValidateArraysIndex10()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6SĐ<br>
     *                nameF"stringLengthArray"<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:ActionMappingFnull<br>
     *         () session:not null<br>
     *         () ActionForm:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF<br>
     *                    "Can not get ActionForm."<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * NGXgActionMapping擾łȂꍇA
     * true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArraysIndex10() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName("stringLengthArray");

        // ++++ ؃tB[h
        Field field = new Field();

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[O`FbN
        assertTrue(LogUTUtil.checkError("Can not get ActionForm."));
    }

    /**
     * testValidateArraysIndex11()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6SĐ<br>
     *                nameF"stringLengthArray"<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:ANVtH[F"logon"<br>
     *         () session:L[F"logon"ɑ΂l<br>
     *                ActionFormIuWFNgȊO<br>
     *         () ActionForm:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF<br>
     *                    "Can not get ActionForm."<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * ZbV擾ANVtH[ActionFormNXł͂ȂꍇA
     * true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArraysIndex11() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName("stringLengthArray");

        // ++++ ؃tB[h
        Field field = new Field();

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        FieldChecksEx_HttpServletRequestImpl01 request =
            new FieldChecksEx_HttpServletRequestImpl01();
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("logon");
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        MockHttpSession session = new MockHttpSession();
        session.setAttribute("logon", "hoge");
        request.setSession(session);

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[O`FbN
        assertTrue(LogUTUtil.checkError("Can not get ActionForm."));
    }

    /**
     * testValidateArraysIndex12()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6SĐ<br>
     *                nameF"stringLengthArray"<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:ANVtH[F"logon"<br>
     *                L[F"logon"ɑ΂l<br>
     *                ActionFormIuWFNgȊO<br>
     *         () session:L[F"logon"ɑ΂l݂Ȃ<br>
     *         () ActionForm:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF<br>
     *                    "Can not get ActionForm."<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * NGXg擾ANVtH[ActionFormNXł͂ȂꍇA
     * true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArraysIndex12() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName("stringLengthArray");

        // ++++ ؃tB[h
        Field field = new Field();

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        FieldChecksEx_HttpServletRequestImpl01 request =
            new FieldChecksEx_HttpServletRequestImpl01();
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("logon");
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        request.setAttribute("logon", "hoge");


        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[O`FbN
        assertTrue(LogUTUtil.checkError("Can not get ActionForm."));
    }

    /**
     * testValidateArraysIndex13()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6SĐ<br>
     *                nameF"stringLengthArray"<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:ANVtH[F"logon"<br>
     *                L[F"logon"ɑ΂l݂Ȃ<br>
     *         () session:L[F"logon"ɑ΂l݂Ȃ<br>
     *         () ActionForm:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF<br>
     *                    "Can not get ActionForm."<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * ANVtH[擾łȂꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArraysIndex13() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName("stringLengthArray");

        // ++++ ؃tB[h
        Field field = new Field();

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        FieldChecksEx_HttpServletRequestImpl01 request =
            new FieldChecksEx_HttpServletRequestImpl01();
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("logon");
        request.setAttribute(Globals.MAPPING_KEY, mapping);


        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[O`FbN
        assertTrue(LogUTUtil.checkError("Can not get ActionForm."));
    }

    /**
     * testValidateArraysIndex14()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6SĐ<br>
     *                nameF"stringLengthArray"<br>
     *                msg:key="message",name="stringLengthArray",resource="false"<br>
     *         () field:property=testArray<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:ANVtH[F"logon"<br>
     *         () session:L[F"logon"ɑ΂l<br>
     *                ActionFormIuWFNg<br>
     *         () ActionForm:String testArray="String"<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("testMessage")<br>
     *
     * <br>
     * ؑΏۂ̃vpeBzACollection^ł͂ȂꍇA
     * true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArraysIndex14() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName("stringLengthArray");

        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("testArray");
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("stringLengthArray");
        msg.setResource(false);
        field.addMsg(msg);
        Var var = new Var();
        var.setName("stringLength");
        var.setValue("3");
        field.addVar(var);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        FieldChecksEx_HttpServletRequestImpl01 request =
            new FieldChecksEx_HttpServletRequestImpl01();
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("logon");
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        MockHttpSession session = new MockHttpSession();
        form.setTestArray("String");
        session.setAttribute("logon", form);
        request.setSession(session);


        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ǉĂ邱ƁB
        assertEquals(1, errors.size());
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());

    }

    /**
     * testValidateArraysIndex15()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6SĐ<br>
     *                nameF"stringLengthArray"<br>
     *         () field:property="codeArray"<br>
     *                var:stringLength=3<br>
     *                arg:position="0",key="##INDEX",resource="false"<br>
     *                arg:position="1",key="${var:length}",resource="false"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:ANVtH[F"logon"<br>
     *                L[F"logon"ɑ΂l<br>
     *                ActionFormIuWFNg<br>
     *         () session:L[F"logon"ɑ΂l݂Ȃ<br>
     *         () ActionForm:ArrayList codeArray(List)<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * ؑΏۂ̃vpeBList^ŗvf̏ꍇA
     * true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArraysIndex15() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName("stringLengthArray");

        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("codeArray");
        Var var = new Var();
        var.setName("stringLength");
        var.setValue("3");
        field.addVar(var);

        Arg arg0 = new Arg();
        arg0.setKey("##INDEX");
        arg0.setPosition(0);
        arg0.setResource(false);
        field.addArg(arg0);
        Arg arg1 = new Arg();
        arg1.setKey("${var:stringLength}");
        arg1.setPosition(1);
        arg1.setResource(false);
        field.addArg(arg1);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        FieldChecksEx_HttpServletRequestImpl01 request =
            new FieldChecksEx_HttpServletRequestImpl01();
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("logon");
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        form.setCodeArray(new ArrayList());
        request.setAttribute("logon", form);


        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateArraysIndex16()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6SĐ<br>
     *                nameF"hankakuString12345"<br>
     *         () field:property="codeArray"<br>
     *                arg:position="0",key="##INDEX",resource="false"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:ANVtH[F"logon"<br>
     *         () session:L[F"logon"ɑ΂l<br>
     *                ActionFormIuWFNg<br>
     *         () ActionForm:ArrayList codeArray = {<br>
     *                    "ݶ"<br>
     *                }<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * ؃[݂郋[iCfbNX`FbNȊOj
     * +5̃[̂ƂA؂s邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArraysIndex16() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName("hankakuString12345");

        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("codeArray");

        Arg arg0 = new Arg();
        arg0.setKey("##INDEX");
        arg0.setPosition(0);
        arg0.setResource(false);
        field.addArg(arg0);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        FieldChecksEx_HttpServletRequestImpl01 request =
            new FieldChecksEx_HttpServletRequestImpl01();
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("logon");
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        MockHttpSession session = new MockHttpSession();
        ArrayList<String> testList = new ArrayList<String>();
        testList.add("ݶ");
        form.setCodeArray(testList);
        session.setAttribute("logon", form);
        request.setSession(session);


        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateArraysIndex17()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6SĐ<br>
     *                nameF"hankakuStringArray"<br>
     *         () field:property="codeArray"<br>
     *                arg:position="0",key="##INDEX",resource="false"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:ANVtH[F"logon"<br>
     *         () session:L[F"logon"ɑ΂l<br>
     *                ActionFormIuWFNg<br>
     *         () ActionForm:Arraylist codeArray = {<br>
     *                    "abc",<br>
     *                    ":ݶ",<br>
     *                    "123",<br>
     *                    "*!"",<br>
     *                    ""<br>
     *                }<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * ؑΏۂ̃vpeBvf̂ListŌ؃G[ɂȂvf
     * ݂ȂꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArraysIndex17() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName("hankakuStringArray");

        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("codeArray");

        Arg arg0 = new Arg();
        arg0.setKey("##INDEX");
        arg0.setPosition(0);
        arg0.setResource(false);
        field.addArg(arg0);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        FieldChecksEx_HttpServletRequestImpl01 request =
            new FieldChecksEx_HttpServletRequestImpl01();
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("logon");
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        MockHttpSession session = new MockHttpSession();
        ArrayList<String> testList = new ArrayList<String>();
        testList.add("abc");
        testList.add(":ݶ");
        testList.add("123");
        testList.add("*!\"");
        testList.add("");
        form.setCodeArray(testList);
        session.setAttribute("logon", form);
        request.setSession(session);


        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateArraysIndex18()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6SĐ<br>
     *                nameF"stringLengthArray"<br>
     *         () field:property="stringArray"<br>
     *                var:stringLength="3"<br>
     *                arg:position="0",key="##INDEX",resource="false"<br>
     *                arg:position="1",key="${var:stringLength}",resource="false"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:ANVtH[F"logon"<br>
     *         () session:L[F"logon"ɑ΂l<br>
     *                ActionFormIuWFNg<br>
     *         () ActionForm:String[] stringArray<br>
     *                (̗vf)<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * ؑΏۂ̃vpeBz^ŗvf̏ꍇA
     * true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArraysIndex18() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName("stringLengthArray");

        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("stringArray");
        Var var = new Var();
        var.setName("stringLength");
        var.setValue("3");
        field.addVar(var);

        Arg arg0 = new Arg();
        arg0.setKey("##INDEX");
        arg0.setPosition(0);
        arg0.setResource(false);
        field.addArg(arg0);
        Arg arg1 = new Arg();
        arg1.setKey("${var:stringLength}");
        arg1.setPosition(1);
        arg1.setResource(false);
        field.addArg(arg1);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        FieldChecksEx_HttpServletRequestImpl01 request =
            new FieldChecksEx_HttpServletRequestImpl01();
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("logon");
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        MockHttpSession session = new MockHttpSession();
        form.setStringArray(new String[]{});
        session.setAttribute("logon", form);
        request.setSession(session);


        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateArraysIndex19()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6SĐ<br>
     *                nameF"requiredArray"<br>
     *         () field:property="stringArray"<br>
     *         () errors:not null<br>
     *                ActionMessage(<br>
     *                  "testMessage")<br>
     *         () validator:not null<br>
     *         () request:ANVtH[F"logon"<br>
     *         () session:L[F"logon"ɑ΂l<br>
     *                ActionFormIuWFNg<br>
     *         () ActionForm:String[] stringArray = {<br>
     *                    null<br>
     *                }<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage(<br>
     *                      "testMessage")<br>
     *                    ActionMessage(<br>
     *                      "message")<br>
     *
     * <br>
     * ؑΏۂ̃vpeBvf1̔z^ŁA؃G[ꍇA
     * G[bZ[WǉAfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArraysIndex19() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName("requiredArray");

        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("stringArray");

        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("requiredArray");
        msg.setResource(false);
        field.addMsg(msg);

        // G[
        ActionMessages errors = new ActionMessages();
        ActionMessage error = new ActionMessage("testMessage");
        errors.add(Globals.ERROR_KEY, error);
        // [HTTPNGXg
        FieldChecksEx_HttpServletRequestImpl01 request =
            new FieldChecksEx_HttpServletRequestImpl01();
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("logon");
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        MockHttpSession session = new MockHttpSession();
        String[] testArray = {
            null
        };
        form.setStringArray(testArray);
        session.setAttribute("logon", form);
        request.setSession(session);


        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertFalse(result);
        // G[񂪋ł邱ƁB
        assertEquals(2, errors.size());

        Iterator it = errors.get();
        List<String> nameList = new ArrayList<String>();
        while (it.hasNext()) {
            ActionMessage message = (ActionMessage) it.next();
            nameList.add(message.getKey());
        }
        assertTrue(nameList.contains("testMessage"));
        assertTrue(nameList.contains("message"));
    }

    /**
     * testValidateArraysIndex20()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6SĐ<br>
     *                nameF"requiredArray"<br>
     *         () field:property="stringArray"<br>
     *                arg:position="0",key="##INDEX",resource="false"<br>
     *                arg:position="1",key="##INDEX",resource="false"<br>
     *                arg:position="3",key="##INDEX",resource="false"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:ANVtH[F"logon"<br>
     *         () session:L[F"logon"ɑ΂l<br>
     *                ActionFormIuWFNg<br>
     *         () ActionForm:ؑΏہFString[1]<br>
     *                ،ʁF<br>
     *                [0]:null(false)<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message"<br>
     *                      args{<br>
     *                        "1", "1", "1"<br>
     *                      })<br>
     *
     * <br>
     * argvf##INDEXƂɁAɃ`FbNs邱Ƃ
     * mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArraysIndex20() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName("requiredArray");

        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("stringArray");

        Arg arg0 = new Arg();
        arg0.setKey("##INDEX");
        arg0.setPosition(0);
        arg0.setResource(false);
        field.addArg(arg0);

        Arg arg1 = new Arg();
        arg1.setKey("##INDEX");
        arg1.setPosition(1);
        arg1.setResource(false);
        field.addArg(arg1);

        Arg arg2 = new Arg();
        arg2.setKey("##INDEX");
        arg2.setPosition(3);
        arg2.setResource(false);
        field.addArg(arg2);

        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("requiredArray");
        field.addMsg(msg);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        FieldChecksEx_HttpServletRequestImpl01 request =
            new FieldChecksEx_HttpServletRequestImpl01();
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("logon");
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        MockHttpSession session = new MockHttpSession();
        String[] testArray = {
            null
        };
        form.setStringArray(testArray);
        session.setAttribute("logon", form);
        request.setSession(session);

        FieldChecksEx_MessageResourcesImpl01 messageResources =
            new FieldChecksEx_MessageResourcesImpl01(null ,null);
        messageResources.message = "{0},{1},{2},{3}";
        request.setAttribute(Globals.MESSAGES_KEY, messageResources);

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(1, errors.size());

        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
        Object values[] = message.getValues();
        assertEquals("1", values[0]);
        assertEquals("1", values[1]);
        assertNull(values[2]);
        assertEquals("1", values[3]);
    }

    /**
     * testValidateArraysIndex21()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6SĐ<br>
     *                nameF"numberArray"<br>
     *         () field:property="stringArray"<br>
     *                var:integerLength="2"<br>
     *                var:scale="1"<br>
     *                var:isAccordedScale="true"<br>
     *                arg:position="0",key="${var:integerLength}",<br>
     *                  resource="false"<br>
     *                arg:position="1",key="${var:scale}",<br>
     *                  resource="false"<br>
     *                arg:position="2",key="${var:isAccordedInteger}",<br>
     *                  resource="false"<br>
     *                arg:position="3",key="##INDEX",<br>
     *                  resource="false"<br>
     *                msg:key="numberArray",name="numberArray"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:ANVtH[F"logon"<br>
     *         () session:L[F"logon"ɑ΂l<br>
     *                ActionFormIuWFNg<br>
     *         () ActionForm:ؑΏہFString[5]<br>
     *                ،ʁF<br>
     *                [0]:10.1(true)<br>
     *                [1]:1.11(false)<br>
     *                [2]:100.1(false)<br>
     *                [3]:100(false)<br>
     *                [4]:10.0(true)<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage(<br>
     *                      "numberArray",<br>
     *                      arg{"2","1","true","2"})<br>
     *                    ActionMessage(<br>
     *                      "numberArray",<br>
     *                      arg{"2","1","true","3"})<br>
     *                    ActionMessage(<br>
     *                      "numberArray",<br>
     *                      arg{"2","1","true","4"})<br>
     *
     * <br>
     * ؑΏۂ̃vpeBvf̔zŁÃG[ꍇA
     * u##INDEX̒lG[CfbNXɒu邱Ƃ
     * mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testValidateArraysIndex21() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName("numberArray");

        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("stringArray");

        Var var = new Var();
        var.setName("integerLength");
        var.setValue("2");
        field.addVar(var);

        var = new Var();
        var.setName("scale");
        var.setValue("1");
        field.addVar(var);

        var = new Var();
        var.setName("isAccordedScale");
        var.setValue("true");
        field.addVar(var);

        Arg arg0 = new Arg();
        arg0.setKey("${var:integerLength}");
        arg0.setPosition(0);
        arg0.setResource(false);
        field.addArg(arg0);

        Arg arg1 = new Arg();
        arg1.setKey("${var:scale}");
        arg1.setPosition(1);
        arg1.setResource(false);
        field.addArg(arg1);

        Arg arg2 = new Arg();
        arg2.setKey("${var:isAccordedScale}");
        arg2.setPosition(2);
        arg2.setResource(false);
        field.addArg(arg2);

        Arg arg3 = new Arg();
        arg3.setKey("##INDEX");
        arg3.setPosition(3);
        arg3.setResource(false);
        field.addArg(arg3);

        Msg msg = new Msg();
        msg.setKey("numberArray");
        msg.setName("numberArray");
        field.addMsg(msg);
        UTUtil.invokePrivate(field, "process", Map.class, Map.class, 
        		new HashMap(), new HashMap());

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        FieldChecksEx_HttpServletRequestImpl01 request =
            new FieldChecksEx_HttpServletRequestImpl01();
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("logon");
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        MockHttpSession session = new MockHttpSession();
        String[] testArray = {
            "10.1",
            "1.11",
            "100.1",
            "100",
            "10.0"
        };
        form.setStringArray(testArray);
        session.setAttribute("logon", form);
        request.setSession(session);

        FieldChecksEx_MessageResourcesImpl01 messageResources =
            new FieldChecksEx_MessageResourcesImpl01(null ,null);
        messageResources.message = "{0},{1},{2},{3}";
        request.setAttribute(Globals.MESSAGES_KEY, messageResources);

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(3, errors.size());

        Iterator it = errors.get();
        int counter = 2;
        while (it.hasNext()) {
            ActionMessage message = (ActionMessage) it.next();
            assertEquals("numberArray", message.getKey());
            assertEquals("2", message.getValues()[0]);
            assertEquals("1", message.getValues()[1]);
            assertEquals("true", message.getValues()[2]);
            assertEquals(String.valueOf(counter++), message.getValues()[3]);
        }
    }

    /**
     * testValidateArraysIndex22()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6SĐ<br>
     *                nameF"stringLengthArray"<br>
     *         () field:propertyF"codeArray"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:ANVtH["logon"<br>
     *         () session:L[F"logon"ɑ΂l<br>
     *                ActionFormIuWFNg<br>
     *         () ActionForm:ArrayList codeArray=null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * ؑΏۂ̃vpeB̒lnull̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArraysIndex22() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName("stringLengthArray");

        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("codeArray");

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        FieldChecksEx_HttpServletRequestImpl01 request =
            new FieldChecksEx_HttpServletRequestImpl01();
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("logon");
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        MockHttpSession session = new MockHttpSession();
        form.setCodeArray(null);
        session.setAttribute("logon", form);
        request.setSession(session);


        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

    }

    /**
     * testValidateArraysIndex23()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsFnull<br>
     *         () field:*<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () session:not null<br>
     *         () ActionForm:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxFG[<br>
     *                    Can not get class pattern.<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * vamethodParamsnull̏ꍇAtrue擾ł邱ƂmFB<br>
     * getParamClass̃eXg܂
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArraysIndex23() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        UTUtil.setPrivateField(va, "methodParams", null);

        // ++++ ؃tB[h
        Field field = new Field();

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[O`FbN
        assertTrue(LogUTUtil.checkError("Can not get class pattern."));
    }

    /**
     * testValidateArraysIndex24()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:6SĐ<br>
     *                nameF"numberArray"<br>
     *         () field:propertyFnoIndexedListProperty<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () session:not null<br>
     *         () ActionForm:noIndexedListPropertytB[h<br>
     *                ݂Ȃ<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * ؑΏۂ̃tB[h݂ȂꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArraysIndex24() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName("numberArray");

        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("noIndexedListProperty");

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        FieldChecksEx_HttpServletRequestImpl01 request =
            new FieldChecksEx_HttpServletRequestImpl01();
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("logon");
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        MockHttpSession session = new MockHttpSession();
        String[] testArray = {
            null
        };
        form.setStringArray(testArray);
        session.setAttribute("logon", form);
        request.setSession(session);


        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

    }

    /**
     * testValidateArraysIndex25()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6SĐ<br>
     *                nameF"minLengthArray"<br>
     *         () field:property="row.values"<br>
     *                var:minlength="3"<br>
     *                arg:position="0",key="##INDEX",<br>
     *                  resource="false"<br>
     *                arg:position="1",key="${var:minlength}",<br>
     *                  resource="false"<br>
     *                msg:key="minLengthArray",name="minLengthArray"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:ANVtH[F"logon"<br>
     *         () session:L[F"logon"ɑ΂l<br>
     *                ActionFormIuWFNg<br>
     *         () ActionForm:JavaBean row<br>
     *                 + String[] values = {<br>
     *                     "a", "bbbb","cc"<br>
     *                }<br>
     *         () bZ[W\[X:message={0},{1}<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage(<br>
     *                      "minLengthArray",<br>
     *                      arg{"2","3"})<br>
     *
     * <br>
     * ؑΏۂ̒lANVtH[̃lXgvpeB̏ꍇAɌ؂s邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testValidateArraysIndex25() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName("minLengthArray");

        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("row.values");
        Var var = new Var();
        var.setName("minlength");
        var.setValue("3");
        field.addVar(var);
        Arg arg0 = new Arg();
        arg0.setPosition(0);
        arg0.setKey("##INDEX");
        arg0.setResource(false);
        //arg0.setName("minLengthArray");
        field.addArg(arg0);
        Arg arg1 = new Arg();
        arg1.setPosition(1);
        arg1.setKey("${var:minlength}");
        arg1.setResource(false);
        //arg1.setName("minLength");
        field.addArg(arg1);
        Msg msg = new Msg();
        msg.setKey("minLengthArray");
        msg.setName("minLengthArray");
        field.addMsg(msg);
        UTUtil.invokePrivate(field, "process", Map.class, Map.class, 
        		new HashMap(), new HashMap());

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        FieldChecksEx_HttpServletRequestImpl01 request =
            new FieldChecksEx_HttpServletRequestImpl01();
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("logon");
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        MockHttpSession session = new MockHttpSession();
        FieldChecksEx_JavaBeanStub01 row = new FieldChecksEx_JavaBeanStub01();
        String[] values = {
            "a", "bbbb", "cc"
        };
        row.values = values;
        form.setRow(row);
        session.setAttribute("logon", form);
        request.setSession(session);

        FieldChecksEx_MessageResourcesImpl01 messageResources =
            new FieldChecksEx_MessageResourcesImpl01(null ,null);
        messageResources.message = "{0},{1}";
        request.setAttribute(Globals.MESSAGES_KEY, messageResources);

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ǉĂ邱ƁB
        assertEquals(2, errors.size());
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("minLengthArray", message.getKey());
        assertEquals("1", message.getValues()[0]);
        assertEquals("3", message.getValues()[1]);
        message = (ActionMessage) it.next();
        assertEquals("minLengthArray", message.getKey());
        assertEquals("3", message.getValues()[0]);
        assertEquals("3", message.getValues()[1]);


    }

    /**
     * testValidateArraysIndex26()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6SĐ<br>
     *                nameF"alphaNumericStringArray"<br>
     *         () field:property="rows.value"<br>
     *                arg:position="0",key="##INDEX",<br>
     *                  resource="false"<br>
     *                msg:key="alphaNumericStringArray",name="alphaNumericStringArray"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:ANVtH[F"logon"<br>
     *         () session:L[F"logon"ɑ΂l<br>
     *                ActionFormIuWFNg<br>
     *         () ActionForm:<br>
     *                JavaBean[] rows<br>
     *                  +rows[0]<br>
     *                     + String value = "Ă"<br>
     *                  +rows[1]<br>
     *                     + String value = "test"<br>
     *                  +rows[2]<br>
     *                     + String value = "Ă"<br>
     *         () bZ[W\[X:message={0}<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage(<br>
     *                           "alphaNumericStringArray",<br>
     *                           arg{"2"})<br>
     *
     * <br>
     * ؑΏۂ̒lANVtH[̃lXgvpeB̏ꍇAɌ؂s邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testValidateArraysIndex26() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName("alphaNumericStringArray");

        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("rows.value");
        Var var = new Var();
        field.addVar(var);
        Arg arg0 = new Arg();
        arg0.setPosition(0);
        arg0.setKey("##INDEX");
        arg0.setResource(false);
        field.addArg(arg0);
        Msg msg = new Msg();
        msg.setKey("alphaNumericStringArray");
        msg.setName("alphaNumericStringArray");
        field.addMsg(msg);
        UTUtil.invokePrivate(field, "process", Map.class, Map.class, 
        		new HashMap(), new HashMap());

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        FieldChecksEx_HttpServletRequestImpl01 request =
            new FieldChecksEx_HttpServletRequestImpl01();
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("logon");
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        MockHttpSession session = new MockHttpSession();
        FieldChecksEx_JavaBeanStub01[] rows = {
            new FieldChecksEx_JavaBeanStub01(),
            new FieldChecksEx_JavaBeanStub01(),
            new FieldChecksEx_JavaBeanStub01()
        };
        rows[0].value = "Ă";
        rows[1].value = "test";
        rows[2].value = "Ă";
        form.rows = rows;

        session.setAttribute("logon", form);
        request.setSession(session);

        FieldChecksEx_MessageResourcesImpl01 messageResources =
            new FieldChecksEx_MessageResourcesImpl01(null ,null);
        messageResources.message = "{0}";
        request.setAttribute(Globals.MESSAGES_KEY, messageResources);

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[2ǉĂ邱ƁB
        assertEquals(2, errors.size());
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("alphaNumericStringArray", message.getKey());
        assertEquals("1", message.getValues()[0]);
        message = (ActionMessage) it.next();
        assertEquals("alphaNumericStringArray", message.getKey());
        assertEquals("3", message.getValues()[0]);


    }

    /**
     * testValidateArraysIndex27()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6SĐ<br>
     *                nameF"requiredArray"<br>
     *         () field:property="rowList.map(key)"<br>
     *                arg:position="0",key="##INDEX",<br>
     *                  resource="false"<br>
     *                msg:key="requiredArray",name="requiredArray"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:ANVtH[F"logon"<br>
     *         () session:L[F"logon"ɑ΂l<br>
     *                ActionFormIuWFNg<br>
     *         () ActionForm:ArrayList<JavaBean> rowList<br>
     *                 + rowList[0]<br>
     *                     + Map map = { key = null }<br>
     *                 + rowList[1]<br>
     *                     + Map map = { key = null }<br>
     *                 + rowList[2]<br>
     *                     + Map map = { key = null }<br>
     *         () bZ[W\[X:message={0}<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage(<br>
     *                      "minLengthArray",<br>
     *                      arg{"1"})<br>
     *                    ActionMessage(<br>
     *                      "minLengthArray",<br>
     *                      arg{"2"})<br>
     *                    ActionMessage(<br>
     *                      "minLengthArray",<br>
     *                      arg{"3"})<br>
     *
     * <br>
     * ؑΏۂ̒lANVtH[̃lXgvpeB̏ꍇAɌ؂s邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings({"deprecation","unchecked"})
    public void testValidateArraysIndex27() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName("requiredArray");

        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("rowList.map(key)");
        Var var = new Var();
        field.addVar(var);
        Arg arg0 = new Arg();
        arg0.setPosition(0);
        arg0.setKey("##INDEX");
        arg0.setResource(false);
        field.addArg(arg0);
        Msg msg = new Msg();
        msg.setKey("requiredArray");
        msg.setName("requiredArray");
        field.addMsg(msg);
        UTUtil.invokePrivate(field, "process", Map.class, Map.class, 
        		new HashMap(), new HashMap());

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        FieldChecksEx_HttpServletRequestImpl01 request =
            new FieldChecksEx_HttpServletRequestImpl01();
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("logon");
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        MockHttpSession session = new MockHttpSession();
        List rowList = new ArrayList();
        FieldChecksEx_JavaBeanStub01 row = new FieldChecksEx_JavaBeanStub01();
        Map map = new HashMap();
        map.put("key", null);
        row.map = map;
        rowList.add(row);
        row = new FieldChecksEx_JavaBeanStub01();
        map = new HashMap();
        map.put("key", null);
        row.map = map;
        rowList.add(row);
        row = new FieldChecksEx_JavaBeanStub01();
        map = new HashMap();
        map.put("key", null);
        row.map = map;
        rowList.add(row);
        form.rowList = rowList;

        session.setAttribute("logon", form);
        request.setSession(session);

        FieldChecksEx_MessageResourcesImpl01 messageResources =
            new FieldChecksEx_MessageResourcesImpl01(null ,null);
        messageResources.message = "{0}";
        request.setAttribute(Globals.MESSAGES_KEY, messageResources);

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[2ǉĂ邱ƁB
        assertEquals(3, errors.size());
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("requiredArray", message.getKey());
        assertEquals("1", message.getValues()[0]);
        message = (ActionMessage) it.next();
        assertEquals("requiredArray", message.getKey());
        assertEquals("2", message.getValues()[0]);
        message = (ActionMessage) it.next();
        assertEquals("requiredArray", message.getKey());
        assertEquals("3", message.getValues()[0]);


    }

    /**
     * testValidateArraysIndex28()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6SĐ<br>
     *                nameF"minLengthArray"<br>
     *         () field:property="row.values"<br>
     *                var:minlength="3"<br>
     *                arg:position="0",key="##INDEX",<br>
     *                  resource="false"<br>
     *                arg:position="1",key="${var:minlength}",<br>
     *                  resource="false"<br>
     *                msg:key="minLengthArray",name="minLengthArray"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:ANVtH[F"logon"<br>
     *         () session:L[F"logon"ɑ΂l<br>
     *                ActionFormIuWFNg<br>
     *         () ActionForm:DynaValidatorActionFormExCX^X<br>
     *                JavaBean row<br>
     *                 + String[] values = {<br>
     *                     "a", "bbbb","cc"<br>
     *                }<br>
     *         () bZ[W\[X:message={0},{1}<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage(<br>
     *                      "minLengthArray",<br>
     *                      arg{"2","3"})<br>
     *
     * <br>
     * ؑΏۂ̒lANVtH[̃lXgvpeB̏ꍇAɌ؂s邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testValidateArraysIndex28() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        this.formEx =
            (DynaValidatorActionFormEx) creator.create(CONFIG_FILE_NAME);
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName("minLengthArray");

        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("row.values");
        Var var = new Var();
        var.setName("minlength");
        var.setValue("3");
        field.addVar(var);
        Arg arg0 = new Arg();
        arg0.setPosition(0);
        arg0.setKey("##INDEX");
        arg0.setResource(false);
        //arg0.setName("minLengthArray");
        field.addArg(arg0);
        Arg arg1 = new Arg();
        arg1.setPosition(1);
        arg1.setKey("${var:minlength}");
        arg1.setResource(false);
        //arg1.setName("minLength");
        field.addArg(arg1);
        Msg msg = new Msg();
        msg.setKey("minLengthArray");
        msg.setName("minLengthArray");
        field.addMsg(msg);
        UTUtil.invokePrivate(field, "process", Map.class, Map.class, 
        		new HashMap(), new HashMap());

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        FieldChecksEx_HttpServletRequestImpl01 request =
            new FieldChecksEx_HttpServletRequestImpl01();
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("logon");
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        MockHttpSession session = new MockHttpSession();
        FieldChecksEx_JavaBeanStub01 row = new FieldChecksEx_JavaBeanStub01();
        String[] values = {
            "a", "bbbb", "cc"
        };
        row.values = values;
        formEx.set("row", row);
        session.setAttribute("logon", formEx);
        request.setSession(session);

        FieldChecksEx_MessageResourcesImpl01 messageResources =
            new FieldChecksEx_MessageResourcesImpl01(null ,null);
        messageResources.message = "{0},{1}";
        request.setAttribute(Globals.MESSAGES_KEY, messageResources);

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[2ǉĂ邱ƁB
        assertEquals(2, errors.size());
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("minLengthArray", message.getKey());
        assertEquals("1", message.getValues()[0]);
        assertEquals("3", message.getValues()[1]);
        message = (ActionMessage) it.next();
        assertEquals("minLengthArray", message.getKey());
        assertEquals("3", message.getValues()[0]);
        assertEquals("3", message.getValues()[1]);


    }

    /**
     * testValidateArraysIndex29()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6SĐ<br>
     *                nameF"alphaNumericStringArray"<br>
     *         () field:property="rows.value"<br>
     *                arg:position="0",key="##INDEX",<br>
     *                  resource="false"<br>
     *                msg:key="alphaNumericStringArray",name="alphaNumericStringArray"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:ANVtH[F"logon"<br>
     *         () session:L[F"logon"ɑ΂l<br>
     *                ActionFormIuWFNg<br>
     *         () ActionForm:DynaValidatorActionFormExCX^X<br>
     *                JavaBean[] rows<br>
     *                  +rows[0]<br>
     *                     + String value = "Ă"<br>
     *                  +rows[1]<br>
     *                     + String value = "test"<br>
     *                  +rows[2]<br>
     *                     + String value = "Ă"<br>
     *         () bZ[W\[X:message={0}<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage(<br>
     *                           "alphaNumericStringArray",<br>
     *                           arg{"2"})<br>
     *
     * <br>
     * ؑΏۂ̒lANVtH[̃lXgvpeB̏ꍇAɌ؂s邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testValidateArraysIndex29() throws Exception {

        //eXgf[^ݒ
        this.formEx =
            (DynaValidatorActionFormEx) creator.create(CONFIG_FILE_NAME);
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName("alphaNumericStringArray");

        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("rows.value");
        Var var = new Var();
        field.addVar(var);
        Arg arg0 = new Arg();
        arg0.setPosition(0);
        arg0.setKey("##INDEX");
        arg0.setResource(false);
        field.addArg(arg0);
        Msg msg = new Msg();
        msg.setKey("alphaNumericStringArray");
        msg.setName("alphaNumericStringArray");
        field.addMsg(msg);
        UTUtil.invokePrivate(field, "process", Map.class, Map.class, 
        		new HashMap(), new HashMap());

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        FieldChecksEx_HttpServletRequestImpl01 request =
            new FieldChecksEx_HttpServletRequestImpl01();
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("logon");
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        MockHttpSession session = new MockHttpSession();
        FieldChecksEx_JavaBeanStub01[] rows = {
            new FieldChecksEx_JavaBeanStub01(),
            new FieldChecksEx_JavaBeanStub01(),
            new FieldChecksEx_JavaBeanStub01()
        };
        rows[0].value = "Ă";
        rows[1].value = "test";
        rows[2].value = "Ă";
        formEx.set("rows", rows);

        session.setAttribute("logon", formEx);
        request.setSession(session);

        FieldChecksEx_MessageResourcesImpl01 messageResources =
            new FieldChecksEx_MessageResourcesImpl01(null ,null);
        messageResources.message = "{0}";
        request.setAttribute(Globals.MESSAGES_KEY, messageResources);

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[2ǉĂ邱ƁB
        assertEquals(2, errors.size());
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("alphaNumericStringArray", message.getKey());
        assertEquals("1", message.getValues()[0]);
        message = (ActionMessage) it.next();
        assertEquals("alphaNumericStringArray", message.getKey());
        assertEquals("3", message.getValues()[0]);



    }

    /**
     * testValidateArraysIndex30()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6SĐ<br>
     *                nameF"requiredArray"<br>
     *         () field:property="rowList.map(key)"<br>
     *                arg:position="0",key="##INDEX",<br>
     *                  resource="false"<br>
     *                msg:key="requiredArray",name="requiredArray"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:ANVtH[F"logon"<br>
     *         () session:L[F"logon"ɑ΂l<br>
     *                ActionFormIuWFNg<br>
     *         () ActionForm:DynaValidatorActionFormExCX^X<br>
     *                ArrayList<JavaBean> rowList<br>
     *                 + rowList[0]<br>
     *                     + Map map = { key = null }<br>
     *                 + rowList[1]<br>
     *                     + Map map = { key = null }<br>
     *                 + rowList[2]<br>
     *                     + Map map = { key = null }<br>
     *         () bZ[W\[X:message={0}<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage(<br>
     *                      "minLengthArray",<br>
     *                      arg{"1"})<br>
     *                    ActionMessage(<br>
     *                      "minLengthArray",<br>
     *                      arg{"2"})<br>
     *                    ActionMessage(<br>
     *                      "minLengthArray",<br>
     *                      arg{"2"})<br>
     *
     * <br>
     * ؑΏۂ̒lANVtH[̃lXgvpeB̏ꍇAɌ؂s邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings({"deprecation","unchecked"})
    public void testValidateArraysIndex30() throws Exception {
        //eXgf[^ݒ
        this.formEx =
            (DynaValidatorActionFormEx) creator.create(CONFIG_FILE_NAME);
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName("requiredArray");

        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("rowList.map(key)");
        Var var = new Var();
        field.addVar(var);
        Arg arg0 = new Arg();
        arg0.setPosition(0);
        arg0.setKey("##INDEX");
        arg0.setResource(false);
        field.addArg(arg0);
        Msg msg = new Msg();
        msg.setKey("requiredArray");
        msg.setName("requiredArray");
        field.addMsg(msg);
        UTUtil.invokePrivate(field, "process", Map.class, Map.class, 
        		new HashMap(), new HashMap());

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        FieldChecksEx_HttpServletRequestImpl01 request =
            new FieldChecksEx_HttpServletRequestImpl01();
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("logon");
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        MockHttpSession session = new MockHttpSession();
        List rowList = new ArrayList();
        FieldChecksEx_JavaBeanStub01 row = new FieldChecksEx_JavaBeanStub01();
        Map map = new HashMap();
        map.put("key", null);
        row.map = map;
        rowList.add(row);
        row = new FieldChecksEx_JavaBeanStub01();
        map = new HashMap();
        map.put("key", null);
        row.map = map;
        rowList.add(row);
        row = new FieldChecksEx_JavaBeanStub01();
        map = new HashMap();
        map.put("key", null);
        row.map = map;
        rowList.add(row);
        formEx.set("rowList", rowList);

        session.setAttribute("logon", formEx);
        request.setSession(session);

        FieldChecksEx_MessageResourcesImpl01 messageResources =
            new FieldChecksEx_MessageResourcesImpl01(null ,null);
        messageResources.message = "{0}";
        request.setAttribute(Globals.MESSAGES_KEY, messageResources);

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[2ǉĂ邱ƁB
        assertEquals(3, errors.size());
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("requiredArray", message.getKey());
        assertEquals("1", message.getValues()[0]);
        message = (ActionMessage) it.next();
        assertEquals("requiredArray", message.getKey());
        assertEquals("2", message.getValues()[0]);
        message = (ActionMessage) it.next();
        assertEquals("requiredArray", message.getKey());
        assertEquals("3", message.getValues()[0]);


    }

    /**
     * testValidateArraysIndex31()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:*<br>
     *         () va:methodParamsF6SĐ<br>
     *                nameF"requiredArray"<br>
     *         () field:property="/"<br>
     *                arg:position="0",key="##INDEX",<br>
     *                  resource="false"<br>
     *                msg:key="requiredArray",name="requiredArray"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:ANVtH[F"logon"<br>
     *         () session:L[F"logon"ɑ΂l<br>
     *                ActionFormIuWFNg<br>
     *         () ActionForm:DynaValidatorActionFormExCX^X<br>
     *                ArrayList<JavaBean> rowList<br>
     *                 + rowList[0]<br>
     *                     + Map map = { key = null }<br>
     *                 + rowList[1]<br>
     *                     + Map map = { key = null }<br>
     *                 + rowList[2]<br>
     *                     + Map map = { key = null }<br>
     *         () bZ[W\[X:message={0}<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxFG[
     *                         OFIllegalArgumentException
     *                               "Invalid character has found within property name. '/' Cannot use [ / \" ' ]"
     *
     * <br>
     * sȃvpeBw肳ꂽꍇAG[Oo͂Atrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings({"deprecation","unchecked"})
    public void testValidateArraysIndex31() throws Exception {
        //eXgf[^ݒ
        this.formEx =
            (DynaValidatorActionFormEx) creator.create(CONFIG_FILE_NAME);
        // ++++ beanIuWFNg ++++
        String bean = null;

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setMethodParams(this.validClassStr);
        va.setName("requiredArray");

        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("/");
        Var var = new Var();
        field.addVar(var);
        Arg arg0 = new Arg();
        arg0.setPosition(0);
        arg0.setKey("##INDEX");
        arg0.setResource(false);
        field.addArg(arg0);
        Msg msg = new Msg();
        msg.setKey("requiredArray");
        msg.setName("requiredArray");
        field.addMsg(msg);
        UTUtil.invokePrivate(field, "process", Map.class, Map.class, 
        		new HashMap(), new HashMap());

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        FieldChecksEx_HttpServletRequestImpl01 request =
            new FieldChecksEx_HttpServletRequestImpl01();
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("logon");
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        MockHttpSession session = new MockHttpSession();
        List rowList = new ArrayList();
        FieldChecksEx_JavaBeanStub01 row = new FieldChecksEx_JavaBeanStub01();
        Map map = new HashMap();
        map.put("key", null);
        row.map = map;
        rowList.add(row);
        row = new FieldChecksEx_JavaBeanStub01();
        map = new HashMap();
        map.put("key", null);
        row.map = map;
        rowList.add(row);
        row = new FieldChecksEx_JavaBeanStub01();
        map = new HashMap();
        map.put("key", null);
        row.map = map;
        rowList.add(row);
        formEx.set("rowList", rowList);

        session.setAttribute("logon", formEx);
        request.setSession(session);

        FieldChecksEx_MessageResourcesImpl01 messageResources =
            new FieldChecksEx_MessageResourcesImpl01(null ,null);
        messageResources.message = "{0}";
        request.setAttribute(Globals.MESSAGES_KEY, messageResources);

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateArraysIndex(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[O
        assertTrue(LogUTUtil.checkError("",
                new IllegalArgumentException(
                        "Invalid character has found " +
                        "within property name. '/' Cannot use [ / \" ' ]")));

    }

    /**
     * testGetHankakuKanaList01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() hankakuKanaList:¯
     *                                ֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) String:¯֬
     *                         ܦް<br>
     *
     * <br>
     * NXϐhankakuKanaList̒l擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetHankakuKanaList01() throws Exception {
        assertEquals("¯" +
                "֬ܦް",
                FieldChecksEx.getHankakuKanaList());
    }

    /**
     * testGetZenkakuKanaList01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() zenkakuKanaList:ACEGI@BDFHJLNPR
     *                                KMOQSTVXZ\UWY[]^`ceg
     *                                _adfhijklmnqtwzorux{
     *                                psvy|}~
     *                                b[<br>
     *         () vpeBt@C:validation.zenkaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) String:ACEGI@BDFHJLNPRKMOQS
     *                         TVXZ\UWY[]^`ceg_adfh
     *                         ijklmnqtwzorux{psvy|
     *                         }~
     *                         b[<br>
     *
     * <br>
     * NXϐzenkakuKanaList̒l擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetZenkakuKanaList01() throws Exception {
        assertEquals("ACEGI@BDFHJLNPRKMOQS" +
                "TVXZ\UWY[]^`ceg_adfhijklm" +
                "nqtwzorux{psvy|}~" +
                "b[",
                FieldChecksEx.getZenkakuKanaList());
    }

}
