/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.taglib;

import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

import jp.terasoluna.utlib.PropertyTestCase;
import jp.terasoluna.utlib.TagUTUtil;
import jp.terasoluna.utlib.UTUtil;

import org.apache.struts.Globals;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

import com.mockrunner.mock.web.MockHttpServletRequest;

/**
 * MessagesPopupTag ubN{bNXeXgB<br>
 * O<br>
 * Ȃ<br>
 * <br>
 */
public class MessagesPopupTagTest extends PropertyTestCase {

    //eXgΏ
    MessagesPopupTag tag = null;

    /**
     * Constructor for MessagesPopupTagTest.
     * @param arg0
     */
    public MessagesPopupTagTest(String arg0) {
        super(arg0);
    }

    /*
     * @see TestCase#setUp()
     */
    @Override
    protected void setUpData() throws Exception {
        Map<String, String> overProps = new TreeMap<String, String>();
        overProps.put("messages.popup.param.paramType", "religion");
        addPropertyAll(overProps);
        tag = (MessagesPopupTag) TagUTUtil.create(MessagesPopupTag.class);
    }

    /*
     * @see TestCase#tearDown()
     */
    @Override
    protected void cleanUpData() throws Exception {
    }

    /**
     * testDoStartTag01B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒l
     * NGXg̃G[Fnull
     * NGXg̃bZ[WFnull
     * 
     * 
     * Ғl
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     * NGXgON_LOAD_KEY=null
     * 
     * NGXgɃG[EbZ[W񂪋ɑ݂ȂA
     * NGXgɃ|bvAbvXNvgo^ĂȂ
     * ƂƁANGXgɃXNvgo^ĂȂƂ
     * mFB
     */
    public void testDoStartTag01() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɊ֘Atꂽ(Mock)HttpServletRequest擾
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();
        // |bvAbvURL
        UTUtil.setPrivateField(tag, "popup", "/popup.do");
        // ReLXgpXw
        TagUTUtil.setContextPath(tag, "contextPath");

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.EVAL_BODY_INCLUDE);
        // NGXgɃXNvgo^ĂȂƁB
        assertNull(req.getAttribute(MessagesPopupTag.ON_LOAD_KEY));
        // ZbVɁAG[EbZ[W񂪓o^ĂȂƁB
        HttpSession session = req.getSession(true);
        Enumeration enumeration = session.getAttributeNames();
        assertFalse(enumeration.hasMoreElements());
    }

    /**
     * testDoStartTag02B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒l
     * NGXg̃G[FG[
     * NGXg̃bZ[WFnull
     * 
     * 
     * Ғl
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     * NGXgON_LOAD_KEY=null
     * 
     * NGXgɃG[񂪋œo^ĂƂ
     * ZbVɃG[񂪓o^ꂸANGXg
     * ɃXNvgo^ĂȂƂmFB
     */
    public void testDoStartTag02() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɊ֘Atꂽ(Mock)HttpServletRequest擾
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();

        // eXgf[^ݒ
        // G[͋
        ActionMessages messages = new ActionMessages();
        req.setAttribute(Globals.ERROR_KEY, messages);
        // |bvAbvURL
        UTUtil.setPrivateField(tag, "popup", "/popup.do");
        // ReLXgpXw
        TagUTUtil.setContextPath(tag, "contextPath");

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.EVAL_BODY_INCLUDE);
        // NGXgɃXNvgo^ĂȂƁB
        assertNull(req.getAttribute(MessagesPopupTag.ON_LOAD_KEY));
        // ZbVɁAG[EbZ[W񂪓o^ĂȂƁB
        HttpSession session = req.getSession(true);
        Enumeration enumeration = session.getAttributeNames();
        assertFalse(enumeration.hasMoreElements());
    }

    /**
     * testDoStartTag03B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒l
     * NGXg̃G[FG[3
     * NGXg̃bZ[WFnull
     * 
     * Ғl
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     * NGXgON_LOAD_KEY=
     *   window.open("contextPath/popup.do?popup_error_key=XXXXXXX",
     *       "popup",
     *       "");
     * 
     * NGXgɃG[3o^ĂƂ
     * ̃G[񂪃ZbVɊi[ANGXg
     * ɃXNvgo^邱ƂmFB
     */
    public void testDoStartTag03() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɊ֘Atꂽ(Mock)HttpServletRequest擾
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();

        // eXgf[^ݒ
        // G[3
        ActionMessages errors = new ActionMessages();
        ActionMessage error1 = new ActionMessage("errors.error1");
        ActionMessage error2 = new ActionMessage("errors.error2");
        ActionMessage error3 = new ActionMessage("errors.error3");
        errors.add(Globals.ERROR_KEY, error1);
        errors.add(Globals.ERROR_KEY, error2);
        errors.add(Globals.ERROR_KEY, error3);
        req.setAttribute(Globals.ERROR_KEY, errors);
        // |bvAbvURL
        UTUtil.setPrivateField(tag, "popup", "/popup.do");
        // ReLXgpXw
        TagUTUtil.setContextPath(tag, "contextPath");

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.EVAL_BODY_INCLUDE);
        // NGXgɃXNvgo^Ă邱ƁB
        // XNvg̃_L[ȊOvĂ邱ƁB
        String script = (String) req.getAttribute(MessagesPopupTag.ON_LOAD_KEY);
        assertTrue(
            script.startsWith(
                "  window.open(\"contextPath/popup.do?popup_error_key="));
        assertTrue(
            script.endsWith(
                "\", \"popup\", \"\");"
                    + System.getProperty("line.separator")));

        // ZbVɁAG[񂪓o^Ă邱ƁB
        HttpSession session = req.getSession(true);
        Enumeration enumeration = session.getAttributeNames();
        int cnt = 0;
        while (enumeration.hasMoreElements()) {
            Object obj = session.getAttribute((String) enumeration
                    .nextElement());
            assertEquals(ActionMessages.class.getName(), obj.getClass()
                    .getName());
            assertEquals(3, ((ActionMessages) obj).size(Globals.ERROR_KEY));
            cnt++;
        }
        assertEquals(1, cnt);
    }

    /**
     * testDoStartTag04B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒l
     * NGXg̃G[Fnull
     * NGXg̃bZ[WFbZ[W񂪋
     * 
     * 
     * Ғl
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     * NGXgON_LOAD_KEY=null
     * 
     * NGXgɃbZ[W񂪋œo^ĂƂ
     * ZbVɃbZ[W񂪓o^ꂸANGXg
     * ɃXNvgo^ĂȂƂmFB
     */
    public void testDoStartTag04() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɊ֘Atꂽ(Mock)HttpServletRequest擾
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();

        // eXgf[^ݒ
        // G[͋
        ActionMessages messages = new ActionMessages();
        req.setAttribute(Globals.MESSAGE_KEY, messages);
        // |bvAbvURL
        UTUtil.setPrivateField(tag, "popup", "/popup.do");
        // ReLXgpXw
        TagUTUtil.setContextPath(tag, "contextPath");

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.EVAL_BODY_INCLUDE);
        // NGXgɃXNvgo^ĂȂƁB
        assertNull(req.getAttribute(MessagesPopupTag.ON_LOAD_KEY));
        // ZbVɁAG[EbZ[W񂪓o^ĂȂƁB
        HttpSession session = req.getSession(true);
        Enumeration enumeration = session.getAttributeNames();
        assertFalse(enumeration.hasMoreElements());
    }

    /**
     * testDoStartTag05B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒l
     * NGXg̃G[Fnull
     * NGXg̃bZ[WF3
     * 
     * Ғl
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     * NGXgON_LOAD_KEY=
     *   window.open("contextPath/popup.do?popup_message_key=XXXXXXX",
     *       "popup",
     *       "");
     * 
     * NGXgɃbZ[W3o^ĂƂ
     * ̃bZ[W񂪃ZbVɊi[ANGXg
     * ɃXNvgo^邱ƂmFB
     */
    public void testDoStartTag05() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɊ֘Atꂽ(Mock)HttpServletRequest擾
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();

        // eXgf[^ݒ
        // bZ[W3
        ActionMessages messages = new ActionMessages();
        ActionMessage message1 = new ActionMessage("messages.message1");
        ActionMessage message2 = new ActionMessage("messages.message2");
        ActionMessage message3 = new ActionMessage("messages.message3");
        messages.add(Globals.MESSAGE_KEY, message1);
        messages.add(Globals.MESSAGE_KEY, message2);
        messages.add(Globals.MESSAGE_KEY, message3);
        req.setAttribute(Globals.MESSAGE_KEY, messages);
        // |bvAbvURL
        UTUtil.setPrivateField(tag, "popup", "/popup.do");
        // ReLXgpXw
        TagUTUtil.setContextPath(tag, "contextPath");

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.EVAL_BODY_INCLUDE);
        // NGXgɃXNvgo^Ă邱ƁB
        // XNvg̃_L[ȊOvĂ邱ƁB
        String script = (String) req.getAttribute(MessagesPopupTag.ON_LOAD_KEY);
        assertTrue(
            script.startsWith(
                "  window.open(\"contextPath/popup.do?popup_message_key="));
        assertTrue(
            script.endsWith(
                "\", \"popup\", \"\");"
                    + System.getProperty("line.separator")));

        // ZbVɁAbZ[W񂪓o^Ă邱ƁB
        HttpSession session = req.getSession(true);
        Enumeration enumeration = session.getAttributeNames();
        int cnt = 0;
        while (enumeration.hasMoreElements()) {
            Object obj = session.getAttribute((String) enumeration
                    .nextElement());
            assertEquals(ActionMessages.class.getName(), obj.getClass()
                    .getName());
            assertEquals(3, ((ActionMessages) obj).size(Globals.MESSAGE_KEY));
            cnt++;
        }
        assertEquals(1, cnt);
    }

    /**
     * testDoStartTag06B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒l NGXg̃G[F2 NGXg̃bZ[WF3
     * 
     * Ғl ߂l:int=EVAL_BODY_INCLUDE<br>
     * NGXgON_LOAD_KEY=
     * window.open("contextPath/popup.do?popup_error_key=XXXXXXX&popup_message_key=YYYYYY",
     * "popup", "");
     * 
     * NGXgɃG[2AbZ[W3o^ ĂƂ̃G[EbZ[W񂪃ZbV
     * i[ANGXgɃXNvgo^邱ƂmFB
     */
    public void testDoStartTag06() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɊ֘Atꂽ(Mock)HttpServletRequest擾
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();

        // eXgf[^ݒ
        // G[2
        ActionMessages errors = new ActionMessages();
        ActionMessage error1 = new ActionMessage("errors.error1");
        ActionMessage error2 = new ActionMessage("errors.error2");
        errors.add(Globals.ERROR_KEY, error1);
        errors.add(Globals.ERROR_KEY, error2);
        req.setAttribute(Globals.ERROR_KEY, errors);

        // bZ[W3
        ActionMessages messages = new ActionMessages();
        ActionMessage message1 = new ActionMessage("messages.message1");
        ActionMessage message2 = new ActionMessage("messages.message2");
        ActionMessage message3 = new ActionMessage("messages.message3");
        messages.add(Globals.MESSAGE_KEY, message1);
        messages.add(Globals.MESSAGE_KEY, message2);
        messages.add(Globals.MESSAGE_KEY, message3);
        req.setAttribute(Globals.MESSAGE_KEY, messages);
        // |bvAbvURL
        UTUtil.setPrivateField(tag, "popup", "/popup.do");
        // ReLXgpXw
        TagUTUtil.setContextPath(tag, "contextPath");

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.EVAL_BODY_INCLUDE);
        // NGXgɃXNvgo^Ă邱ƁB
        // XNvg̃_L[ȊOvĂ邱ƁB
        String script = (String) req.getAttribute(MessagesPopupTag.ON_LOAD_KEY);
        assertTrue(
            script.startsWith(
                "  window.open(\"contextPath/popup.do?popup_error_key="));
        assertTrue(
            script.indexOf(
                "&popup_message_key=",
                "  window.open(\"contextPath/popup.do?popup_error_key="
                    .length())
                != -1);
        assertTrue(
            script.endsWith(
                "\", \"popup\", \"\");"
                    + System.getProperty("line.separator")));

        // ZbVɁAbZ[W񂪓o^Ă邱ƁB
        HttpSession session = req.getSession(true);
        Enumeration enu = session.getAttributeNames();
        // G[EbZ[W̃IuWFNg݌
        int errorCount = 0;
        int messageCount = 0;
        int cnt = 0;
        while (enu.hasMoreElements()) {
            Object obj = session.getAttribute((String) enu.nextElement());
            assertEquals(ActionMessages.class.getName(), obj.getClass()
                    .getName());
            if (((ActionMessages) obj).size(Globals.ERROR_KEY) == 2) {
                // G[2
                errorCount++;
            }
            if (((ActionMessages) obj).size(Globals.MESSAGE_KEY) == 3) {
                // bZ[W3
                messageCount++;
            }
            cnt++;
        }
        // 킹2ł邱ƁB
        assertEquals(2, cnt);
        // ZbṼG[EbZ[W
        // ݌1ł邱ƁB
        assertEquals(1, errorCount);
        assertEquals(1, messageCount);
    }

    /**
     * testGetOnLoadScript01()B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒l
     * req=[NGXg
     * errorKey=null
     * messageKey=null
     * popup="/popup.do"
     * windowId=null
     * title=null
     * paramFunc=null
     * param=null
     * paramType=null
     * 
     * Ғl
     * ߂l:XNvgnull<br>
     * 
     * ZbVɊi[G[L[AbZ[WL[
     * nullłƂAXNvgnullŕԋp邱ƁB
     */
    public void testGetOnLoadScript01() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɊ֘Atꂽ(Mock)HttpServletRequest擾
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();
        // |bvAbvURL
        UTUtil.setPrivateField(tag, "popup", "/popup.do");
        // ReLXgpXw
        TagUTUtil.setContextPath(tag, "contextPath");
        
        Class[] argClazz =
            new Class[] {
                HttpServletRequest.class,
                String.class,
                String.class };

        Object[] argObj = new Object[] { req, null, null };

        // eXgs
        Object retObj =
            UTUtil.invokePrivate(tag, "getOnLoadScript", argClazz, argObj);

        // eXgʊmF
        assertNull(retObj);

    }

    /**
     * testGetOnLoadScript02()B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒l
     * req=[NGXg
     * errorKey="errorKey"
     * messageKey=null
     * popup="/popup.do"
     * windowId=null
     * title=null
     * paramFunc=null
     * param=null
     * paramType=null
     * 
     * Ғl
     * ߂l:"  window.open("contextPath/popup.do?popup_error_key=errorKey",
     *  "popup", "");<br>
     * <br>
     * ZbVɊi[G[L[̕񂪐ݒ肳A
     * bZ[WL[nullłƂAG[L[|bvAbv
     * NGXgp[^ƂăXNvgɏo͂邱ƁB
     */
    public void testGetOnLoadScript02() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɊ֘Atꂽ(Mock)HttpServletRequest擾
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();
        // |bvAbvURL
        UTUtil.setPrivateField(tag, "popup", "/popup.do");
        // ReLXgpXw
        TagUTUtil.setContextPath(tag, "contextPath");

        Class[] argClazz =
            new Class[] {
                HttpServletRequest.class,
                String.class,
                String.class };

        Object[] argObj = new Object[] { req, "errorKey", null };

        // eXgs
        Object retObj =
            UTUtil.invokePrivate(tag, "getOnLoadScript", argClazz, argObj);

        // eXgʊmF
        assertEquals(
            "  window.open(\"contextPath/popup.do?popup_error_key=errorKey\", \"popup\", \"\");"
                + System.getProperty("line.separator"),
            retObj);

    }

    /**
     * testGetOnLoadScript03()B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒l
     * req=[NGXg
     * errorKey=null
     * messageKey="messageKey"
     * popup="/popup.do"
     * windowId=null
     * title=null
     * paramFunc=null
     * param=null
     * paramType=null
     * 
     * Ғl
     * ߂l:"  window.open("contextPath/popup.do?popup_message_key=messageKey",
     *  "popup", "");<br>
     * <br>
     * ZbVɊi[G[L[nullłA
     * bZ[WL[ɕ񂪐ݒ肳ĂƂAbZ[WL[
     * |bvAbṽNGXgp[^ƂăXNvg
     * o͂邱ƁB
     */
    public void testGetOnLoadScript03() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɊ֘Atꂽ(Mock)HttpServletRequest擾
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();
        // |bvAbvURL
        UTUtil.setPrivateField(tag, "popup", "/popup.do");
        // ReLXgpXw
        TagUTUtil.setContextPath(tag, "contextPath");

        Class[] argClazz =
            new Class[] {
                HttpServletRequest.class,
                String.class,
                String.class };

        Object[] argObj = new Object[] { req, null, "messageKey" };

        // eXgs
        Object retObj =
            UTUtil.invokePrivate(tag, "getOnLoadScript", argClazz, argObj);

        // eXgʊmF
        assertEquals(
            "  window.open(\"contextPath/popup.do?popup_message_key=messageKey\", \"popup\", \"\");"
                + System.getProperty("line.separator"),
            retObj);

    }

    /**
     * testGetOnLoadScript04()B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒l
     * req=[NGXg
     * errorKey="errorKey"
     * messageKey="messageKey"
     * popup="/popup.do"
     * windowId=null
     * title=null
     * paramFunc=null
     * param=null
     * paramType=null
     * 
     * Ғl
     * ߂l:"  window.open("contextPath/popup.do?popup_error_key=errorKey&
     *  popup_message_key=messageKey","popup", "");<br>
     * <br>
     * ZbVɊi[G[AbZ[W
     * ɑ݂鎞̃L[|bvAbvXNvg
     * o͂A&ɂ茋Ă邱ƁB
     */
    public void testGetOnLoadScript04() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɊ֘Atꂽ(Mock)HttpServletRequest擾
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();
        // |bvAbvURL
        UTUtil.setPrivateField(tag, "popup", "/popup.do");
        // ReLXgpXw
        TagUTUtil.setContextPath(tag, "contextPath");

        Class[] argClazz =
            new Class[] {
                HttpServletRequest.class,
                String.class,
                String.class };

        Object[] argObj = new Object[] { req, "errorKey", "messageKey" };

        // eXgs
        Object retObj =
            UTUtil.invokePrivate(tag, "getOnLoadScript", argClazz, argObj);

        // eXgʊmF
        assertEquals(
            "  window.open(\"contextPath/popup.do?popup_error_key=errorKey&"
                + "popup_message_key=messageKey\", \"popup\", \"\");"
                + System.getProperty("line.separator"),
            retObj);

    }

    /**
     * testGetOnLoadScript05()B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒l
     * req=[NGXg
     * errorKey="errorKey"
     * messageKey=null
     * popup="/popup.do"
     * windowId="windowId"
     * title=null
     * paramFunc=null
     * param=null
     * paramType=null
     * 
     * Ғl
     * ߂l:"  windowId = window.open("contextPath/popup.do?
     *  popup_error_key=errorKey","popup", "");<br>
     * <br>
     * 
     * MessagePopupTag#setWindowId()ɂAEBhEIDw肳
     * ꍇAXNvg̖߂lƂĕϐ`邱ƁB
     */
    public void testGetOnLoadScript05() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɊ֘Atꂽ(Mock)HttpServletRequest擾
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();
        // |bvAbvURL
        UTUtil.setPrivateField(tag, "popup", "/popup.do");
        // ReLXgpXw
        TagUTUtil.setContextPath(tag, "contextPath");

        Class[] argClazz =
            new Class[] {
                HttpServletRequest.class,
                String.class,
                String.class };

        Object[] argObj = new Object[] { req, "errorKey", null };

        // eXgs
        UTUtil.setPrivateField(tag, "windowId", "windowId");
        Object retObj =
            UTUtil.invokePrivate(tag, "getOnLoadScript", argClazz, argObj);

        // eXgʊmF
        assertEquals(
            "  windowId = window.open(\"contextPath/popup.do?popup_error_key=errorKey\", \"popup\", \"\");"
                + System.getProperty("line.separator"),
            retObj);
    }

    /**
     * testGetOnLoadScript06()B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒l
     * req=[NGXg
     * errorKey="errorKey"
     * messageKey=null
     * popup="/popup.do"
     * windowId=null
     * title="title"
     * paramFunc=null
     * param=null
     * paramType=null
     * 
     * Ғl
     * ߂l:"  window.open("contextPath/popup.do?
     *  popup_error_key=errorKey","title", "");<br>
     * <br>
     * 
     * MessagePopupTag#setTitle()ɂAEBhE^Cg
     * w肳ĂꍇAXNvg̈Ƃďo͂邱ƁB
     */
    public void testGetOnLoadScript06() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɊ֘Atꂽ(Mock)HttpServletRequest擾
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();
        // |bvAbvURL
        UTUtil.setPrivateField(tag, "popup", "/popup.do");
        // ReLXgpXw
        TagUTUtil.setContextPath(tag, "contextPath");

        Class[] argClazz =
            new Class[] {
                HttpServletRequest.class,
                String.class,
                String.class };

        Object[] argObj = new Object[] { req, "errorKey", null };

        // eXgs
        UTUtil.setPrivateField(tag, "title", "title");
        Object retObj =
            UTUtil.invokePrivate(tag, "getOnLoadScript", argClazz, argObj);

        // eXgʊmF
        assertEquals(
            "  window.open(\"contextPath/popup.do?popup_error_key=errorKey\", \"title\", \"\");"
                + System.getProperty("line.separator"),
            retObj);
    }

    /**
     * testGetOnLoadScript07()B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒l
     * req=[NGXg
     * errorKey="errorKey"
     * messageKey=null
     * popup="/popup.do"
     * windowId=null
     * title=null
     * paramFunc="paramFunc()"
     * param=null
     * paramType=null
     * 
     * Ғl
     * ߂l:"  window.open("contextPath/popup.do?
     *  popup_error_key=errorKey","popup", paramFunc());<br>
     * <br>
     * 
     * MessagePopupTag#setParamFunc()ɂAp[^擾
     * JavaScript֐o͂邱ƁB
     */
    public void testGetOnLoadScript07() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɊ֘Atꂽ(Mock)HttpServletRequest擾
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();
        // |bvAbvURL
        UTUtil.setPrivateField(tag, "popup", "/popup.do");
        // ReLXgpXw
        TagUTUtil.setContextPath(tag, "contextPath");

        Class[] argClazz =
            new Class[] {
                HttpServletRequest.class,
                String.class,
                String.class };

        Object[] argObj = new Object[] { req, "errorKey", null };

        // eXgs
        UTUtil.setPrivateField(tag, "paramFunc", "paramFunc()");
        Object retObj =
            UTUtil.invokePrivate(tag, "getOnLoadScript", argClazz, argObj);

        // eXgʊmF
        assertEquals(
            "  window.open(\"contextPath/popup.do?popup_error_key=errorKey\", \"popup\", paramFunc());"
                + System.getProperty("line.separator"),
            retObj);
    }

    /**
     * testGetOnLoadScript08()B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒l
     * req=[NGXg
     * errorKey="errorKey"
     * messageKey=null
     * popup="/popup.do"
     * windowId=null
     * title=null
     * paramFunc=null
     * param="param"
     * paramType=null
     * 
     * Ғl
     * ߂l:"  window.open("contextPath/popup.do?
     *  popup_error_key=errorKey","popup", "param");<br>
     * <br>
     * 
     * MessagePopupTag#setParam()ɂA|bvAbv̈ʒuATCY
     * 肷p[^񂪃XNvgƂēn邱ƁB
     */
    public void testGetOnLoadScript08() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɊ֘Atꂽ(Mock)HttpServletRequest擾
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();
        // |bvAbvURL
        UTUtil.setPrivateField(tag, "popup", "/popup.do");
        // ReLXgpXw
        TagUTUtil.setContextPath(tag, "contextPath");

        Class[] argClazz =
            new Class[] {
                HttpServletRequest.class,
                String.class,
                String.class };

        Object[] argObj = new Object[] { req, "errorKey", null };

        // eXgs
        UTUtil.setPrivateField(tag, "param", "param");
        Object retObj =
            UTUtil.invokePrivate(tag, "getOnLoadScript", argClazz, argObj);

        // eXgʊmF
        assertEquals(
            "  window.open(\"contextPath/popup.do?popup_error_key=errorKey\", \"popup\", \"param\");"
                + System.getProperty("line.separator"),
            retObj);
    }

    /**
     * testGetRequestParameterKey01()B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * 
     * ZbVɊi[ĂG[EbZ[W̃L[
     * ANG擾B
     */
    public void testGetRequestParameterKey01() throws Exception {
        // {́AtestGetOnLoadScriptXX()ɓB
    }

    /**
     * testSetPopup01()B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * popuptB[h̃Zb^[mFB
     */
    public void testSetPopup01() throws Exception {

        // eXgs
        tag.setPopup("popup");

        // eXgʊmF
        assertEquals("popup", UTUtil.getPrivateField(tag, "popup"));
    }

    /**
     * testSetTitle01()B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * titletB[h̃Zb^[mFB
     * ftHgDEFAULT_TITLEݒ肳ĂA
     * Zb^[s邱Ƃɂ㏑s邱ƁB
     */
    public void testSetTitle01() throws Exception {

        // eXgsEʊmF
        // ftHgDEFAULT_TITLEݒ肳Ă邱ƁB
        assertEquals(
            UTUtil.getPrivateField(MessagesPopupTag.class, "DEFAULT_TITLE"),
            UTUtil.getPrivateField(tag, "title"));

        tag.setTitle("title");
        
        // titletB[h㏑Ă邱ƁB
        assertEquals("title", UTUtil.getPrivateField(tag, "title"));
    }

    /**
     * testSetParam01()B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * paramtB[h̃Zb^[mFB
     */
    public void testSetParam01() throws Exception {
 
        // eXgs
        tag.setParam("param");
        
        // eXgʊmF
        assertEquals("param", UTUtil.getPrivateField(tag, "param"));
    }

    /**
     * testSetParamType01()B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * param̃Zb^[mFB
     * vpeBt@Cmessages.popup.param. + [Zb^[]
     * QƂ邱ƂɂAparamtB[hɁA̒lݒ肳Ă邱ƁB
     */
    public void testSetParamType01() throws Exception {

        // eXgs
        tag.setParamType("paramType");

        // eXgʊmF
        assertEquals("religion", UTUtil.getPrivateField(tag,"param"));
    }

    /**
     * testSetParamFunc01()B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * paramFunctB[h̃Zb^[mFB
     */
    public void testSetParamFunc01() throws Exception {
 
        // eXgs
        tag.setParamFunc("paramFunc()");
        
        // eXgʊmF
        assertEquals("paramFunc()", UTUtil.getPrivateField(tag, "paramFunc"));
    }

    /**
     * testSetWindowId01()B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * windowIdtB[h̃Zb^[mFB
     */
    public void testSetWindowId01() throws Exception {
 
        // eXgs
        tag.setWindowId("windowId");

        // eXgʊmF
        assertEquals("windowId", UTUtil.getPrivateField(tag, "windowId"));
    }

    /**
     * testDoEndTag01()B<br>
     * 
     * (n)<br>
     * ϓ_FB<br>
     * 
     * EVAL_PAGEԋp邱ƁB
     */
    public void testDoEndTag01() throws Exception {
        // eXgs
        assertEquals(Tag.EVAL_PAGE, tag.doEndTag());
    }

    /**
     * testRelease01()B<br>
     * 
     * (n)<br>
     * ϓ_FB<br>
     * 
     * MessagesPopupTagŎgpCX^XϐJĂ邱ƁB
     * 
     */
    public void testRelease01() throws Exception {

        UTUtil.setPrivateField(tag, "popup", "popup");
        UTUtil.setPrivateField(tag, "title", "title");
        UTUtil.setPrivateField(tag, "param", "param");
        UTUtil.setPrivateField(tag, "paramFunc", "paramFunc()");
        UTUtil.setPrivateField(tag, "windowId", "windowId");

        // eXgs
        tag.release();

        // eXgʊmF
        assertNull(UTUtil.getPrivateField(tag, "popup"));
        assertEquals(
            UTUtil.getPrivateField(MessagesPopupTag.class, "DEFAULT_TITLE"),
            UTUtil.getPrivateField(tag, "title"));
        assertNull(UTUtil.getPrivateField(tag, "param"));
        assertNull(UTUtil.getPrivateField(tag, "paramFunc"));
        assertNull(UTUtil.getPrivateField(tag, "windowId"));
    }

}