/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.taglib;

import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

import jp.terasoluna.utlib.TagUTUtil;
import junit.framework.TestCase;

import org.apache.struts.Globals;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.PropertyMessageResources;
import org.apache.struts.util.PropertyMessageResourcesFactory;

import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockHttpSession;

/**
 * MessagesTag ubN{bNXeXgB<br>
 * O<br>
 * Ȃ<br>
 * <br>
 */
public class MessagesTagTest extends TestCase {

    /**
     * eXgΏ
     */
    private MessagesTag tag = null;

    /**
     * eXgP[XJnOB
     * eXgΏۃ^OAtH[CX^X̐sȂB
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        // eXgΏۃ^O̐
        tag = (MessagesTag) TagUTUtil.create(MessagesTag.class);
    }

    /*
     * @see TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testDoStartTag01B<br>
     * <br>
     * (n)<br>
     * ϓ_FC<br>
     * <br>
     * ͒l<br>
     * NGXgp[^=messageKey݂ȂB
     *                      errorKey݂B
     * <br>
     * Ғl:
     * ߂l:SKIP_BODY<br>
     * <br>
     * NGXgp[^messageKey݂ȂꍇA
     * SKIP_BODYԋpAI邱ƁB
     */
    public void testDoStartTag01() throws Exception {
        // eXgݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();
        // NGXgp[^ݒiG[̂݁j
        req.setupAddParameter(MessagesPopupTag.POPUP_ERROR_KEY, "errorKey");

        // eXgsEʊmF
        assertEquals(Tag.SKIP_BODY, tag.doStartTag());
    }

    /**
     * testDoStartTag02B<br>
     * <br>
     * (n)<br>
     * ϓ_FC<br>
     * <br>
     * ͒l<br>
     * NGXgp[^=errorKey݂B
     *                      messageKey݂B
     * <br>
     * Ғl:
     * ߂l:SKIP_BODY<br>
     * <br>
     * NGXgp[^messageKey݂ƂA
     * ZbṼbZ[W񂪃NGXgɃRs[A
     * ZbV͍폜邱ƂmFB
     */
    public void testDoStartTag02() throws Exception {
        // eXgݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();
        // bZ[W\[X`ieXgʉ߂̂ߕKvj
        MessageResources resources = new PropertyMessageResources(
        new PropertyMessageResourcesFactory(), "");
        pc.setAttribute(
            Globals.MESSAGES_KEY,
            resources,
            PageContext.REQUEST_SCOPE);

        // NGXgp[^ݒ
        req.setupAddParameter(MessagesPopupTag.POPUP_ERROR_KEY, "errorKey");
        req.setupAddParameter(MessagesPopupTag.POPUP_MESSAGE_KEY, "messageKey");
        MockHttpSession session = (MockHttpSession) pc.getSession();

        ActionMessages messages = new ActionMessages();
        ActionMessage message1 = new ActionMessage("messages.message1");
        ActionMessage message2 = new ActionMessage("messages.message2");
        messages.add(Globals.MESSAGE_KEY, message1);
        messages.add(Globals.MESSAGE_KEY, message2);
        // bZ[WZbVƂĐݒ
        session.setAttribute("messageKey", messages);

        ActionMessages errors = new ActionMessages();
        ActionMessage error1 = new ActionMessage("errors.error1");
        ActionMessage error2 = new ActionMessage("errors.error2");
        errors.add(Globals.ERROR_KEY, error1);
        errors.add(Globals.ERROR_KEY, error2);
        // G[ZbVƂĐݒ
        session.setAttribute("errorKey", errors);

        // eXgs
        assertEquals(Tag.SKIP_BODY, tag.doStartTag());
        // NGXgGlobals.MESSAGE_KEYL[Ƃ
        // bZ[W񂪐ݒ肳Ă邱ƁB
        assertSame(messages, req.getAttribute(Globals.MESSAGE_KEY));
        // G[̓NGXgɊi[ĂȂƁB
        assertNull(req.getAttribute(Globals.ERROR_KEY));
        // ZbV烁bZ[W񂪍폜Ă邱ƁB
        assertNull(session.getAttribute("messageKey"));
        // ZbVG[񂪍폜ĂȂƁB
        assertNotNull(session.getAttribute("errorKey"));
    }

}
