/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * Orcalef[^x[X̃V[PXIuWFNg̃ANZX@\NXB<br>
 * C^tF[XDBSequenceB <br><br>
 * 
 * ۂɂOraclẽV[PX𒼐ڂɐݒE擾@͂Ȃ̂ŁA<br>
 * ł̓V[PX̑Ȃǒ`ύXĎĂB<br>
 * 
 * @see jp.terasoluna.utdesigner.express.dbutil.DBSequence
 *
 */
public class OracleDBSequence implements DBSequence {
    /**
     * SYS.USER_SEQUCENCEe[ũRFCYCLE_FLAG
     */
    private static final String CYCLE_FLAG = "CYCLE_FLAG";

    /**
     * SYS.USER_SEQUCENCEe[ũRFCACHE_SIZE
     */
    private static final String CACHE_SIZE = "CACHE_SIZE";

    /**
     * SYS.USER_SEQUCENCEe[ũRFMAX_VALUE
     */
    private static final String MAX_VALUE = "MAX_VALUE";

    /**
     * SYS.USER_SEQUCENCEe[ũRFMIN_VALUE
     */
    private static final String MIN_VALUE = "MIN_VALUE";

    /**
     * SYS.USER_SEQUCENCEe[ũRFINCREMENT_BY
     */
    private static final String INCREMENT_BY = "INCREMENT_BY";


    /**
     * NOCYCLEꍇ̌JԂtO
     */
    private static final String NOCYCLE_FLAG = "N";
    
    /**
     * NOCACHEꍇ̃LbVTCY
     */
    private static final String NOCACHE_SIZE = "0";
    
    /**
     * V[PX̒`<BR>
     * L[FV[PX  lF^}bv
     */
    private Map/*<String, Map<String, String>>*/ sequencesDescMeta = 
            new HashMap/*<String, Map<String, String>>*/();
    
    /**
     * <p>fBtHgERXgN^</p>
     *
     */
    public OracleDBSequence() {
    }

    /**
     * w肵V[PX̌ݒl擾B
     * 
     * @param sequenceName V[PX
     * @return@V[PX̌ݒl
     * 
     * @throws SQLException@DBANZXɗOꍇ
     */
    public int getSequenceValue(String sequenceName) throws SQLException {
        if (sequenceName == null || "".equals(sequenceName)) {
            throw new IllegalArgumentException("parameter (sequenceName) must be valid.");
        }

        int currval = 0;
        
        try {
            //first, we try to get current sequence's value,
            //if we got it and without any exception, then return the current value;
            currval = getCurrVal(sequenceName);
        } catch (SQLException e) { 
            if (e.getMessage().indexOf("ORA-08002") >= 0) {
                //if we got error code like below, we must get it use nextvalue
                // ORA-08002: HOTEL_CODE.CURRVAL͂̃ZbVł͂܂`Ă܂
                // ̒l擾āAJglƂĎg
                currval = getNextVal(sequenceName);
            } else {
                //if the exception is not we wanted, re-throw it.
                throw e;
            }
        }
        
        // ݒl߂
        return currval;
    }

    /**
     * w肵V[PXɒlݒ肷B
     * 
     * @param sequenceName V[PX
     * @param value V[PXɐݒ肷l
     * 
     * @throws SQLException@DBANZXɗOꍇ
     */
    public void setSequenceValue(String sequenceName, int value) throws SQLException {
        if (sequenceName == null || "".equals(sequenceName)) {
            throw new IllegalArgumentException("parameter (sequenceName) must be valid.");
        }
        
        // ő
        BigDecimal minValue = new BigDecimal(getDescMeta(sequenceName, MIN_VALUE));
        // ŏ
        BigDecimal maxValue = new BigDecimal(getDescMeta(sequenceName, MAX_VALUE));
         
        // l͈̔͂̃`FbN
        if(new BigDecimal(String.valueOf(value)).compareTo(minValue)<0 
                || new BigDecimal(String.valueOf(value)).compareTo(maxValue)>0) {
            throw new RuntimeException("V[PX̒l "+value+"  "+
                    minValue+"`"+maxValue+" ͈̔͂𒴂܂B");
        }
        
        // lݒ肷
        setValue(sequenceName, value);
    }
    
    /**
     * V[PX̒lݒ肷B
     * 
     * @param sequenceName V[PX
     * @param value V[PXɐݒ肷l
     * 
     * @throws SQLException@DBANZXɗOꍇ
     */
    private void setValue(String sequenceName, int value) throws SQLException {
        try{
            // ̌JԂIvV
            String oldCycle = getDescMeta(sequenceName, OracleDBSequence.CYCLE_FLAG);

            // JԂɕύXiNOCYCLEݒlMAX΁ANEXTVAL擾ƁAG[ôŁj
            if(NOCYCLE_FLAG.equals(oldCycle)) {
                alterCycle(sequenceName, true);
            }
            
            // ̒l擾
            int current = getNextVal(sequenceName);
    
            if(value != current){
                
                // ̃LbVTCY
                String oldCacheSize = getDescMeta(sequenceName, CACHE_SIZE);
    
                // NOCACHEɕύXiCACHE΁A傫lɕύXƁAG[̉\̂Łj
                if(!NOCACHE_SIZE.equals(oldCacheSize)) {
                    alterCache(sequenceName, NOCACHE_SIZE);
                }
                
                // ύX
                int newIncrement = value - current;
                alterIncrement(sequenceName, newIncrement);

                // VŎ̒lɐݒ肷
                getNextVal(sequenceName);
            }
        } finally {
            // ύXꂽ`𕜌
            undoAlter(sequenceName);
        }
    }
    
    /**
     * w肵V[PX̌X̒`擾
     * <BR><BR>
     * "SYS.USER_SEQUENCES"猟
     * <BR><BR>
     * ŏɎ擾A܂gɃ}bv擾邱
     * 
     * @param sequenceName V[PX
     * @param descColumnName r["USER_SEQUENCES"̃J
     * @return w肵`
     * @throws SQLException
     */
//    @SuppressWarnings("unchecked")
    private String getDescMeta(String sequenceName, String descColumnName) throws SQLException {
    
        // w肵V[PX̒`񂪊ɂΒږ߂
//        Map<String, String> meta = this.sequencesDescMeta.get(sequenceName.toLowerCase());
        Map meta = (Map) this.sequencesDescMeta.get(sequenceName.toLowerCase());
        
        if (meta == null || meta.size()==0) {
            
            // "SYS.USER_SEQUENCES"`
            String sql = "SELECT * FROM SYS.USER_SEQUENCES WHERE SEQUENCE_NAME = UPPER(?)";
            
            //SQL̎s
            DBQueryObject q = new DBQueryObject();
            //p[^ݒ肷
            q.setString(1, sequenceName);
            List/*<Map<String, String>>*/ resultList = 
                        (List/*<Map<String, String>>*/)q.query(sql);
            
            meta = new HashMap/*<String, String>*/();
            // ʂ}bvɕۑ
            if (resultList.size() >= 1) {
                //ʂ΁AKȂ
//                for(Iterator<Map.Entry<String, String>> it = 
//                    resultList.get(0).entrySet().iterator();it.hasNext(); ) {
                for (Iterator it = ((Map) resultList.get(0)).entrySet().
                        iterator(); it.hasNext(); ) {
                    
//                    Map.Entry<String, String> entryValue = it.next();
                    Map.Entry entryValue = (Map.Entry) it.next();
                    
//                    meta.put(entryValue.getKey().toLowerCase(), 
//                            entryValue.getValue());
                    meta.put(((String) entryValue.getKey()).toLowerCase(), 
                            entryValue.getValue());
                }
            } else {
                throw new RuntimeException("w肵V[PX݂Ă܂F" + sequenceName);
            }

            this.sequencesDescMeta.put(sequenceName.toLowerCase(), meta);
        }

        return (String) meta.get(descColumnName.toLowerCase());
    }
    
    /**
     * V[PX̎̒l擾
     * <BR><BR>
     * SQL"select xxx.nextval from dual"s邱
     * 
     * @param sequenceName V[PX
     * @return V[PX̒l
     * @throws SQLException
     */
//    @SuppressWarnings("unchecked")
    private int getNextVal(String sequenceName) throws SQLException {
        BigDecimal nextVal = null;

        DBQueryObject q = new DBQueryObject();
        List/*<Map<String, String>>*/ resultList = 
            (List/*<Map<String, String>>*/)q.query("SELECT "+ sequenceName +".NEXTVAL FROM DUAL");
        
//        String nextValueStr = resultList.get(0).get("NEXTVAL");
        String nextValueStr = (String) ((Map) resultList.get(0)).get("NEXTVAL");
        nextVal = new BigDecimal(nextValueStr);
        
        return toIntValue(nextVal);
    }
    
    /**
     * V[PX̌ݒl擾
     * <BR><BR>
     * SQL"select xxx.currval from dual"s邱
     * <BR><BR>
     * ZbVmꂽCURRVALSELECT<BR>
     * G[邱ƂȂ̂ŁÃ\bh͎ۂ<BR>
     * l̊mFpB
     * 
     * @param sequenceName V[PX
     * @return V[PXݒl
     * @throws SQLException
     */
//    @SuppressWarnings("unchecked")
    private int getCurrVal(String sequenceName) throws SQLException {
        BigDecimal currVal = null;

        DBQueryObject q = new DBQueryObject();
        List/*<Map<String, String>>*/ resultList = 
            (List/*<Map<String, String>>*/)q.query("SELECT " + sequenceName +".CURRVAL FROM DUAL");
        
//        String nextValueStr = resultList.get(0).get("CURRVAL");
        String nextValueStr = (String) ((Map) resultList.get(0)).get("CURRVAL");
        currVal = new BigDecimal(nextValueStr);
        
        return toIntValue(currVal);
    }
    
    /**
     * V[PX̑ݒ肷
     * 
     * @param sequenceName V[PX
     * @param increment l
     * @throws SQLException
     */
    private void alterIncrement(String sequenceName, int increment) throws SQLException {

        DBUpdateObject q = new DBUpdateObject();
        q.setSQL("ALTER SEQUENCE "+ sequenceName +" INCREMENT BY " + increment);
        q.update();
    }
    
    /**
     * V[PX̃LbVTCYݒ肷
     * 
     * @param sequenceName V[PX
     * @param cache LbVTCY
     * @throws SQLException
     */
    private void alterCache(String sequenceName, String cache) throws SQLException {
        DBUpdateObject q = new DBUpdateObject();
        String sql;
        if(NOCACHE_SIZE.equals(cache)) {
            sql = "ALTER SEQUENCE "+ sequenceName +" NOCACHE";
        } else {
            sql = "ALTER SEQUENCE "+ sequenceName + " CACHE "+ cache;
        }
        
        q.setSQL(sql);
        q.update();
    }
    
    /**
     * V[PX̌JԂIvVݒ肷
     * 
     * @param sequenceName V[PX
     * @param isCycle JԂǂ
     * @throws SQLException
     */
    private void alterCycle(String sequenceName, boolean isCycle) throws SQLException {
        DBUpdateObject q = new DBUpdateObject();
        String sql;
        if(isCycle) {
            sql = "ALTER SEQUENCE " + sequenceName +" CYCLE";
        } else {
            sql = "ALTER SEQUENCE " + sequenceName +" NOCYCLE";
        }
        q.setSQL(sql);
        q.update();
    }

    /**
     * ύXꂽ`𕜌
     * 
     * @param sequenceName
     * @throws SQLException
     */
    private void undoAlter(String sequenceName) throws SQLException {
        // ̑
        int oldIncrement = Integer.parseInt(getDescMeta(sequenceName, INCREMENT_BY));
        
        // ̃LbVTCY
        String oldCacheSize = getDescMeta(sequenceName, CACHE_SIZE);
        
        // ̌JԂIvV
        String oldCycle = getDescMeta(sequenceName, OracleDBSequence.CYCLE_FLAG);

        // JԂ𕜌
        if(NOCYCLE_FLAG.equals(oldCycle)) {
            alterCycle(sequenceName, false);
        }
        
        // 𕜌
        alterIncrement(sequenceName, oldIncrement);
        
        // LbV𕜌
        if(!NOCACHE_SIZE.equals(oldCacheSize)) {
            alterCache(sequenceName, oldCacheSize);
        }
    }

    /**
     * V[PX̒lBigDecimal^int^ɕύX
     * <BR><BR>
     * ł̓V[PX̒lInteger̍őŏl͈̔͂ΉĂ
     * 
     * @param number BigDecimal^l
     * @return int^l
     * @throws RuntimeException Integer͈͂𒴂ꍇ
     */
    private static int toIntValue(BigDecimal number) throws RuntimeException {
        
        if(new BigDecimal(String.valueOf(Integer.MAX_VALUE)).compareTo(number) < 0
                || new BigDecimal(String.valueOf(Integer.MIN_VALUE)).compareTo(number) > 0)
            throw new RuntimeException("V[PX̒lInteger̒l͈͂𒴂܂A" +
                    "ΉĂ܂B(" + number + ")");
        return number.intValue();
    }
}
