/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.util.FileUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * <p>ZbVfBNg쐬ANVB</p>
 *
 * <p>
 * T[oTChŐꂽPDFt@CȂǂi[邽߂̈ꎞfBNg
 * iȍ~AZbVfBNgjOI[Uɍ쐬B<br>
 * <br>
 * ̋@\g߂ɂ̓VXeݒvpeBt@Cisystem.propertiesj
 * ɃZbVfBNgx[XpXLqĂKvB<br>
 * <br>
 * <h5>VXeݒvpeBt@Cisystem.propertiesj̐ݒ</h5>
 * <code><pre><strong>session.dir.base=/tmp/sessions</strong></pre></code>
 * ZbVfBNg̍쐬ɂ͈ȉ̓̕@ŗp\łB<br>
 * <br>
 * iPj{@link MakeSessionDirectoryAction}NX̗p<br>
 * OIɐMakeSessionDirectoryActionɑJڂB<br>
 * struts-config.xmlactionvpeBparameterɎw肵ɃtH[hB<br>
 * struts-config.xmlyBean`t@C̐ݒ͉L̂ƂłB
 * <h5>struts-config.xml̐ݒ</h5>
 * <code><pre>
 * &lt;action path="<strong>/makeSessionDir</strong>"
 *     scope="session"
 *     parameter="/foo.jsp"&gt;;
 * &lt;/action&gt;
 * </pre></code>
 * <h5>Bean`t@C̐ݒ</h5>
 * <code><pre>
 * &lt;bean name="<strong>/makeSessionDir</strong>" scope="prototype"
 *   class="<strong>jp.terasoluna.fw.web.struts.actions.MakeSessionDirectoryAction</strong>"&gt;
 * &lt;/bean&gt;
 * </pre></code>
 *
 * iQjANVNXŒڃZbVfBNg쐬<br>
 * MakeSessionDirectoryActionȊÕANVł́A[UOC
 * {@link javax.servlet.http.HttpSession}擾\ȏꏊ
 * FileUtil#makeSessionDirectory(String sessionId)ĂяoKvB<br>
 * <br>
 * <br>
 * ZbVfBNg̍폜͈ȉ̕@ŗp\łB<br>
 * <br>
 * iPj{@link javax.servlet.http.HttpSessionListener}NX̗p<br>
 * fvCgfBXNv^iweb.xmlj
 * HttpSessionListenerNXXiƂēo^A
 * ZbVjꂽƂZbVfBNg폜鏈
 * iFileUtil#removeSessionDirectory(String sessionId)j
 * XiɎB<br>
 * web.xml̐ݒ͉L̂ƂłB<br>
 * <h5>fvCgfBXNv^iweb.xmlj̐ݒ</h5>
 * <code><pre>
 * &lt;web-app&gt;
 *   EEE
 *   &lt;listener&gt;
 *     &lt;listener-class&gt;
 *       <strong>jp.terasoluna.fw.web.MyHttpSessionListener</strong>
 *     &lt;/listener-class&gt;
 *   &lt;/listener&gt;
 * &lt;/web-app&gt;
 * </pre></code>
 * </p>
 *
 */
public class MakeSessionDirectoryAction extends ActionEx {

    /**
     * ONXB
     */
    private static Log log =
        LogFactory.getLog(MakeSessionDirectoryAction.class);

    /**
     * ZbV擾sG[R[hB
     */
    private static final String SESSION_NOT_FOUND_ERROR =
        "error.session.not.found";
    
    /**
     * G[y[Wi404jJڎsG[R[hB
     */
    private static final String FORWARD_ERRORPAGE_ERROR = 
        "error.forward.errorpage";

    /**
     * <p>
     *  ZbVfBNg𐶐B<br>
     *  ZbV擾łꍇAZbVfBNg쐬
     *  p[^ɐݒ肳ꂽJڐANVtH[hɃZbgĕԂB<br>
     *  p[^ݒ肳ĂȂꍇA(404)G[ԂB<br>
     *  ZbV擾łȂꍇAVXeONB
     * </p>
     * @param mapping ANV}bsO
     * @param form ANVtH[
     * @param req HTTPNGXg
     * @param res HTTPX|X
     * @return Jڐ̃ANVtH[hB
     */
    @Override
    public ActionForward doExecute(ActionMapping mapping, ActionForm form,
            HttpServletRequest req, HttpServletResponse res) {

        if (log.isDebugEnabled()) {
            log.debug("doExecute() called.");
        }

        // p̃ZbVȂON
        HttpSession session = req.getSession(false);
        if (session == null) {
            log.error("HttpSession is not available.");
            throw new SystemException(null, SESSION_NOT_FOUND_ERROR);
        }

        // ZbVID擾AZbVfBNg𐶐B
        FileUtil.makeSessionDirectory(session.getId());

        // p[^itH[hj擾
        String path = mapping.getParameter();

        if (path == null) {
            // p[^ݒ肳ĂȂꍇA(404)G[ԋp
            try {
                res.sendError(HttpServletResponse.SC_NOT_FOUND);
            } catch (IOException e) {
                log.error("Error page(404) forwarding failed.");
                throw new SystemException(e, FORWARD_ERRORPAGE_ERROR);
            }
            return null;
        }

        // ̉ʑJ
        ActionForward retVal = new ActionForward(path);
        return retVal;
    }
}
