/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2008-2011 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: core_support.S 2202 2011-07-26 13:27:11Z ertl-honda $
 */

/*
 *  vZbTˑW[ AZuꕔiARM-Mpj
 */

#define TOPPERS_MACRO_ONLY
#define UINT_C(val)		(val)		/* uint_t^̒萔}N */
#define ULONG_C(val)	(val)		/* ulong_t^̒萔}N */
#define CAST(type, val)	(val)		/* ^LXgs}N */

#include "kernel_impl.h"
#include "arm_m.h"
#include "offset.h"


/*
 *  ^XNfBXpb`
 */
	.text
	.syntax unified
	.code 16
	.global dispatch
	.type dispatch, function
dispatch:
	/*
	 *
	 *  ̃[`́C^XNReLXgECPUbNԁEfBpb`
	 *  Eif́jݗDx}XNSJԂŌĂяoD
	 */
	stmfd sp!,{r4-r11,lr}         /* WX^̕ۑ */
	ldr   r0, =p_runtsk           /* p_runtskǂݍ */
	ldr   r1, [r0]
	str   sp, [r1,#TCB_sp]        /* ^XNX^bNۑ */
	ldr   lr, =dispatch_r         /* sĊJԒnۑ */
	str   lr, [r1,#TCB_pc]        
	b     dispatcher

	.text
	.syntax unified
	.code 16
	.type dispatch_r, function
dispatch_r:
	ldmfd sp!,{r4 - r11,lr}       /* WX^̕A */
	/*
	 * ^XNO[`̋N
	 * dispatcherĂяo邽߁CTCB̃AhXr1ɓĂ
	 */
	ldrb  r0,[r1,#TCB_enatex]
	tst   r0,#TCB_enatex_mask
	beq   dispatch_r_1            /* enatex  false Ȃ烊^[ */
	ldr   r0,[r1,#TCB_texptn]     /* texptn  0 Ȃ烊^[     */
	tst   r0,r0
	beq   dispatch_r_1            
	ldr   r1, =ipmflg             /* ipmflg false Ȃ烊^[  */
	ldr   r0, [r1]
	tst   r0,r0
	bne   call_texrtn             /* ^XNO[`̌Ăяo */
dispatch_r_1:                     /* ^XNւcall_textn߂ */
	mov   pc,lr


/*
 *  CPUOGg
 *
 *  ݃GgƏ̓e͓CO̎ނقȂ邽߁C
 *  ĂD
 */
	.align 2
	.syntax unified
	.code 16
	.global core_exc_entry
	.type core_exc_entry, function
core_exc_entry:
	/*
	 *  O/݂ƁCɃANeBuȃX^bNɃXN
	 *  b`WX^ۑD
	 *  ̓eɉāCCPUOnhւ̏ƂāCbasepri ̒lƁC
	 *  EXC_RETURN̏ĕۑDbasepri̒ĺCCPUO
	 *  ^[ɊݗDx}XN̒lɖ߂߂ɂpD
	 *
	 *   -----------
	 *  | EXC_RETURN|  
	 *   -----------
	 *  |  basepri  |  
	 *   -----------
	 *  |    R0     |  
	 *   -----------
	 *  |    R1     |
	 *   -----------
	 *  |    R2     |
	 *   -----------
	 *  |    R3     |
	 *   -----------
	 *  |    R12    |
	 *   -----------
	 *  |    LR     |
	 *   -----------
	 *  |    PC     |
	 *   -----------
	 *  |   xPSR    |
	 *   -----------
	 *
	 */

	/*
	 *  ݔ̊ݗDx}XNX^bNɕۑ邽ߎ擾
	 */
	mrs   r2, basepri             /* baepri̒l擾 */

	/*
	 *  J[lǗO̗O`FbN
	 *  J[l̃NeBJZNV̎sCS݃bNԁC
	 *  CPUbNԁCJ[lǗO̊݃nhŝꂩ
	 *  CPUOCJ[lǗOCPUOƌĂ
	 *  CPUbNԂbasepriIIPM_LOCKŔfD
	 *  S݃bNԂFAULTMASK'1'̏ꍇ
	 */
	cmp   r2, #IIPM_LOCK              /* CPUbNԂȂJ[lǗOO */
	beq   core_nonkernel_exc_entry
	mrs   r2, FAULTMASK               /* S݃bNԂȂJ[lǗOO */
	cbnz  r2, core_nonkernel_exc_entry

	/*
	 * X^bNύXKv邩`FbN
	 * EXC_RETURNiݎLRɐݒ肳lj`FbNāCO
	 * ANeBuȃX^bN肷邱Ƃőd݂肷D
	 */
	tst   lr, #EXC_RETURN_PSP    /* ݌MSPȂ瑽d */
	beq   core_exc_entry_1       /* d݂Ȃcore_exc_entry_1 */
	mrs   r0, psp                /* iڂ݂̊̏ꍇPSP */
	stmfd r0!,{r2}               /* ݔ̊ݗDx}XNς */
	stmfd r0!,{lr}               /* EXC_RETURN ς             */
	msr   psp, r0                /* CPUOnhւ̈ƂȂ */
	push  {lr}                   /* MSPɂEXC_RETURN ς    */ 
	b     core_exc_entry_2
core_exc_entry_1:                /* d݂̏ꍇ */
	push  {r2}                   /* ݔ̊ݗDx}XNς */
	push  {lr}                   /* EXC_RETURN ς             */ 
	mov   r0, sp                 /* CPUOnhւ̈ƂȂ */

	/*
	 *  ʏ
	 */
core_exc_entry_2:                     
	mrs   r3, ipsr               /* nhAhX擾 */
	ldr   r1, =_kernel_exc_tbl
	ldr   r2, [r1, r3, lsl #2]

#ifdef LOG_EXC_ENTER
	push  {r0,r2,r3}
	mov   r0, r3                 /* Oԍp[^  */
	bl    log_exc_enter          /* log_exc_enterĂяo */
	pop   {r0,r2,r3}
	push  {r3}                   /* OԍX^bN    */
#endif /* LOG_EXC_ENTER */

	/*
	 *  CPUOnȟĂяo
	 */
	blx   r2

#ifdef LOG_EXC_ENTER
	pop   {r0}                   /* Oԍ        */
	bl    log_exc_leave          /* log_exc_leaveĂяo */
#endif /* LOG_EXC_ENTER */

	b     ret_exc

/*
 *  J[lǗOCPUȌo
 */
core_nonkernel_exc_entry:
	tst   lr, #EXC_RETURN_PSP    /* ݌MSPȂ瑽d */
	beq   core_nonkernel_exc_entry_1  /* d݂Ȃ */
	mrs   r0, psp                /* iڂ݂̊̏ꍇPSP */
	stmfd r0!,{r2}               /* ݔ̊ݗDx}XNς */
	stmfd r0!,{lr}               /* EXC_RETURN ς             */
	msr   psp, r0                /* CPUOnhւ̈ƂȂ */
	push  {lr}                   /* MSPɂEXC_RETURN ς    */ 
	b     core_nonkernel_exc_entry_2
core_nonkernel_exc_entry_1:      /* d݂̏ꍇ */
	push  {r2}                   /* ݔ̊ݗDx}XNς */
	push  {lr}                   /* EXC_RETURN ς             */ 
	mov   r0, sp                 /* CPUOnhւ̈ƂȂ */

core_nonkernel_exc_entry_2:
	mrs   r3, ipsr               /* CPUOnh̃AhX擾 */
	ldr   r1, =_kernel_exc_tbl
	ldr   r2, [r1, r3, lsl #2]

	/*
	 *  CPUOnȟĂяo
	 */
	blx   r2

	/*
	 *  ݃bNԂƂD
	 */
	cpsid f

	/*
	 *  ߂̃ReLXg̔
	 * 
	 *  ݃nhsLRɃZbgEXC_RETURN`FbNāC߂
	 *  MSPgĂ΁Cݐ悪^XNReLXgƔ肷D
	 */
	pop   {r3}                     /* lrX^bN擾         */
	tst   r3, #EXC_RETURN_PSP      /* ߂悪PSPȂ              */
	bne   core_nonkernel_ret_exc_1
	pop   {r1}                     /* ̊ݗDx}XN(basepri) */
	b     core_nonkernel_ret_exc_2 /* ̒lMSP擾 */

core_nonkernel_ret_exc_1:
	/*
	 *  PSPォEXC_RETURN폜
	 */
	mrs   r2, psp
	add   r2, r2, #4
	/*
	 *  ̊ݗDx}XN(basepri)̒lPSP擾
	 */
	ldmfd r2!, {r1} 
	msr   psp, r2

core_nonkernel_ret_exc_2:
	msr   basepri, r1             /* ݗDx}XNݑOɏԂ */
	bx    r3                      /* ^[ */

/*
 *  ݃Gg
 */
	.align 2
	.syntax unified
	.code 16
	.global core_int_entry
	.type core_int_entry, function
core_int_entry:
	/*
	 *  ݔ̊ݗDx}XNX^bNɕۑ邽ߎ擾
	 */
	mrs   r2, basepri             /* baepri̒l擾 */

	/*
	 * d݂`FbN
	 * EXC_RETURNiݎLRɐݒ肳lj`FbNāCO
	 * ANeBuȃX^bN肷邱Ƃőd݂肷D
	 */
	tst   lr, #EXC_RETURN_PSP    /* ݌MSPȂ瑽d */
	beq   core_int_entry_1       /* d݂Ȃcore_int_entry_1 */
	mrs   r0, psp                /* iڂ݂̊̏ꍇPSP */
	stmfd r0!,{r2}               /* ݔ̊ݗDx}XNς */
	stmfd r0!,{lr}               /* EXC_RETURN ς             */
	msr   psp, r0                /* CPUOnhւ̈ƂȂ */
	push  {lr}                   /* MSPɂEXC_RETURN ς    */ 
	b     core_int_entry_2
core_int_entry_1:                /* d݂̏ꍇ */
	push  {r2}                   /* ݔ̊ݗDx}XNς */
	push  {lr}                   /* EXC_RETURN ς             */ 
	mov   r0, sp                 /* `݂̊ꍇ̏Ƃ */

	/*
	 *  ʏ
	 */
core_int_entry_2:                     
	mrs   r3, ipsr               /* nhAhX擾 */
	ldr   r1, =_kernel_exc_tbl
	ldr   r2, [r1, r3, lsl #2]

	/*
	 *  basepri̐ݒ
	 *  NVICDx}XNIɐݒ肳邽ߗDx}XN̓_ł͕Kv
	 *  Cx_get_ipm()basepriQƂ邽߁CbasepriXVD
	 */
	ldr   r1, =_kernel_int_iipm_tbl
	ldr   lr, [r1, r3, lsl #2]
	msr   basepri, lr

#ifdef LOG_INH_ENTER
	push  {r0,r2,r3}
	mov   r0, r3                 /* Oԍp[^  */
	bl    log_inh_enter          /* log_exc_enterĂяo */
	pop   {r0,r2,r3}
	push  {r3}                   /* OԍX^bN    */
#endif /* LOG_EXC_ENTER */

	/*
	 *  ݃nȟĂяo
	 */
	blx   r2

#ifdef LOG_INH_LEAVE
	pop   {r0}                   /* Oԍ        */
	bl    log_exc_leave          /* log_exc_leaveĂяo */
#endif /* LOG_INH_LEAVE */



/*
 *  /Oo
 *
 *  ret_exc/ret_int́CCPUO/݃nh߂Ɏs
 *  [`łD
 */
ret_exc:
ret_int:
	/*
	 *  ݃bNԂƂD̎_ł́CCPUbNԂɂ͂ȂȂ
	 * ibaseprilock_flagsaved_iipm͍XVȂjD
	 *
	 *  ݃bNԂƂ̂́C߂̃ReLXg̃`FbNƁC
	 *  ߂悪^XNReLXgłꍇ̃^[Ag~bN
	 *  ɍs߂łDbsepriCPUbN̒lɂ邱ƂłAg~b
	 *  Nȃ`FbNƕA͉\ł邪C݂烊^[ĂC
	 *  basepri ̐ݒe͌ɖ߂Ȃ߁Cgp邱ƂłȂD 
	 *  CFAULTMASḰC݂̃^[ɂāC'0'ɃN
	 *  AD
	 */
	cpsid f

	/*
	 *  ߂̃ReLXg̔
	 * 
	 *  ݃nhsLRɃZbgEXC_RETURN`FbNāC߂
	 *  MSPgĂ΁Cݐ悪^XNReLXgƔ肷D
	 */
	pop   {r3}                     /* lrX^bN擾         */
	tst   r3, #EXC_RETURN_PSP      /* ߂悪PSPȂ ret_int_1  */
	bne   ret_int_1
	pop   {r1}                     /* ̊ݗDx}XN(basepri)r1 */
	b     ret_int_2                /* ̒lMSP擾 */

	/*
	 *  iڂ݂̊̏o
	 */
ret_int_1:
	/*
	 *  PSPォCEXC_RETURN(r0)ƌ̊ݗDx}XN(basepri)(r1)
	 *  擾
	 */
	mrs   r2, psp
	ldmfd r2!, {r0,r1} 
	msr   psp, r2

	/*
	 *  reqflg`FbN
	 * 
	 *  J[lǗ݂̊͋֎~ԂŎsKv邽߁C
	 *  FAULTMASK'1'ɂԂŎsD
	 *  reqflg`FbNOɊ݂֎~̂́Creqflg`FbN
	 *  Ɋ݃nhNC̒ŃfBXpb`v
	 *  ꂽꍇɁCɃfBXpb`ȂƂ肪邽
	 *  łD
	 */
	ldr   r0, =reqflg             /* reqflgfalseȂ炻̂܂ܖ߂ */
	ldr   r2, [r0]
	cbnz  r2, ret_int_3           /* trueȂret_int_3           */

ret_int_2:
	/*
	 *  ɂ͊݃bNԁiFAULTMASKZbgjꂽԂŗD
	 *  Thread[h̃^[ɂ莩IɊ݃bNԂɂȂD
	 *  ݗDx}XN͊ݑOɏԂɖ߂D
	 */ 
	msr   basepri, r1             /* ݗDx}XNݑOɏԂ */
	bx    r3                      /* ^[ */

ret_int_3:
	/*
	 *  ł́C߂悪^XNłCPSPɃXNb`WX^Ɗ
	 *  ݗDx}XN(basepri)ۑꂽԂɂȂĂD܂C
	 *  vZbT́CHandler[hE݃bNԂƂȂĂD
	 *  ܂Cr0ɂ́Creqflg̃AhXCr3ɂ͊ݎtlr̒l
	 *  ĂD
	 */
	/*
	 *  ^XNOnhfBXpb`ۂThread[h֑Jڂ
	 *  _~[̃X^bNt[쐬āCbx߂Handler[h烊
	 *  ^[D܂CxfBXpb`ꍇCĂъ荞񂾃^X
	 *  Nɖ߂ۂɂ́Csvc߂ŁCsvc_handlerĂяoD
	 *  X^bNt[́CConfigureation and Control Register(CCR)
	 *  STKALIGN'1'̏ꍇ́C8byteEɃACD
	 *  Ql : DDI0403B_arm_architecture_v7m_reference_manual(P.220)
	 *  ̂߁C̎_̃X^bN݂͊Oɍ쐬ꂽ
	 *  X^bNt[C8byteẼTCYɂĂƁCsvc_handler
	 *  ŃX^bNt[̃ACg̗L̊mFȗłD
	 *  CVXeŃCICCRSTKALIGN̐ݒύX̂
	 *  ֎~ƂD
	 *  ̎_͕W̃X^bNt[́C݁EOƓł
	 *  邽߁C^XNX^bN(PSP)8byteEɂȂĂD
	 */
	mov   r1, #0                   /* reqflgfalse */
	str   r1, [r0]

	/*
	 *  CPUbNԂɈڍsD
	 *
	 *  J[l̊Ǘ݂̊֎~悤basepriݒ肵C
	 *  lock_flag  saved_iipm XVDsaved_iipḿC߂̊
	 *  Dx}XNi̓\jɐݒ肷D
	 *  ̎_CPUbNԂƂ̂́Cdispatcher֕򂷂鎞ƁC
	 *  call_texrtnĂяoɁCCPUbNԂɂȂĂKv
	 *  ߂łD
	 *  ȂC̏̌CThread[hւ̈ڍssȂ߁C
	 *  bN(FAULTMASK"1")͕ێD
	 */
	ldr   r1, =IIPM_LOCK          /* CPUbN */ 
	msr   basepri, r1          
	mov   r1, #0x01               /* lock_flag  true */
	ldr   r0, =lock_flag          
	str   r1, [r0]

	/*
	 *  ݗDx}XNCSԁiTIPM_ENAALLjɐݒ肷
	 *  łCPUbNԂȂ̂ŁCsaved_iipmIIPM_ENAALLƂD
	 */
	ldr   r1, =IIPM_ENAALL
	ldr   r0, =saved_iipm
	str   r1, [r0]

	/*
	 *  Thread[hֈڍsD
	 *
	 *  dispatchercall_texrnĂяoꍇ́CThread[hłK
	 *  v邽߁CPSPX^bNɃ_~[̗Ot[uāC
	 *  [IɊ݃nh烊^[D
	 *  ^[ƓFAULTMASKIɃNACJ[lǗO
	 *  ݂D
	 */
	ldr   r0, =ret_int_4          /* PC   */
	ldr   r1, =EPSR_T             /* xPSR(Trbg'1'łKv) */
	mrs   r2, psp
	stmfd r2!, {r0-r1}            /* _~[t[X^bNɐς   */
	sub   r2, #(EXC_FRAME_SIZE - (4*2)) /* r0-r3,r12,lr̓e͐ݒ肷KvȂ */
	msr   psp,r2                  
	bx    r3                      /* Thread[hֈڍs */
    
ret_int_4:
	/*
	 *  L̏ɂCThread[hŎsD
	 *  dspflgfalsełꍇƁCp_runtskp_schedtskꍇɂ́C
	 *  fBXpb`sȂD̃`FbNKvȂ̂́C^XNO
	 *  [`̌ďoKvȏꍇɁCfBXpb`KvȂĂC
	 *  reqflgtrueɂ邽߂łD
	 */
	ldr   r0, =p_runtsk       /* fBXpb`sȂꍇłCr1p_runtsk ̒l(TCB) */
	ldr   r1, [r0]            /* ĂKv̂ŁCɓǂݍ */
	ldr   r0, =dspflg         
	ldr   r2, [r0]
	cbz   r2, ret_int_r_1     /* dspflgfalseȂret_int_r_1 */
	ldr   r0, =p_schedtsk     
	ldr   r2, [r0]
	cmp   r1, r2              /* p_runtskp_schedtskȂ */
	beq   ret_int_r_1         /*                  ret_int_r_1 */
	stmfd sp!, {r4-r11}       /* c̃WX^ۑ */
	str   sp, [r1,#TCB_sp]    /* ^XNX^bNۑ */
	ldr   lr, =ret_int_r      /* sĊJԒnۑ   */
	str   lr, [r1,#TCB_pc]
	b     dispatcher          /* fBXpb` */

/*
 * ݂ɂvGvgꂽ^XNւ̃^[
 *
 * Thread[hŁCfBXpb`⊄݂̏oĂяoD
 * ݂ɂvGvgꂽ^XNփ^[ɂ́C
 * Handler[hɈڍsCPC0xfffffffdă^[Kv
 * D̂߁CSVCɂCSVCnhĂяoCHandler[
 * hֈڍsD
 */
	.text
	.syntax unified
	.code 16
	.type ret_int_r, function
ret_int_r:
	pop {r4-r11}                  /* WX^̕A */
ret_int_r_1:
	/*
	 *  enatextrueŁCtexptn0łȂ΁C^XNO[`
	 *  ĂяoD
	 *  dispatcherĂяo邽߁CTCB̃AhXr1ɓĂ
	 */
	ldrb  r0, [r1,#TCB_enatex]
	tst   r0, #TCB_enatex_mask
	beq   ret_int_r_2           /* enatex  false Ȃ ret_int_r_2 */
	ldr   r0, [r1,#TCB_texptn]  /* texptn  0 Ȃ烊^[     */
	cbz   r0, ret_int_r_2
	ldr   r1, =ipmflg             /* ipmflg false Ȃ烊^[  */
	ldr   r0, [r1]
	cbz   r0, ret_int_r_2
	bl    call_texrtn           /* ^XNO[`̌Ăяo */
ret_int_r_2:
	svc   0                     /* SVČĂяo */

/*
 *  SVCnh
 */
	.text
	.syntax unified
	.thumb
	.thumb_func
	.global svc_handler
	.type svc_handler, function
svc_handler:
	/*
	 *  ݏ̃^[ɂCCPUbNԂɈڍs
	 *  D
	 */
	cpsid f                       /* ݃bNԂ */
	mrs   r0, psp
	add   r0, #EXC_FRAME_SIZE     /* X^bN̂Ă   */
	msr   psp, r0
	mov   r0, #0
	ldr   r1, =lock_flag          /* CPUbNԂ */
	str   r0, [r1]
	ldr   r1, =IIPM_ENAALL        /* ݗDx}XNSԂɐݒ */
	msr   basepri, r1             
	bx    lr                      /* ^[     */

/*
 *  fBXpb`̓Jn
 */
	.align	2
	.thumb
	.thumb_func
	.globl start_dispatch
start_dispatch:
	/*
	 *  ̃[`́CJ[lNɁCׂĂ݂̊֎~
	 * i݃bNԂƓjŌĂяoD܂C݃[hi
	 *  ^XNReLXgƓjŌĂяo邱Ƃz肵ĂD
	 *
	 *  core_initializeŁClock_flagtrueɁCsaved_iipmIIPM_ENAALL
	 *  Ă邽߁CJ[lǗO݂̊邱ƂŁC
	 *  CPUbNԁEif́jݗDx}XNSԂɂȂD
	 *  ܂Ctask_initializedisdspfalseɏĂ邽߁CfB
	 *  Xpb`ԂɂȂĂD
	 */
	ldr   r0,=istkpt              /* MSP   */
	ldr   r1,[r0]                 /* start_dispatchĂяoɌĂяop */
	msr   msp, r1                 /* gpĂ邽ߏ             */
	ldr   r1, =IIPM_LOCK          /* J[lǗ݂̊֎~ */
	msr   basepri, r1 
	cpsie f                       /* J[lǗO݂̊ */
	mov   r0, #CONTROL_PSP        /* PSPL  */
	msr   control, r0
	isb                           /* control ̑ɕKv */

/*
 *  ݂̃ReLXĝĂăfBXpb`
 */
	.align	2
	.thumb
	.thumb_func
    .globl exit_and_dispatch
exit_and_dispatch:
	/* fBXpb`{́idispatcherj */ 


/*
 *  fBXpb`{
 */
dispatcher:
	/*
	 *  ̃[`́C^XNReLXgECPUbNԁEfBXpb`
	 *  ԁEif́jݗDx}XNSԂŌĂяo
	 *  D
	 *
	 *  Ȃ킿CThread[hElock_flagtrueEdisdspfalseEdspflg
	 *  trueEsaved_iipmIIPM_ENAALLƂȂĂDsĊJԒnւ
	 *  ̏Ԃ̂܂ܕ򂷂D
	 */
#ifdef LOG_DSP_ENTER
	ldr   r1, =p_runtsk     /* p_runtskp[^ */
	ldr   r0, [r1]        
	bl    log_dsp_enter
#endif /* LOG_DSP_ENTER */
dispatcher_0:
	ldr   r0, =p_schedtsk   /* p_schedtskp_runtsk */
	ldr   r1, [r0]
	ldr   r2, =p_runtsk   
	str   r1, [r2]        
	cbz   r1, dispatcher_1  /* p_runtskNULLȂdispatcher_1 */           
	ldr   sp, [r1,#TCB_sp]  /* ^XNX^bN𕜋A */
#ifdef LOG_DSP_LEAVE
	mov   r0, r1            /* p_runtskp[^ */
	mov   r4, r1            /* r1̓XNb`WX^Ȃ̂ŕۑ */
	bl    log_dsp_leave
	mov   r1, r4
#endif /* LOG_DSP_LEAVE */
	ldr   pc, [r1,#TCB_pc]  /* sĊJԒn𕜋A   */    
dispatcher_1:
	/*
	 * CPUbNԂ̉ƁC^XNReLXgsԂւ
	 * 
	 */
	mov   r0, #CONTROL_MSP  /* MSPL  */
	msr   control, r0       
	isb                     /* control ̑ɕKv */
	ldr   r2, =reqflg       /* r2 <- reqflg */
	ldr   r1, =IIPM_LOCK    /* ݃bNԂ̊ݗDx}XN̒l */
	mov   r0, #0
	ldr   r4, =lock_flag    /* CPUbNԂ */
	str   r0, [r4]
dispatcher_2:
	/*
	 *  ݂C^XNReLXgsԂƂ݂҂D
	 *
	 *  Ŕ^XNReLXgsԂɐ؂芷̂́CŔ
	 *  銄ݏɂǂ̃X^bNgƂ̉ƁC
	 *  nhł̃^XNfBXpb`̖h~Ƃ2̈ӖD
	 *
	 *  vZbTݑ҂Ɉڍs鏈ƁC݋Ƃ́Cs
	 *  ɍsȂKvD
	 *  sɍsȂȂꍇC݂Ɋ
	 *  ݂C̒Ń^XNs\ԂɂȂƁCsׂ^X
	 *  Nɂ炸vZbTݑ҂ɂȂĂ܂D
	 *  ARM-Mł́CPRIMASKZbgԂWFIĂяoƂŎłD
	 *  ̏ԂŊ݂ƁC݂͎sꂸCWFI烊^[
	 *  邱ƂɂȂ̂ŁCU݂Ċ݃nhsD
	 *
	 *  ݑ҂̊Ԃ́Cp_runtskNULLi0jɐݒ肵Ȃ΂Ȃ
	 *  D̂悤ɐݒ肵ȂƁC݃nhiget_tidĂяo
	 *  ۂ̓삪dlɍvȂȂD
	 *
	 */
#ifdef TOPPERS_CUSTOM_IDLE
	toppers_asm_custom_idle
#else
	cpsid i               /* PRIMASK Zbg */
	msr   basepri, r0     /* S݋ */ 
	wfi
	cpsie i               /* PRIMASK NAi݂󂯕tj */
	msr   basepri, r1     /* CPUbNԂ */ 
#endif /* TOPPERS_CUSTOM_IDLE */

	ldr   r6, [r2]        /* reqflgfalseȂdispatcher_2 */
	cmp   r6, #0
	beq   dispatcher_2
	str   r0, [r2]        /* reqflgfalse */

	/*
	 *  CPUbNԂɖ߂Dݑ҂̊ԂɎs݃nhɂ
	 *  Csaved_iipm\邽߁C̒lɖ߂K
	 *  vDdispatchers鎞́Csaved_iipmIIPM_ENAALL
	 *  ƂȂĂ邽߁Cłsaved_iipmIIPM_ENAALLi0jɖ߂
	 *  ΂悢D
	 */
	mov   r0, #CONTROL_PSP  /* PSPL  */ 
	msr   control, r0      
	isb                     /* control ̑ɕKv */
	mov   r2, #1            /* lock_flagtrue */
	ldr   r4, =lock_flag  
	str   r2, [r4]
	ldr   r4, =saved_iipm   /* saved_iipm 0 */
	mov   r0, #0
	str   r0, [r4]
	b     dispatcher_0


/*
 *  J[l̏Ǐďo
 *
 *  X^bN^XNReLXgpɐ؂ւD
 *  
 */
	.text
	.syntax unified
	.code 16
	.globl call_exit_kernel
	.type call_exit_kernel, function
call_exit_kernel:
	mov   r0, #CONTROL_MSP
	msr   control, r0       /* MSPL  */
	isb                     /* control ̑ɕKv */
	b     exit_kernel       /* J[l̏IĂ */


/*
 *  ^XNN
 *
 *  dispatcherĂяo邽߁CTCB̃AhXr1ɓĂ
 *
 */ 
	.text
	.syntax unified
	.code 16
	.global start_r
	.type start_r, function
start_r:
	mov   r0, #0
	ldr   r4, =lock_flag                    /* CPUbNԂ */
	str   r0, [r4]
	msr   basepri, r0                       /* ݋   */
	ldr   lr, =ext_tsk                      /* ߂Ԓnݒ */
	ldr   r2, [r1, #TCB_p_tinib]            /* p_runtsk->p_tinibr2  */
	ldr   r0, [r2, #TINIB_exinf]            /* exinfWX^r0  */
	ldr   r1, [r2, #TINIB_task]             /* ^XNNԒnɃWv */
	mov   pc, r1 

/*
 *  ԑ҂
 */
	.text
	.syntax unified
	.code 16
	.globl sil_dly_nse
	.type sil_dly_nse, function
sil_dly_nse:
	sub   r0, r0, #SIL_DLY_TIM1
	cmp   r0, #0
	bgt   sil_dly_nse1
	mov   pc, lr
sil_dly_nse1:
	sub   r0, r0, #SIL_DLY_TIM2
	cmp   r0, #0
	bgt   sil_dly_nse1
	mov   pc, lr
