/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel  
 * 
 *  Copyright (C) 2000-2002 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  Copyright (C) 2005 by Freelines CO.,Ltd
 *
 *  Copyright (C) 2010 by Meika Sugimoto
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *	vZbTˑW[iV850pj
 */

#include "kernel_impl.h"
#include "check.h"
#include "task.h"

/*
 *  vZbTˑŗpϐ
 */
uint8_t intnest;
uint8_t current_intpri;
bool_t lock_flag;
uint16_t saved_imr[IMR_SIZE];
uint16_t disint_table[IMR_SIZE];

/*
 *  vZbTˑ̏
 */
void
prc_initialize(void)
{
	int_t i;
	
	/* ϐ̏ */
	intnest = 0u;
	current_intpri = 0u;
	lock_flag = true;
	
	for(i = 0 ; i < IMR_SIZE ; i++)
	{
		disint_table[i] = 0x0000;
	}
}

/*
 *  vZbTˑ̏I
 */
void
prc_terminate(void)
{
	extern void software_term_hook(void);
	software_term_hook();
}

/* ISPRe[u̎Q(prc.tfɂĐ) */
extern const uint16_t imr_table[][IMR_SIZE];

/*
 *	݂̊ݗDx}XN(\)̐ݒ
 *
 *	CC֐łȂ̂́CAZugp邽߂łD
 */
void
set_intpri(uint8_t intpri)
{
	uint_least8_t i;
	
	/* ISPRɏ */
	for(i = 0 ; i < IMR_SIZE ; i++)
	{
		sil_wrh_mem((uint16_t *)((uintptr_t)IMR0 + (i * 2)) , 
			imr_table[intpri][i] | disint_table[i]);
	}
}


/*
 *  ݗvC̐ݒ
 */

struct _int_pol_table
{
	intptr_t pol_setting0;
	intptr_t pol_setting1;
	uint8_t bitpos;
};

struct _int_pol_table const int_pol_table[] = 
{
	/* ^ԂɂĈႤ\邽߁C}N` */
	INT_POLREG_TABLE
};

void
x_config_int(INTNO intno, ATR intatr, PRI intpri)
{
	//assert(VALID_INTNO_CFGINT(intno));
	//assert(TMIN_INTPRI <= intpri && intpri <= TMAX_INTPRI);
	uint32_t intreg_addr = INTREG_ADDRESS(intno);
	
	/*
	 *  ݂̃}XN
	 *
	 *  ݂󂯕t܂܁CxgK^GbWgK̐ݒC
	 *  ݗDx̐ݒŝ͊댯Ȃ߁Cݑɂ炸C
	 *  U}XND
	 */
	(void)x_disable_int(intno);
	
	if(((7u <= (intno)) && ((intno) <= 15u)) || (intno == 1u))
	{	
		/* INT[q̏ꍇ͊݌m@ݒ肷 */
		if((intatr & TA_POSEDGE) != 0U)
		{
			/* オGbW , pol_setting00ɁCpol_setting11 */
			sil_wrb_mem((uint8_t *)int_pol_table[intno].pol_setting0 , 
					((sil_reb_mem((uint8_t *)int_pol_table[intno].pol_setting0))
						& ~(1U << int_pol_table[intno].bitpos)));
			sil_wrb_mem((uint8_t *)int_pol_table[intno].pol_setting1 , 
					((sil_reb_mem((uint8_t *)int_pol_table[intno].pol_setting1))
						| (1U << int_pol_table[intno].bitpos)));
		}
		else if((intatr & TA_NEGEDGE) != 0U)
		{
			/* GbW , pol_setting01ɁCpol_setting10 */
			sil_wrb_mem((uint8_t *)int_pol_table[intno].pol_setting0 , 
					((sil_reb_mem((uint8_t *)int_pol_table[intno].pol_setting0))
						| (1U << int_pol_table[intno].bitpos)));
			sil_wrb_mem((uint8_t *)int_pol_table[intno].pol_setting1 , 
					((sil_reb_mem((uint8_t *)int_pol_table[intno].pol_setting1))
						& ~(1U << int_pol_table[intno].bitpos)));
		}
		else if((intatr & TA_BOTHEDGE) != 0U)
		{
			/* GbW , pol_setting01ɁCpol_setting11 */
			sil_wrb_mem((uint8_t *)int_pol_table[intno].pol_setting0 , 
					((sil_reb_mem((uint8_t *)int_pol_table[intno].pol_setting0))
						| (1U << int_pol_table[intno].bitpos)));
			sil_wrb_mem((uint8_t *)int_pol_table[intno].pol_setting1 , 
					((sil_reb_mem((uint8_t *)int_pol_table[intno].pol_setting1))
						| (1U << int_pol_table[intno].bitpos)));
		}
	}
	
	/*
	 *  ݗDx̐ݒ
	 */
	sil_wrb_mem((uint8_t *)intreg_addr ,
		((sil_reb_mem((uint8_t *)intreg_addr) & ~0x7)
			| (7u - INT_IPM((volatile PRI)intpri))));
	
	/*
	 *  ݂̃}XN
 	 */
	if ((intatr & TA_ENAINT) != 0U) {
		(void)x_enable_int(intno);
	}
}

/*
 * CPUOnh̏
 * @}NɂAasp/kernel/exception.hŃvg^Cv錾
 * @Ă邽߁A֐ƂĒ`Ȃ΂ȂȂB
 */
void
initialize_exception(void)
{
	/* Ȃ */
}


#ifndef OMIT_DEFAULT_EXC_HANDLER
/*
 *  o^ĂȂOƌĂяo
 */
void
default_exc_handler(void *p_excinf)
{
    target_exit();
}
#endif /* OMIT_DEFAULT_EXC_HANDLER */

#ifndef OMIT_DEFAULT_INT_HANDLER
/*
 *  o^݂̊ꍇɌĂяo
 */
void
default_int_handler(void *p_excinf)
{
    target_exit();
}
#endif /* OMIT_DEFAULT_INT_HANDLER */

