/*
 *  TOPPERS/FI4 Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Fullset uItron4 Kernel
 * 
 *  Copyright (C) 2003-2006 by Monami software Limited Partnership, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: /local/fi4-1.4/toppers/RELEASE_20061105_1/kernel/kmem.h 6183 2006-11-05T03:43:32.794177Z monaka  $
 */

/*
 *  J[lAP[^
 */

#ifndef TOPPERS_KMEM_H
#define TOPPERS_KMEM_H

#include "t_stddef.h"
#include "queue.h"

typedef struct __kernel_memory_control_block {
  QUEUE queue;
  uint32_t magic;
  bool_t used;
  uint_t size;
} KMEMB;

extern bool_t	kmem_setup(void *buffer, uint_t size, KMEMB **p_kmemb);
extern bool_t	kmem_allocatable(KMEMB *kmemb, uint_t size);
extern bool_t	kmem_allocate(KMEMB *kmemb, uint_t size, void **p_blk);
extern bool_t	kmem_release(KMEMB *kmemb, void *blk);
extern bool_t	kmem_status(KMEMB *kmemb, uint_t *remain, uint_t *maxblk);

#define KMEM_MAGIC (0xCAFEBABE)
#define KMEM_DELTA 40

#endif /* TOPPERS_KMEM_H */
