/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2007 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 */

/*
 *  VAI/OfoCXiSIOjhCoiCQ-STARMpj
 */

#ifndef TOPPERS_TARGET_SERIAL_H
#define TOPPERS_TARGET_SERIAL_H

#include "cq_starm.h"

/*
 *  SIO̊݃nh̃xN^ԍ
 */
#if (SIO_PORTID == 1)
#define INHNO_SIO		IRQ_VECTOR_USART1
#define INTNO_SIO		IRQ_VECTOR_USART1
#elif (SIO_PORID == 2)
#define INHNO_SIO		IRQ_VECTOR_USART2
#define INTNO_SIO		IRQ_VECTOR_USART2
#endif
#define INTPRI_SIO		-3				/* ݗDx */
#define INTATR_SIO		0				/* ݑ */

/*
 *  R[obN[`̎ʔԍ
 */
#define SIO_RDY_SND    1U        /* M\R[obN */
#define SIO_RDY_RCV    2U        /* MʒmR[obN */

#ifndef TOPPERS_MACRO_ONLY

/*
 *  VA|[g̊ǗubN
 */
typedef struct sio_port_control_block {
	ID port;
	uint32_t reg;
	intptr_t exinf;
} SIOPCB;

/*
 *  SIOhCȍ
 */
extern void sio_initialize(intptr_t exinf);

/*
 *  VAI/O|[g̃I[v
 */
extern SIOPCB *sio_opn_por(ID siopid, intptr_t exinf);

/*
 *  VAI/O|[g̃N[Y
 */
extern void sio_cls_por(SIOPCB *p_siopcb);

/*
 *  SIO̊݃T[rX[`
 */
extern void sio_isr(intptr_t exinf);

/*
 *  VAI/O|[gւ̕M
 */
extern bool_t sio_snd_chr(SIOPCB *p_siopcb, char_t c);

/*
 *  VAI/O|[g̕M
 */
extern int_t sio_rcv_chr(SIOPCB *p_siopcb);

/*
 *  VAI/O|[g̃R[obN̋
 */
extern void sio_ena_cbr(SIOPCB *p_siopcb, uint_t cbrtn);

/* 
 *  VAI/O|[g̃R[obN̋֎~
 */
extern void sio_dis_cbr(SIOPCB *p_siopcb, uint_t cbrtn);

/*
 *  VAI/O|[g̑M\R[obN
 */
extern void sio_irdy_snd(intptr_t exinf);

/*
 *  VAI/O|[g̎MʒmR[obN
 */
extern void sio_irdy_rcv(intptr_t exinf);

/*
 *  1Mi|[Oł̏ój
 *
extern void sio_pol_snd_chr(char_t c, ID siopid);*/

/*
 *  ^[Qbg̃VA
 *
extern void target_usart_init(ID siopid);*/

#endif /* TOPPERS_MACRO_ONLY */
#endif /* TOPPERS_TARGET_SERIAL_H */
