/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2002 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  Copyright (C) 2005 by Freelines CO.,Ltd
 *
 *  Copyright (C) 2010 by Meika Sugimoto
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 * ^[QbgˑVAI/OW[iV850ES/Jx3E 񓯊VAch0/ch1/ch2pj
 *   {[[gݒSERIAL_COMPAREVALUEύXB
 *   f[^tH[}bg8bit data, non-parity, 1stop-bitŒ
 */

#ifndef TOPPERS_TARGET_SERIAL_H
#define TOPPERS_TARGET_SERIAL_H

#include "tk_v850_jh3e.h"

#define SIO_RDY_SND		(1u)
#define SIO_RDY_RCV		(2u)


/*
 *  SIO̊݃nh̃xN^ԍ
 */
#define INHNO_SIO_TX	 80			/* ݃nhԍ */
#define INTNO_SIO_TX	 80			/* ݔԍ */
#define INHNO_SIO_RX	 79			/* ݃nhԍ */
#define INTNO_SIO_RX	 79			/* ݔԍ */
#define INTPRI_SIO		 (-4)		/* ݗDx */
#define INTATR_SIO		 TA_NULL	/* ݑ */


#ifndef TOPPERS_MACRO_ONLY

/* VAǗ\̂̑O錾 */
typedef struct sio_port_control_block SIOPCB;


/*
 *  SIOhCȍ
 */
extern void sio_initialize(intptr_t exinf);

/*
 *  VAI/O|[g̃I[v
 */
extern SIOPCB *sio_opn_por(ID siopid, intptr_t exinf);

/*
 *  VAI/O|[g̃N[Y
 */
extern void sio_cls_por(SIOPCB *p_siopcb);

/*
 *  SIO̊݃T[rX[`
 */
extern void sio_tx_isr(intptr_t exinf);
extern void sio_rx_isr(intptr_t exinf);

/*
 *  VAI/O|[gւ̕M
 */
extern bool_t sio_snd_chr(SIOPCB *siopcb, char_t c);

/*
 *  VAI/O|[g̕M
 */
extern int_t sio_rcv_chr(SIOPCB *siopcb);

/*
 *  VAI/O|[g̃R[obN̋
 */
extern void sio_ena_cbr(SIOPCB *siopcb, uint_t cbrtn);

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
extern void sio_dis_cbr(SIOPCB *siopcb, uint_t cbrtn);

/*
 *  VAI/O|[g̑M\R[obN
 */
extern void sio_irdy_snd(intptr_t exinf);

/*
 *  VAI/O|[g̎MʒmR[obN
 */
extern void sio_irdy_rcv(intptr_t exinf);

#endif /* TOPPERS_MACRO_ONLY */


#endif /* TOPPERS_TARGET_SERIAL_H */
