/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: ppp_auth.c,v 1.5 2009/12/24 05:42:40 abe Exp abe $
 */

/*
 * auth.c - PPP authentication and phase control.
 *
 * Copyright (c) 1993 The Australian National University.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the Australian National University.  The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Copyright (c) 1989 Carnegie Mellon University.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Carnegie Mellon University.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/*
 *			PPP Secret Key Module
 *
 *	    Written by Toshiharu OHNO (tony-o@iij.ad.jp)
 *
 *   Copyright (C) 1994, Internet Initiative Japan, Inc. All rights reserverd.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the Internet Initiative Japan, Inc.  The name of the
 * IIJ may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * $FreeBSD: src/usr.sbin/ppp/auth.c,v 1.50 1999/12/27 11:43:30 brian Exp $
 *
 *	TODO:
 *		o Implement check against with registered IP addresses.
 */

#include <s_services.h>
#include <t_services.h>

#include <tinet_defs.h>
#include <tinet_config.h>

#include <net/if.h>
#include <net/if_ppp.h>
#include <net/net.h>
#include <net/net_buf.h>
#include <net/ppp.h>
#include <net/ppp_var.h>
#include <net/ppp_auth.h>
#include <net/ppp_fsm.h>
#include <net/ppp_lcp.h>
#include <net/ppp_upap.h>

#ifdef SUPPORT_PPP

/*
 *  萔
 */

#define PAP_PEND_SERVER		UINT_C(0x01)
#define PAP_PEND_CLIENT		UINT_C(0x02)
#define CHAP_PEND_SERVER	UINT_C(0x04)
#define CHAP_PEND_CLIENT	UINT_C(0x08)

/*
 *  network_phase -- RlNVm
 */

void
network_phase (void)
{
	int_t		num, ix;
	T_PPP_PROTENT	*proto;

	ppp_phase = PPP_PHASE_NETWORK;

	/* ʃvgRI[v */
	num = 0;
	for (ix = 0; (proto = protocols[ix]) != NULL; ix ++)
#if 0	/* ۗA폜֎~ */
		if (proto->proto < 0xc000 && proto->open != NULL) {
#else	/* of #if 0 */
		if (proto->open != NULL) {
#endif	/* of #if 0 */
			(*proto->open)();
			if (proto->proto != PPP_CCP)
				num ++;
		}

	if (num == 0)
		/* ʃvgRȂ */
		lcp_close();
	else
		syslog(LOG_NOTICE, "[PPP] up.");
}

/*
 *  link_required -- NJ݂B
 */

void
link_required (void)
{
}

/*
 *  link_terminated -- OAEgāANؒfB
 */

void
link_terminated (void)
{
	ppp_phase     = PPP_PHASE_DEAD;
	ppp_open_mode = PPP_OPEN_PASSIVE;
	syslog(LOG_NOTICE, "[PPP] down.");
}

/*
 *  link_down -- NB
 */

void
link_down (void)
{
	int_t		ix;
	T_PPP_PROTENT	*proto;

	/* ʃvgR */
	for (ix = 0; (proto = protocols[ix]) != NULL; ix ++) {
		if (proto->proto != PPP_LCP && proto->lowerdown != NULL)
			(*proto->lowerdown)();
		if (proto->proto < 0xc000 && proto->close != NULL)
			(*proto->close)();
	}

	if (ppp_phase != PPP_PHASE_DEAD)
		ppp_phase = PPP_PHASE_TERMINATE;
}

/*
 *  link_established -- N̐ڑmB
 */

void
link_established (void)
{
	int_t		ix;
	T_PPP_PROTENT	*proto;

#if defined(LCP_CFG_CHAP) || defined(LCP_CFG_PAP)

	int		auth;

#endif	/* of #if defined(LCP_CFG_CHAP) || defined(LCP_CFG_PAP) */

	/* ʃvgRN */
	for (ix = 0; (proto = protocols[ix]) != NULL; ix ++)
		if (proto->lowerup != NULL)
			(*proto->lowerup)();

	/* F؃IvVmFByz*/

	ppp_phase = PPP_PHASE_AUTHENTICATE;

#if defined(LCP_CFG_CHAP) || defined(LCP_CFG_PAP)

	auth = 0;

#ifdef AUTH_CFG_SERVER

#if defined(LCP_CFG_CHAP)

	if (lcp_local_ack_cfg.options & LCP_CFG_CHAP) {
		chap_auth_server();
		auth |= CHAP_PEND_SERVER;
	}

#endif	/* of #if defined(LCP_CFG_CHAP) */

#if defined(LCP_CFG_PAP)
	
	if (lcp_local_ack_cfg.options & LCP_CFG_PAP) {
		upap_auth_server();
		auth |= PAP_PEND_SERVER;
	}

#endif	/* of #if defined(LCP_CFG_PAP) */

#endif	/* of #ifdef AUTH_CFG_SERVER */

#ifdef AUTH_CFG_CLIENT

#if defined(LCP_CFG_PAP)
	
	if (lcp_remote_ack_cfg.options & LCP_CFG_PAP) {
		upap_auth_client();
		auth |= PAP_PEND_CLIENT;
	}

#endif	/* of #if defined(LCP_CFG_PAP) */

#endif	/* of #ifdef AUTH_CFG_CLIENT */

	if (auth == 0)
		network_phase();

#else	/* of #if defined(LCP_CFG_CHAP) || defined(LCP_CFG_PAP) */

	network_phase();

#endif	/* of #if defined(LCP_CFG_CHAP) || defined(LCP_CFG_PAP) */

}

/*
 *  auth_reset -- F؃IvVĊmFB
 */

void
auth_reset (void)
{
}

#endif	/* fo #ifdef SUPPORT_PPP */
