/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: if_v850ecreg.h,v 1.5 2009/12/24 05:46:31 abe Exp abe $
 */

/*
 * Copyright (C) 1993, David Greenman. This software may be used, modified,
 *   copied, distributed, and sold, in both source and binary form provided
 *   that the above copyright and these terms are retained. Under no
 *   circumstances is the author responsible for the proper functioning
 *   of this software, nor does the author assume any responsibility
 *   for damages incurred with its use.
 *
 * $FreeBSD: src/sys/i386/isa/if_edreg.h,v 1.25.2.2 1999/09/25 13:08:18 nyan Exp $
 */

/*
 * National Semiconductor DS8390 NIC register definitions
 *
 *
 * Modification history
 *
 * Revision 2.2  1993/11/29  16:33:39  davidg
 * From Thomas Sandford <t.d.g.sandford@comp.brad.ac.uk>
 * Add support for the 8013W board type
 *
 * Revision 2.1  1993/11/22  10:52:33  davidg
 * patch to add support for SMC8216 (Elite-Ultra) boards
 * from Glen H. Lowe
 *
 * Revision 2.0  93/09/29  00:37:15  davidg
 * changed double buffering flag to multi buffering
 * made changes/additions for 3c503 multi-buffering
 * ...companion to Rev. 2.0 of 'ed' driver.
 *
 * Revision 1.1  93/06/23  03:01:07  davidg
 * Initial revision
 *
 */

/*
 * V850 Ethernet Controller p
 */

#ifndef _If_EDREG_H_
#define _If_EDREG_H_

/*
 *  NE2000 ݊WX^
 */

/*
 *  WX^ItZbg
 */

/* y[W 0Aǂݏo */

#define V850EC_P0_CR		UINT_C(0x00)
#define V850EC_P0_CLDA0		UINT_C(0x01)
#define V850EC_P0_CLDA1		UINT_C(0x02)
#define V850EC_P0_BNRY		UINT_C(0x03)
#define V850EC_P0_TSR		UINT_C(0x04)
#define V850EC_P0_NCR		UINT_C(0x05)
#define V850EC_P0_FIFO		UINT_C(0x06)
#define V850EC_P0_ISR		UINT_C(0x07)
#define V850EC_P0_CRDA0		UINT_C(0x08)
#define V850EC_P0_CRDA1		UINT_C(0x09)
#define V850EC_P0_RSR		UINT_C(0x0c)
#define V850EC_P0_CNTR0		UINT_C(0x0d)
#define V850EC_P0_CNTR1		UINT_C(0x0e)
#define V850EC_P0_CNTR2		UINT_C(0x0f)

/* y[W 0A */

#define V850EC_P0_PSTART		UINT_C(0x01)
#define V850EC_P0_PSTOP		UINT_C(0x02)
#define V850EC_P0_TPSR		UINT_C(0x04)
#define V850EC_P0_TBCR0		UINT_C(0x05)
#define V850EC_P0_TBCR1		UINT_C(0x06)
#define V850EC_P0_RSAR0		UINT_C(0x08)
#define V850EC_P0_RSAR1		UINT_C(0x09)
#define V850EC_P0_RBCR0		UINT_C(0x0a)
#define V850EC_P0_RBCR1		UINT_C(0x0b)
#define V850EC_P0_RCR		UINT_C(0x0c)
#define V850EC_P0_TCR		UINT_C(0x0d)
#define V850EC_P0_DCR		UINT_C(0x0e)
#define V850EC_P0_IMR		UINT_C(0x0f)

/* y[W 1Aǂݏ */

#define V850EC_P1_CR		UINT_C(0x00)
#define V850EC_P1_PAR(x)		((x)+UINT_C(0x01))
#define V850EC_P1_CURR		UINT_C(0x07)
#define V850EC_P1_MAR(x)		((x)+UINT_C(0x08))

/*
 *  y[W 0AItZbg 0x00AR/WACommand Register (CR)
 */

#define V850EC_CR_STP_BIT		0
#define V850EC_CR_STA_BIT		1
#define V850EC_CR_TXP_BIT		2
#define V850EC_CR_RD0_BIT		3
#define V850EC_CR_RD1_BIT		4
#define V850EC_CR_RD2_BIT		5
#define V850EC_CR_PS0_BIT		6
#define V850EC_CR_PS1_BIT		7

#define V850EC_CR_STP		(1<<V850EC_CR_STP_BIT)
#define V850EC_CR_STA		(1<<V850EC_CR_STA_BIT)
#define V850EC_CR_TXP		(1<<V850EC_CR_TXP_BIT)
#define V850EC_CR_RD0		(1<<V850EC_CR_RD0_BIT)
#define V850EC_CR_RD1		(1<<V850EC_CR_RD1_BIT)
#define V850EC_CR_RD2		(1<<V850EC_CR_RD2_BIT)
#define V850EC_CR_PS0		(1<<V850EC_CR_PS0_BIT)
#define V850EC_CR_PS1		(1<<V850EC_CR_PS1_BIT)

#define V850EC_CR_PAGE0		(0)
#define V850EC_CR_PAGE1		(V850EC_CR_PS0)
#define V850EC_CR_PAGE2		(V850EC_CR_PS1)
#define V850EC_CR_PAGE3		(V850EC_CR_PS1|V850EC_CR_PS0)

/*
 *  y[W 0AItZbg 0x04ARATransmit Status Register (TSR)
 */

#define V850EC_TSR_PTX_BIT		0
#define V850EC_TSR_COL_BIT		2
#define V850EC_TSR_ABT_BIT		3
#define V850EC_TSR_CRS_BIT		4
#define V850EC_TSR_CDH_BIT		6
#define V850EC_TSR_OWC_BIT		7

#define V850EC_TSR_PTX		(1<<V850EC_TSR_PTX_BIT)
#define V850EC_TSR_COL		(1<<V850EC_TSR_COL_BIT)
#define V850EC_TSR_ABT		(1<<V850EC_TSR_ABT_BIT)
#define V850EC_TSR_CRS		(1<<V850EC_TSR_CRS_BIT)
#define V850EC_TSR_CDH		(1<<V850EC_TSR_CDH_BIT)
#define V850EC_TSR_OWC		(1<<V850EC_TSR_OWC_BIT)

/*
 *  y[W 0AItZbg 0x07AR/WAInterrupt Status Register (ISR)
 */

#define V850EC_ISR_PRX_BIT		0
#define V850EC_ISR_PTX_BIT		1
#define V850EC_ISR_RXE_BIT		2
#define V850EC_ISR_TXE_BIT		3
#define V850EC_ISR_OVW_BIT		4
#define V850EC_ISR_CNT_BIT		5
#define V850EC_ISR_RDC_BIT		6
#define V850EC_ISR_RST_BIT		7

#define V850EC_ISR_PRX		(1<<V850EC_ISR_PRX_BIT)
#define V850EC_ISR_PTX		(1<<V850EC_ISR_PTX_BIT)
#define V850EC_ISR_RXE		(1<<V850EC_ISR_RXE_BIT)
#define V850EC_ISR_TXE		(1<<V850EC_ISR_TXE_BIT)
#define V850EC_ISR_OVW		(1<<V850EC_ISR_OVW_BIT)
#define V850EC_ISR_CNT		(1<<V850EC_ISR_CNT_BIT)
#define V850EC_ISR_RDC		(1<<V850EC_ISR_RDC_BIT)
#define V850EC_ISR_RST		(1<<V850EC_ISR_RST_BIT)

/*
 *  y[W 0AItZbg 0x0cAW
 *  y[W 2AItZbg 0x0cAR
 *  Recive Configuration Register (RCR)
 */

#define V850EC_RCR_SEP_BIT		0
#define V850EC_RCR_AR_BIT		1
#define V850EC_RCR_AB_BIT		2
#define V850EC_RCR_AM_BIT		3
#define V850EC_RCR_PRO_BIT		4
#define V850EC_RCR_MON_BIT		5

#define V850EC_RCR_SEP		(1<<V850EC_RCR_SEP_BIT)
#define V850EC_RCR_AR		(1<<V850EC_RCR_AR_BIT)
#define V850EC_RCR_AB		(1<<V850EC_RCR_AB_BIT)
#define V850EC_RCR_AM		(1<<V850EC_RCR_AM_BIT)
#define V850EC_RCR_PRO		(1<<V850EC_RCR_PRO_BIT)
#define V850EC_RCR_MON		(1<<V850EC_RCR_MON_BIT)

/*
 *  y[W 0AItZbg 0x0dAW
 *  y[W 2AItZbg 0x0dAR
 *  Transmit Configuration Register (TCR)
 */

#define V850EC_TCR_CRC_BIT		0
#define V850EC_TCR_LB0_BIT		1
#define V850EC_TCR_LB1_BIT		2
#define V850EC_TCR_ATD_BIT		3
#define V850EC_TCR_OFST_BIT		4

#define V850EC_TCR_CRC		(1<<V850EC_TCR_CRC_BIT)
#define V850EC_TCR_LB0		(1<<V850EC_TCR_LB0_BIT)
#define V850EC_TCR_LB1		(1<<V850EC_TCR_LB1_BIT)
#define V850EC_TCR_ATD		(1<<V850EC_TCR_ATD_BIT)
#define V850EC_TCR_OFST		(1<<V850EC_TCR_OFST_BIT)

/*
 *  y[W 0AItZbg 0x0eAW
 *  y[W 2AItZbg 0x0eAR
 *  Data Configuration Register (DCR)
 */

#define V850EC_DCR_WTS_BIT		0
#define V850EC_DCR_BOS_BIT		1
#define V850EC_DCR_LAS_BIT		2
#define V850EC_DCR_LS_BIT		3
#define V850EC_DCR_ARM_BIT		4
#define V850EC_DCR_FT0_BIT		5
#define V850EC_DCR_FT1_BIT		6

#define V850EC_DCR_WTS		(1<<V850EC_DCR_WTS_BIT)
#define V850EC_DCR_BOS		(1<<V850EC_DCR_BOS_BIT)
#define V850EC_DCR_LAS		(1<<V850EC_DCR_LAS_BIT)
#define V850EC_DCR_LS		(1<<V850EC_DCR_LS_BIT)
#define V850EC_DCR_ARM		(1<<V850EC_DCR_ARM_BIT)
#define V850EC_DCR_FT0		(1<<V850EC_DCR_FT0_BIT)
#define V850EC_DCR_FT1		(1<<V850EC_DCR_FT1_BIT)

/*
 *  y[W 0AItZbg 0x0fAW
 *  y[W 2AItZbg 0x0fAR
 *  Interrupt Mask Register (IMR)
 */

#define V850EC_IMR_PRX_BIT		0
#define V850EC_IMR_PTX_BIT		1
#define V850EC_IMR_RXE_BIT		2
#define V850EC_IMR_TXE_BIT		3
#define V850EC_IMR_OVW_BIT		4
#define V850EC_IMR_CNT_BIT		5
#define V850EC_IMR_RDC_BIT		6
#define V850EC_IMR_RST_BIT		7

#define V850EC_IMR_PRX		(1<<V850EC_IMR_PRX_BIT)
#define V850EC_IMR_PTX		(1<<V850EC_IMR_PTX_BIT)
#define V850EC_IMR_RXE		(1<<V850EC_IMR_RXE_BIT)
#define V850EC_IMR_TXE		(1<<V850EC_IMR_TXE_BIT)
#define V850EC_IMR_OVW		(1<<V850EC_IMR_OVW_BIT)
#define V850EC_IMR_CNT		(1<<V850EC_IMR_CNT_BIT)
#define V850EC_IMR_RDC		(1<<V850EC_IMR_RDC_BIT)
#define V850EC_IMR_RST		(1<<V850EC_IMR_RST_BIT)

/*
 *  Mt[wb_\
 */

typedef struct t_v850ec_frame_hdr {
	uint8_t		rsr;		/* MXe[^X	*/
	uint8_t		next;		/* ̃t[̃y[W	*/
	uint16_t	count;		/* t[ (+4)	*/
	} T_V850EC_FRAME_HDR;

/*
 *   RAM
 */

/* : 16 rbg[h͖ */
#ifdef IF_V850EC_CFG_16BIT

#define V850EC_INT_RAM_SIZE		UINT_C(0x4000)

#else	/* of #ifdef IF_V850EC_CFG_16BIT */

#define V850EC_INT_RAM_SIZE		UINT_C(0x2000)

#endif	/* of #ifdef IF_V850EC_CFG_16BIT */

#define V850EC_INT_RAM_BASE		UINT_C(0x4000)

#define V850EC_PAGE_SIZE		256
#define NUM_IF_V850EC_TXBUF_PAGE	((ETHER_MAX_LEN + V850EC_PAGE_SIZE - 1) / V850EC_PAGE_SIZE)
#define IF_V850EC_TXBUF_PAGE_SIZE	(NUM_IF_V850EC_TXBUF_PAGE * NUM_IF_V850EC_TXBUF)
#define IF_V850EC_RXBUF_PAGE_SIZE	(V850EC_INT_RAM_SIZE / V850EC_PAGE_SIZE - IF_V850EC_TXBUF_PAGE_SIZE)

/*
 *  AhX̃ItZbg
 */

#define V850EC_NIC_OFFSET		UINT_C(0x00)
#define V850EC_ASIC_OFFSET		UINT_C(0x10)
#define V850EC_DATA_OFFSET		UINT_C(0x00)
#define V850EC_RESET_OFFSET		UINT_C(0x0f)

/*
 *  V850 Ethernet Controller pWX^
 */

/*
 *  WX^ItZbg
 */

/* y[W 3Aǂݏo */

#define V850EC_RTL_P3_CR		UINT_C(0x00)
#define V850EC_RTL_P3_9346CR	UINT_C(0x01)
#define V850EC_RTL_P3_BPAGE		UINT_C(0x02)
#define V850EC_RTL_P3_CONFIG0	UINT_C(0x03)
#define V850EC_RTL_P3_CONFIG1	UINT_C(0x04)
#define V850EC_RTL_P3_CONFIG2	UINT_C(0x05)
#define V850EC_RTL_P3_CONFIG3	UINT_C(0x06)
#define V850EC_RTL_P3_TEST		UINT_C(0x07)
#define V850EC_RTL_P3_CSNSAV	UINT_C(0x08)
#define V850EC_RTL_P3_INTR		UINT_C(0x0b)
#define V850EC_RTL_P3_CONFIG4	UINT_C(0x0d)

/* y[W 3A */

#define V850EC_RTL_P3_HTLCLK	UINT_C(0x09)
#define V850EC_RTL_P3_FMWP		UINT_C(0x0c)

/* y[W 3AItZbg 0x04AR/WAConfiguration 0 */

#define V850EC_RTL_CFG0_IOS0_BIT	0
#define V850EC_RTL_CFG0_IOS1_BIT	1
#define V850EC_RTL_CFG0_IOS2_BIT	2
#define V850EC_RTL_CFG0_IOS3_BIT	3
#define V850EC_RTL_CFG0_IRQS0_BIT	4
#define V850EC_RTL_CFG0_IRQS1_BIT	5
#define V850EC_RTL_CFG0_IRQS2_BIT	6
#define V850EC_RTL_CFG0_IRQEN_BIT	7

#define V850EC_RTL_CFG0_IOS0	(1<<V850EC_RTL_CFG0_IOS0_BIT)
#define V850EC_RTL_CFG0_IOS1	(1<<V850EC_RTL_CFG0_IOS1_BIT)
#define V850EC_RTL_CFG0_IOS2	(1<<V850EC_RTL_CFG0_IOS2_BIT)
#define V850EC_RTL_CFG0_IOS3	(1<<V850EC_RTL_CFG0_IOS3_BIT)
#define V850EC_RTL_CFG0_IRQS0	(1<<V850EC_RTL_CFG0_IRQS0_BIT)
#define V850EC_RTL_CFG0_IRQS1	(1<<V850EC_RTL_CFG0_IRQS1_BIT)
#define V850EC_RTL_CFG0_IRQS2	(1<<V850EC_RTL_CFG0_IRQS2_BIT)
#define V850EC_RTL_CFG0_IRQEN	(1<<V850EC_RTL_CFG0_IRQEN_BIT)

#endif	/* of #ifndef _If_EDREG_H_ */
