/*
 *  TINET (UDP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: udp_usrreq_nblk.c,v 1.5 2009/12/24 05:47:21 abe Exp abe $
 */

/*
 * Copyright (c) 1982, 1986, 1988, 1990, 1993, 1995
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must ceproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)udp_usrreq.c	8.6 (Berkeley) 5/23/95
 * $FreeBSD: src/sys/netinet/udp_usrreq.c,v 1.49.2.2 1999/08/29 16:29:58 peter Exp $
 */

#include <string.h>

#ifdef TARGET_KERNEL_ASP

#include <kernel.h>
#include <sil.h>
#include "kernel_cfg.h"

#endif	/* of #ifdef TARGET_KERNEL_ASP */

#ifdef TARGET_KERNEL_JSP

#include <s_services.h>
#include <t_services.h>
#include "kernel_id.h"

#endif	/* of #ifdef TARGET_KERNEL_JSP */

#include <tinet_defs.h>
#include <tinet_config.h>

#include <net/if.h>
#include <net/if_ppp.h>
#include <net/if_loop.h>
#include <net/ethernet.h>
#include <net/net.h>
#include <net/net_buf.h>
#include <net/net_count.h>
#include <net/ppp_ipcp.h>

#include <netinet/in.h>
#include <netinet6/in6.h>
#include <netinet/in_var.h>
#include <netinet/in_itron.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <netinet/ip_icmp.h>
#include <netinet6/in6_var.h>
#include <netinet/ip6.h>
#include <netinet6/ip6_var.h>
#include <netinet6/nd6.h>
#include <netinet/icmp6.h>
#include <netinet/udp.h>
#include <netinet/udp_var.h>

#ifdef SUPPORT_UDP

/*
 *  IPv4  IPv6 ̐؂ւ}N
 */

#if defined(SUPPORT_INET4)

#define UDP_SND_DAT	udp_snd_dat
#define UDP_RCV_DAT	udp_rcv_dat

#endif	/* of #if defined(SUPPORT_INET4) */

#if defined(SUPPORT_INET6)

#define UDP_SND_DAT	udp6_snd_dat
#define UDP_RCV_DAT	udp6_rcv_dat

#endif	/* of #if defined(SUPPORT_INET6) */

/*
 *  TINET CuȂꍇ́ASĂ̋@\
 *  IuWFNgt@Cɏo͂邽߁A}NLɂB
 */

#ifndef UDP_CFG_LIBRARY

#define __udp_can_snd
#define __udp_can_rcv
#define __udp_snd_dat
#define __udp_rcv_dat

#endif	/* of #ifndef UDP_CFG_LIBRARY */

#ifdef UDP_CFG_NON_BLOCKING

#ifdef __udp_can_snd

/*
 *  udp_can_snd -- yfBOĂ鑗M̃LZ
 */

ER
udp_can_snd (T_UDP_CEP *cep, ER error)
{
	if (cep->snd_p_dstaddr != NULL) {	/* mubLOR[ŃyfBO */
		if (IS_PTR_DEFINED(cep->callback))

#ifdef TCP_CFG_NON_BLOCKING_COMPAT14

			(*cep->callback)(GET_UDP_CEPID(cep), TFN_UDP_SND_DAT, (void*)error);

#else	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

			(*cep->callback)(GET_UDP_CEPID(cep), TFN_UDP_SND_DAT, (void*)&error);

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

		else
			error = E_OBJ;
		cep->snd_p_dstaddr = NULL;
	}
	else if (cep->snd_tskid != TA_NULL) {	/* mubLOR[ŃyfBO */

#ifdef UDP_CFG_EXTENTIONS

		/* ҂ɔG[ݒ肷B*/
		cep->error = error;

#endif	/* of #ifdef UDP_CFG_EXTENTIONS */

		error = rel_wai(cep->snd_tskid);
		cep->snd_tskid = TA_NULL;
	}
	else					/* ǂłȂȂyfBOĂȂ */
		error = EV_NOPND;

	return error;
}

#endif	/* of #ifdef __udp_can_snd */

#ifdef __udp_can_rcv

/*
 *  udp_can_rcv -- yfBOĂM̃LZ
 */

ER
udp_can_rcv (T_UDP_CEP *cep, ER error)
{
	if (cep->rcv_p_dstaddr != NULL) {	/* mubLOR[ŃyfBO */
		if (IS_PTR_DEFINED(cep->callback))

#ifdef TCP_CFG_NON_BLOCKING_COMPAT14

			(*cep->callback)(GET_UDP_CEPID(cep), TFN_UDP_RCV_DAT, (void*)error);

#else	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

			(*cep->callback)(GET_UDP_CEPID(cep), TFN_UDP_RCV_DAT, (void*)&error);

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

		else
			error = E_OBJ;
		cep->rcv_p_dstaddr = NULL;
	}
	else if (cep->rcv_tskid != TA_NULL) {	/* mubLOR[ŃyfBO */

#ifdef UDP_CFG_EXTENTIONS

		/* ҂ɔG[ݒ肷B*/
		cep->error = error;

#endif	/* of #ifdef UDP_CFG_EXTENTIONS */

		error = rel_wai(cep->rcv_tskid);
		cep->rcv_tskid = TA_NULL;
	}
	else					/* ǂłȂȂyfBOĂȂ */
		error = EV_NOPND;

	return error;
}

#endif	/* of #ifdef __udp_can_rcv */

#ifdef __udp_snd_dat

/*
 *  udp_snd_dat -- pPbg̑MyW@\z
 */

ER_UINT
UDP_SND_DAT (ID cepid, T_IPEP *p_dstaddr, void *data, int_t len, TMO tmout)
{
	T_UDP_CEP	*cep;
	ER		error;

	/* p_dstaddr ܂ data  NULL ȂG[ */
	if (p_dstaddr == NULL || data == NULL)
		return E_PAR;

	/* f[^`FbNB*/
	if (len < 0 || len + IP_HDR_SIZE + UDP_HDR_SIZE > IF_MTU)
		return E_PAR;

	/* UDP ʐM[_ ID `FbNB*/
	if (!VALID_UDP_CEPID(cepid))
		return E_ID;

	/* UDP ʐM[_𓾂B*/
	cep = GET_UDP_CEP(cepid);

	/* UDP ʐM[_`FbNB*/
	if (!VALID_UDP_CEP(cep))
		return E_NOEXS;

	/*
	 *  |[gԍ UDP_PORTANY ȂAŊ蓖ĂB
	 */
	if (cep->myaddr.portno == UDP_PORTANY) {
		if ((error = udp_alloc_auto_port(cep)) != E_OK)
			return error;
	}

	/*
	 * ^CAEg`FbNB
	 */

	if (tmout == TMO_NBLK) {	/* mubLOR[ */

		/* ʐM[_bNB*/
		syscall(wai_sem(cep->semid_lock));

		if (cep->snd_p_dstaddr != NULL) {

			/* mubLOR[ŃyfBO */
			error = E_QOVR;

			/* ʐM[_bNB*/
			syscall(sig_sem(cep->semid_lock));
		}
		else if (cep->snd_tskid != TA_NULL) {

			/* mubLOR[ŃyfBO */
			error = E_OBJ;

			/* ʐM[_bNB*/
			syscall(sig_sem(cep->semid_lock));
		}
		else {

			cep->snd_p_dstaddr = p_dstaddr;
			cep->snd_data	= data;
			cep->snd_len	= len;

			/* ʐM[_bNB*/
			syscall(sig_sem(cep->semid_lock));

			cep->flags |= UDP_CEP_FLG_POST_OUTPUT;
			sig_sem(SEM_UDP_POST_OUTPUT);
			error = E_WBLK;
		}
	}
	else {				/* mubLOR[ */
	
		/* ʐM[_bNB*/
		syscall(wai_sem(cep->semid_lock));

		if (cep->snd_p_dstaddr != NULL) {

			/* mubLOR[ŃyfBO */
			error = E_OBJ;

			/* ʐM[_bNB*/
			syscall(sig_sem(cep->semid_lock));
		}
		else if (cep->snd_tskid != TA_NULL) {

			/* mubLOR[ŃyfBO */
			error = E_QOVR;

			/* ʐM[_bNB*/
			syscall(sig_sem(cep->semid_lock));
		}
		else {

			/* ݂̃^XNʎqL^B*/
			get_tid(&(cep->snd_tskid));

			/* ʐM[_bNB*/
			syscall(sig_sem(cep->semid_lock));

			/* pPbg𑗐MB*/
			error = udp_send_data(cep, p_dstaddr, data, len, tmout);
		}
	}

	return error;
}

#endif	/* of #ifdef __udp_snd_dat */

#ifdef __udp_rcv_dat

/*
 *  udp_rcv_dat -- pPbg̎MyW@\z
 */

ER_UINT
UDP_RCV_DAT (ID cepid, T_IPEP *p_dstaddr, void *data, int_t len, TMO tmout)
{
	T_NET_BUF	*input;
	T_UDP_CEP	*cep;
	T_UDP_HDR	*udph;
	ER_UINT		error;
	uint_t		ulen, uhoff;

	/* p_dstaddr ܂ data  NULL Alen < 0 ȂG[ */
	if (p_dstaddr == NULL || data == NULL || len < 0)
		return E_PAR;

	/* UDP ʐM[_ ID `FbNB*/
	if (!VALID_UDP_CEPID(cepid))
		return E_ID;

	/* UDP ʐM[_𓾂B*/
	cep = GET_UDP_CEP(cepid);

	/* UDP ʐM[_`FbNB*/
	if (!VALID_UDP_CEP(cep))
		return E_NOEXS;

	/*
	 * ^CAEg`FbNB
	 */

	if (tmout == TMO_NBLK) {	/* mubLOR[ */

		/* ʐM[_bNB*/
		syscall(wai_sem(cep->semid_lock));

		if (cep->rcv_p_dstaddr != NULL)

			/* mubLOR[ŃyfBO */
			error = E_QOVR;

		else if (cep->rcv_tskid != TA_NULL)

			/* mubLOR[ŃyfBO */
			error = E_OBJ;
		else {
			cep->rcv_p_dstaddr = p_dstaddr;
			cep->rcv_data	= data;
			cep->rcv_len	= len;
			error = E_WBLK;
		}

		/* ʐM[_bNB*/
		syscall(sig_sem(cep->semid_lock));
		return error;
	}
	else {				/* mubLOR[ */

		/* ʐM[_bNB*/
		syscall(wai_sem(cep->semid_lock));

		if (cep->rcv_p_dstaddr != NULL) {

			/* mubLOR[ŃyfBO */
			error = E_OBJ;

			/* ʐM[_bNB*/
			syscall(sig_sem(cep->semid_lock));
		}
		else if (cep->rcv_tskid != TA_NULL) {

			/* mubLOR[ŃyfBO */
			error = E_QOVR;

			/* ʐM[_bNB*/
			syscall(sig_sem(cep->semid_lock));
		}
		else {

			/* ݂̃^XNʎqL^B*/
			get_tid(&(cep->rcv_tskid));

			/* ʐM[_bNB*/
			syscall(sig_sem(cep->semid_lock));

			/* ͂܂ő҂B*/
			if (cep->cb_netbuf != NULL) {

				/*
				 *  ɂꍇ́AR[obN֐̒
				 *  udp_rcv_dat ĂяoĂ邱ƂɂȂA
				 *  łɓ͍ς݂łB
				 */
				input = cep->cb_netbuf;
				cep->cb_netbuf = NULL;
			}
			else if ((error = trcv_dtq(cep->rcvqid, (intptr_t*)&input, tmout)) != E_OK) {
				cep->rcv_tskid = TA_NULL;
				return error;
			}

			/* p_dstaddr ݒ肷B*/
			uhoff = (uint_t)GET_UDP_HDR_OFFSET(input);
			udph = GET_UDP_HDR(input, uhoff);
			p_dstaddr->portno = ntohs(udph->sport);
			IN_COPY_TO_HOST(&p_dstaddr->ipaddr, &GET_IP_HDR(input)->src);

			/* f[^obt@ɈڂB*/
			ulen = ntohs(udph->ulen);
			if (ulen - UDP_HDR_SIZE > len)
				error = E_BOVR;
			else {
				len   =     (int_t)(ulen - UDP_HDR_SIZE);
				error = (ER_UINT)(ulen - UDP_HDR_SIZE);
			}

			memcpy(data, GET_UDP_SDU(input, uhoff), (size_t)len);

			syscall(rel_net_buf(input));

			cep->rcv_tskid = TA_NULL;
		}
		return error;
	}
}

#endif	/* of #ifdef __udp_rcv_dat */

#endif	/* of #ifdef UDP_CFG_NON_BLOCKING */

#endif	/* of #ifdef SUPPORT_UDP */
