/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: icmp6.c,v 1.5 2009/12/24 05:48:16 abe Exp abe $
 */

/*	$FreeBSD: src/sys/netinet6/icmp66.c,v 1.6.2.6 2001/07/10 09:44:16 ume Exp $	*/
/*	$KAME: icmp66.c,v 1.211 2001/04/04 05:56:20 itojun Exp $	*/

/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * Copyright (c) 1982, 1986, 1988, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)ip_icmp6.c	8.2 (Berkeley) 1/4/94
 */

#include <string.h>

#ifdef TARGET_KERNEL_ASP

#include <kernel.h>
#include <sil.h>
#include <t_syslog.h>

#endif	/* of #ifdef TARGET_KERNEL_ASP */

#ifdef TARGET_KERNEL_JSP

#include <s_services.h>
#include <t_services.h>

#endif	/* of #ifdef TARGET_KERNEL_JSP */

#include <tinet_defs.h>
#include <tinet_config.h>

#include <net/if.h>
#include <net/if_loop.h>
#include <net/if_ppp.h>
#include <net/ethernet.h>
#include <net/net.h>
#include <net/net_buf.h>
#include <net/net_timer.h>
#include <net/net_count.h>

#include <netinet/in.h>
#include <netinet/in_var.h>
#include <netinet6/in6.h>
#include <netinet6/in6_var.h>
#include <netinet/ip6.h>
#include <netinet6/ip6_var.h>
#include <netinet/icmp6.h>
#include <netinet6/nd6.h>
#include <netinet/tcp.h>
#include <netinet/tcp_timer.h>
#include <netinet/tcp_var.h>

#ifdef SUPPORT_INET6

/*
 *  ϐ
 */

#ifdef SUPPORT_MIB

/*
 *  SNMP  Ǘx[X (MIB)
 */

T_ICMP6_IFSTAT icmp6_ifstat;

#endif	/* of #ifdef SUPPORT_MIB */

/*
 *  icmp6_output -- ICMP6 pPbg𑗐MB
 */

static void
icmp6_output (T_NET_BUF *output, uint_t off)
{
	T_IN6_IFADDR	*ia;
	T_IFNET		*ifp = IF_GET_IFNET();
	T_IP6_HDR	*ip6h;
	T_ICMP6_HDR	*icmp6h;

	/*
	 *  AhXɂӂ킵MAhXA
	 *  lbg[NC^tF[XTėpB
	 */
	ip6h = GET_IP6_HDR(output);
	if ((ia = in6_ifawithifp(ifp, &ip6h->dst)) == NULL) {
		NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpOutErrors, 1);
		syscall(rel_net_buf(output));
		return;
	}
	ip6h->src = ia->addr;

	icmp6h = GET_ICMP6_HDR(output, off);

	/* `FbNTvZB*/
	icmp6h->sum = 0;
	icmp6h->sum = in6_cksum(output, IPPROTO_ICMPV6, (uint8_t*)icmp6h - output->buf, 
	                        ntohs(ip6h->plen) - (off - IF_IP6_HDR_SIZE));

	/* MB*/
	NET_COUNT_ICMP6(net_count_icmp6[NC_ICMP6_OUT_OCTETS],
	               output->len - GET_IF_IP6_HDR_SIZE(output));
	NET_COUNT_ICMP6(net_count_icmp6[NC_ICMP6_OUT_PACKETS], 1);
	NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpOutMsgs, 1);
	ip6_output(output, 0, TMO_ICMP_OUTPUT);
}

/*
 *  icmp6_echo_request -- GR[vMƂ̏
 */

static void
icmp6_echo_request (T_NET_BUF *input, uint_t off)
{
	T_IP6_HDR	*ip6h;
	T_ICMP6_HDR	*icmp6h;
	T_IFNET		*ifp = IF_GET_IFNET();
	T_IN6_IFADDR	*ia;
	T_IN6_ADDR	dst;
	uint_t		diff;

	NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpInEchos, 1);

	ip6h       = GET_IP6_HDR(input);

	/*
	 *  IPv6 wb_ ICMPv6 wb_Ԃ̊gwb_B
	 */
	diff = off - IF_IP6_HDR_SIZE;
	if (diff > 0) {
		/* ICMPv6 wb_Oɋl߂B*/
		memmove(input->buf + IF_IP6_HDR_SIZE, input->buf + off, input->len - off);
		off = IF_IP6_HDR_SIZE;

		/* yC[h𒲐B*/
		ip6h->plen  = htons(ntohs(ip6h->plen) - diff);
		input->len -= diff;
	}

	icmp6h = GET_ICMP6_HDR(input, off);
	if (icmp6h->code != 0) {
		NET_COUNT_ICMP6(net_count_icmp6[NC_ICMP6_IN_ERR_PACKETS], 1);
		syscall(rel_net_buf(input));
		return;
	}

	/*
	 *  bZ[W̌^GR[v (128) 
	 *  GR[ (129) ɕύXđԂB
	 */
	icmp6h->type = ICMP6_ECHO_REPLY;

	/* IPv6 wb_̔MAhXƈAhXւB*/
	dst 	  = ip6h->dst;
	ip6h->dst = ip6h->src;
	ip6h->src = dst;

	/*
	 *  ̈AhX}`LXg̏ꍇ́A
	 *  AhXɂӂ킵MAhXA
	 *  lbg[NC^tF[XTėpB
	 */
	if (IN6_IS_ADDR_MULTICAST(&dst)) {
		if ((ia = in6_ifawithifp(ifp, &ip6h->dst)) == NULL) {
			syscall(rel_net_buf(input));
			return;
		}
		else
			ip6h->src = ia->addr;
	}

	/* wb_ƃzbv~bgݒ肷B*/
	ip6h->next = IPPROTO_ICMPV6;
	ip6h->hlim = IP_DEFTTL;

	/* `FbNTvZB*/
	icmp6h->sum = 0;
	icmp6h->sum = in6_cksum(input, IPPROTO_ICMPV6, (uint8_t*)icmp6h - input->buf, 
	                        ntohs(ip6h->plen) - (off - IF_IP6_HDR_SIZE));

	/* MB*/
	NET_COUNT_ICMP6(net_count_icmp6[NC_ICMP6_OUT_OCTETS],
	               input->len - GET_IF_IP6_HDR_SIZE(input));
	NET_COUNT_ICMP6(net_count_icmp6[NC_ICMP6_OUT_PACKETS], 1);
	NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpOutMsgs, 1);
	NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpOutEchoReplies, 1);
	ip6_output(input, 0, TMO_ICMP_OUTPUT);
}

/*
 *  icmp6_notify_error -- G[ʒmB
 */

static void
icmp6_notify_error(T_NET_BUF *input, uint_t poff)
{
	T_ICMP6_HDR	*icmp6h;
	ER_UINT		loff;
	uint_t		len, next;

	len  = input->len - poff;

	/* f[^O ICMP6 wb_ + IP6 wb_ȉȂ牽ȂB*/
	if (len < ICMP6_HDR_SIZE + IP6_HDR_SIZE)
		return;

	icmp6h = GET_ICMP6_HDR(input, poff);

	/* ŏIwb_TB*/
	loff = ip6_lasthdr(input, poff + ICMP6_HDR_SIZE, IPPROTO_IPV6, &next);

	/* ŏIwb_ TCP ̂ݑΉB*/
	if (loff >= 0 && next == IPPROTO_TCP) {

#ifdef SUPPORT_TCP

		memcpy(GET_IP6_HDR(input), input->buf + (loff + ICMP6_HDR_SIZE),
		                           input->len - (loff + ICMP6_HDR_SIZE));
		input->len -= loff + ICMP6_HDR_SIZE;
		tcp_notify(input, icmp6h->code == ICMP6_DST_UNREACH_NOPORT ? EV_CNNRF : EV_HURCH);

#endif	/* of #ifdef SUPPORT_TCP */

	}
	else
		syslog(LOG_NOTICE, "[ICMP6] error code: %d.", icmp6h->code);
}

#if NUM_IN6_HOSTCACHE_ENTRY > 0

/*
 *  icmp6_mtudisc_update -- Path MTU XVB
 */

static void
icmp6_mtudisc_update(T_NET_BUF *input, uint_t off, uint32_t mtu)
{
	T_IP6_HDR	*pip6h;

	pip6h = (T_IP6_HDR*)GET_ICMP6_SDU(input, off);

	if (mtu < IP6_HDR_SIZE + sizeof(T_IP6_FRAG_HDR) + 8)
		return;

	if (mtu > IF_MTU)
		return;

	in6_hostcache_update(&pip6h->dst, mtu);
}

#endif	/* of #if NUM_IN6_HOSTCACHE_ENTRY > 0 */

#if NUM_REDIRECT_ROUTE_ENTRY > 0

/*
 *  icmp6_redirect_input -- bZ[W̏
 */

static void
icmp6_redirect_input (T_NET_BUF *input, uint_t off)
{
	T_IP6_HDR		*ip6h;
	T_IN6_ADDR		*gw;
	T_ND_REDIRECT_HDR	*rdh;
	T_ND_OPT_HDR		*opth;
	T_IFNET			*ifp = IF_GET_IFNET();
	bool_t			router, onlink;
	uint_t			lladdr_len = 0;
	uint8_t			*lladdr = NULL;
	uint8_t			nd_opt_off[ND_OPT_OFF_ARRAY_SIZE];

	ip6h = GET_IP6_HDR(input);

	/*
	 *  IP wb_̃`FbNAȉ̏ꍇ͔jB
	 *    EN[JȊO瑗ĂbZ[W
	 *    Ezbv~bg IPV6_MAXHLIM (255) ȊO
	 */
	if (!IN6_IS_ADDR_LINKLOCAL(&ip6h->src) || ip6h->hlim != IPV6_MAXHLIM)
		goto err_ret;

	rdh  = (T_ND_REDIRECT_HDR *)(input->buf + off);

	/* ̏I_AhX}`LXgAhX̏ꍇ͔jB*/
	if (IN6_IS_ADDR_MULTICAST(&rdh->dst))
		goto err_ret;

	/* ^[QbgAhXoH\ɓo^Ă邩`FbNB*/
	if ((gw = in6_rtalloc(ifp, &rdh->dst)) != NULL) {
		/* GW AhXƑMAhXقȂĂΔjB*/
		if (!IN6_ARE_ADDR_EQUAL(gw, &ip6h->src))
			goto err_ret;
	}
	else	/* oH\ɂȂΔjB*/
		goto err_ret;

	router = onlink = false;

	/*
	 *  ^[QbgAhXN[JAhXł΁A
	 *  ^[Qbg̓[^
	 */
	if (IN6_IS_ADDR_LINKLOCAL(&rdh->target))
		router = true;

	/*
	 *  ^[QbgAhXƏI_AhXł΁AIN
	 */
	if (IN6_ARE_ADDR_EQUAL(&rdh->target, &rdh->dst))
		onlink = true;
		
	/*
	 *  [^łAINłȂ΃G[
	 */
	if (!router && !onlink)
		goto err_ret;

	/* ߗגTIvṼItZbgL^B*/
	if (nd6_options(nd_opt_off, input->buf +  off + ND_REDIRECT_HDR_SIZE,
	                            input->len - (off + ND_REDIRECT_HDR_SIZE)) != E_OK)
		goto err_ret;

	/* ߗגTIvV (̃[^̃NAhX) */
	if (nd_opt_off[ND_OPT_OFF_ARRAY_IX(ND_OPT_TARGET_LINKADDR)]) {
		opth = (T_ND_OPT_HDR *)((uint8_t *)(input->buf + off + ND_REDIRECT_HDR_SIZE) +
		                        nd_opt_off[ND_OPT_OFF_ARRAY_IX(ND_OPT_TARGET_LINKADDR)] - 8);
	 	/* : IvVItZbgzɂ́AItZbg + 8 ݒ肳ĂB*/
		lladdr     = (uint8_t *)(opth + 1);
		lladdr_len = (opth->len << 3);
	}

	/*
	 *  lbg[NC^tF[X̃AhXvȂ΃G[
	 */
	if (lladdr && lladdr_len != ((sizeof(T_IF_ADDR) + sizeof(T_ND_OPT_HDR) + 7) & ~7))
		goto err_ret;

	/* ̃[^̃NAhXߗ׃LbVɓo^B*/
	nd6_cache_lladdr(ifp, &rdh->target, (T_IF_ADDR *)lladdr, ND_REDIRECT, 
	                 onlink ? ND_REDIRECT_ONLINK : ND_REDIRECT_ROUTER);

	/* [eBO\ɓo^B*/
	in6_rtredirect(&rdh->target, &rdh->dst, 128, IN_RTF_REDIRECT, TMO_IN_REDIRECT);

	syscall(rel_net_buf(input));
	return;

err_ret:
	NET_COUNT_ICMP6(net_count_nd6[NC_ICMP6_IN_ERR_PACKETS], 1);
	syscall(rel_net_buf(input));
}

#endif	/* of #if NUM_REDIRECT_ROUTE_ENTRY > 0 */

/*
 *  icmp6_input -- ICMP6 ̓͊֐
 */

uint_t
icmp6_input (T_NET_BUF **inputp, uint_t *offp, uint_t *nextp)
{
	T_NET_BUF	*input = *inputp;
	T_IP6_HDR	*ip6h;
	T_ICMP6_HDR	*icmp6h;
	uint_t		len, off = *offp;
	uint8_t		code;

	NET_COUNT_ICMP6(net_count_icmp6[NC_ICMP6_IN_OCTETS],
	               input->len - GET_IF_IP6_HDR_SIZE(input));
	NET_COUNT_ICMP6(net_count_icmp6[NC_ICMP6_IN_PACKETS], 1);
	NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpInMsgs, 1);

	/* ICMP6 wb_̒`FbNB*/
	len  = input->len - off;
	if (len < ICMP6_HDR_SIZE) {
		NET_COUNT_ICMP6(net_count_icmp6[NC_ICMP6_IN_ERR_PACKETS], 1);
		NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpInErrors, 1);
		goto buf_rel;
	}

	ip6h   = GET_IP6_HDR(input);
	icmp6h = GET_ICMP6_HDR(input, off);

	/* `FbNTvZB*/
	if ((in6_cksum(input, IPPROTO_ICMPV6, off, ntohs(ip6h->plen) - (off - IF_IP_HDR_SIZE)) & 0xffff) != 0) {
		NET_COUNT_ICMP6(net_count_icmp6[NC_ICMP6_IN_ERR_PACKETS], 1);
		NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpInErrors, 1);
		goto buf_rel;
	}

	code = icmp6h->code;

	/* bZ[W̌^ɂ蕪򂷂B*/
	switch (icmp6h->type) {

	case ICMP6_DST_UNREACH:			/* 擞Bs\		*/
		NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpInDestUnreachs, 1);
		icmp6_notify_error(input, off);
		break;

	case ICMP6_ECHO_REQUEST:		/* GR[v			*/
		icmp6_echo_request(input, off);
		return IPPROTO_DONE;
		break;

	case ICMP6_ECHO_REPLY:			/* GR[			*/

#ifdef ICMP_CFG_CALLBACK_ECHO_REPLY

		icmp6_echo_reply(input, off);

#endif	/* of #ifdef ICMP_CFG_CALLBACK_ECHO_REPLY */

		break;

	case ND_ROUTER_ADVERT:			/* [^ʒm			*/
		NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpInRouterAdvertisements, 1);
		if (code != 0 || len < ROUTER_ADVERT_HDR_SIZE)
			goto buf_rel;
		nd6_ra_input(input, off);
		return IPPROTO_DONE;
		break;

	case ND_NEIGHBOR_SOLICIT:		/* ߗחv			*/
		NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpInNeighborSolicits, 1);
		if (code != 0 || len < NEIGHBOR_SOLICIT_HDR_SIZE)
			goto buf_rel;
		nd6_ns_input(input, off);
		return IPPROTO_DONE;
		break;

	case ND_NEIGHBOR_ADVERT:		/* ߗגʒm			*/
		NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpInNeighborAdvertisements, 1);
		if (code != 0 || len < NEIGHBOR_ADVERT_HDR_SIZE)
			goto buf_rel;
		nd6_na_input(input, off);
		return IPPROTO_DONE;
		break;

	case ND_REDIRECT:			/* 			*/
		NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpInRedirects, 1);

#if NUM_REDIRECT_ROUTE_ENTRY > 0

		if (code != 0 || len < ND_REDIRECT_HDR_SIZE)
			goto buf_rel;
		icmp6_redirect_input(input, off);
		return IPPROTO_DONE;

#else	/* of #if NUM_REDIRECT_ROUTE_ENTRY > 0 */

		syslog(LOG_WARNING, "[ICMP6] redirect ignored.");

#endif	/* of #if NUM_REDIRECT_ROUTE_ENTRY > 0 */

		break;

	case ICMP6_PACKET_TOO_BIG:		/* pPbg傫B	*/

#if NUM_IN6_HOSTCACHE_ENTRY > 0

		icmp6_mtudisc_update(input, off, ntohl(icmp6h->icmp6_mtu));

#endif	/* of #if NUM_IN6_HOSTCACHE_ENTRY > 0 */

		NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpInPktTooBigs, 1);
		break;

	case ICMP6_TIME_EXCEEDED:		/* TTL 𒴉߂B		*/
		NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpInTimeExcds, 1);
		break;

	case ICMP6_PARAM_PROB:			/* IPv6 wb_sB		*/
		NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpInParmProblems, 1);
		break;

	case MLD_LISTENER_QUERY:		/* }`LXgMҏƉ	*/
	case MLD_LISTENER_REPORT:		/* }`LXgMҕ	*/
	case MLD_LISTENER_DONE:			/* }`LXgMҏI	*/
	case ND_ROUTER_SOLICIT:			/* [^v			*/
	case ICMP6_ROUTER_RENUMBERING:		/* [^ԍĐݒ		*/
	case ICMP6_FQDN_QUERY:			/* FQDN Ɖ			*/
	case ICMP6_FQDN_REPLY:			/* FQDN 			*/
		syslog(LOG_WARNING, "[ICMP6] unsupported type: %d.", icmp6h->type);
		break;

	default:
		syslog(LOG_WARNING, "[ICMP6] unknown type: %d.", icmp6h->type);
		NET_COUNT_ICMP6(net_count_icmp6[NC_ICMP6_IN_ERR_PACKETS], 1);
		NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpInErrors, 1);
		break;
	}

buf_rel:
	syscall(rel_net_buf(input));
	return IPPROTO_DONE;
}

/*
 *  icmp6_error -- ICMP6 G[M֐
 */

void
icmp6_error (T_NET_BUF *input, uint8_t type, uint8_t code, uint32_t param)
{
	T_NET_BUF	*output;
	T_IP6_HDR	*ip6h;
	T_ICMP6_HDR	*icmp6h;
	ER_UINT		off;
	uint_t		next, len;

	ip6h = GET_IP6_HDR(input);

	/*
	 *  AhXA}`LXg̏ꍇ́A
	 *  ȉ̏ȊÔƂ͏sȂB
	 *
	 *    Ef[^O傫B
	 *    EIPv6 wb_̕sŁAIvVFłȂB
	 */
	if (IN6_IS_ADDR_MULTICAST(&ip6h->dst) &&
	    !((type == ICMP6_PACKET_TOO_BIG) ||
	      (type == ICMP6_PARAM_PROB && code == ICMP6_PARAMPROB_OPTION)))
		goto buf_rel;

	/*
	 *  n_AhXAȉ̏ꍇ͏sȂB
	 *
	 *    Ew
	 *    E}`LXg
	 */
	if (IN6_IS_ADDR_UNSPECIFIED(&ip6h->src) ||
	    IN6_IS_ADDR_MULTICAST  (&ip6h->src))
		goto buf_rel;

	/* Ō̃wb_TB*/
	off = ip6_lasthdr(input, 0, IPPROTO_IPV6, &next);

	/*
	 *  ^CvAG[ ICMP6 pPbg̃G[ɂ͕ԓȂB
	 */
	if (off >= 0 && next == IPPROTO_ICMPV6) {
		T_ICMP6_HDR	*icmp6h;

		if (input->len - off < ICMP6_HDR_SIZE)
			goto buf_rel;

		icmp6h = GET_ICMP6_HDR(input, off);
		if (icmp6h->type <  ICMP6_ECHO_REQUEST ||
		    icmp6h->type == ND_REDIRECT)
			goto buf_rel;
	}

	/* DoS Uɑ΂h͖ */

	/*
	 *  ԂbZ[WAICMPv6 ̍őyC[hɒB
	 *  IPV6_MMTU - (IP6_HDR_SIZE + ICMP6_HDR_SIZE)
	 */
	if (input->len - IF_HDR_SIZE > IPV6_MMTU - (IP6_HDR_SIZE + ICMP6_HDR_SIZE))
		len = IPV6_MMTU - (IP6_HDR_SIZE + ICMP6_HDR_SIZE);
	else
		len = input->len - IF_HDR_SIZE;

	/* Mp̃lbg[Nobt@lB*/
	if (in6_get_datagram(&output, len + ICMP6_HDR_SIZE, 0,
	                     &ip6h->src, &in6_addr_unspecified,
	                     IPPROTO_ICMPV6, IPV6_MAXHLIM,
	                     NBA_SEARCH_ASCENT, TMO_ICMP_OUTPUT) != E_OK)
		goto buf_rel;

	/* ICMP6 wb_ݒ肷B*/
 	icmp6h = GET_ICMP6_HDR(output, IF_IP6_ICMP6_HDR_OFFSET);
 	icmp6h->type       = type;
 	icmp6h->code       = code;
 	icmp6h->icmp6_pptr = htonl(param);
 
 	/* G[f[^ݒ肷B*/
 	memcpy(GET_ICMP6_SDU(output, IF_IP6_ICMP6_HDR_OFFSET), (uint8_t *)ip6h, len);

#ifdef SUPPORT_MIB

	switch (type) {
	case ICMP6_DST_UNREACH:
		NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpOutDestUnreachs, 1);
		break;

	case ICMP6_PARAM_PROB:
		NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpOutParmProblems, 1);
		break;

	default:
		break;

	}

#endif	/* of #ifdef SUPPORT_MIB */

	/* MB*/
	icmp6_output(output, IF_IP6_HDR_SIZE);

buf_rel:
	syscall(rel_net_buf(input));
}

#endif /* of #ifdef SUPPORT_INET6 */
