/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: nd6.c,v 1.5 2009/12/24 05:48:16 abe Exp abe $
 */

/*	$FreeBSD: src/sys/netinet6/nd6.c,v 1.20 2002/08/02 20:49:14 rwatson Exp $	*/
/*	$KAME: nd6.c,v 1.144 2001/05/24 07:44:00 itojun Exp $	*/

/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * XXX
 * KAME 970409 note:
 * BSD/OS version heavily modifies this code, related to llinfo.
 * Since we don't have BSD/OS version of net/route.c in our hand,
 * I left the code mostly as it was in 970310.  -- itojun
 */

#include <string.h>

#ifdef TARGET_KERNEL_ASP

#include <kernel.h>
#include <sil.h>
#include "kernel_cfg.h"

#endif	/* of #ifdef TARGET_KERNEL_ASP */

#ifdef TARGET_KERNEL_JSP

#include <s_services.h>
#include <t_services.h>
#include "kernel_id.h"

#endif	/* of #ifdef TARGET_KERNEL_JSP */

#include <tinet_defs.h>
#include <tinet_config.h>

#include <net/if.h>
#include <net/if_loop.h>
#include <net/if_ppp.h>
#include <net/ethernet.h>
#include <net/if_arp.h>
#include <net/ppp_ipcp.h>
#include <net/net.h>
#include <net/net_var.h>
#include <net/net_buf.h>
#include <net/net_timer.h>
#include <net/net_count.h>

#include <netinet/in.h>
#include <netinet/in_var.h>
#include <netinet6/in6.h>
#include <netinet6/in6_var.h>
#include <netinet6/nd6.h>

#include <netinet/ip6.h>
#include <netinet/icmp6.h>
#include <netinet6/ip6_var.h>

#include <net/if6_var.h>

#ifdef SUPPORT_INET6

/*
 *  ߗ׃LbV
 */

static T_LLINFO_ND6 nd6_cache[NUM_ND6_CACHE_ENTRY];

/*
 *  nd6_free -- [^폜B
 */

static void
nd6_free (T_LLINFO_ND6	*ln)
{
	T_DEF_ROUTER	*dr;

	dr = nd6_defrtrlist_lookup(&ln->addr);
	if (dr != NULL) {
		ln->state = ND6_LLINFO_INCOMPLETE;

		/* vtBbNXEXg烋[^폜B*/
		nd6_defrtrlist_del(dr);
	}
}

/*
 *  nd6_timer -- ߗגTǗ^C}[
 */

void
nd6_timer (void)
{
	T_IFNET		*ifp = IF_GET_IFNET();
	T_LLINFO_ND6	*ln;
	SYSTIM		now;
	int_t		ix;

	/* ߗ׃LbV̏ */
	syscall(wai_sem(SEM_ND6_CACHE));
	syscall(get_tim(&now));
	for (ix = NUM_ND6_CACHE_ENTRY; ix -- > 0; ) {
		ln = &nd6_cache[ix];
		if (ln->state >= ND6_LLINFO_NO_STATE && (int32_t)(ln->expire - now) < 0) {
		                                               /* ln->expire < now */

			switch (ln->state) {

			case ND6_LLINFO_INCOMPLETE:	/* 		*/
				if (ln->asked < ND6_MAX_MCAST_QUERY) {
					/*
					 *  }`LXgAhXv̍đ񐔈ȉ̏ꍇ̏
					 */
					ln->asked ++;
					ln->expire = now + ND6_RETRANS_TIME;	/* ߗגTMԊu */
					nd6_ns_output(ifp, &in6_addr_unspecified, &ln->addr, ln, false);
				}
				else  {
					if (ln->hold != NULL) {
						/*
						 *  ŏIIɂ́AۗĂlbg[Nobt@
						 *  ΁AICMP6 ERROR gɕԂƁA
						 *  lbg[Nobt@JB
						 *  A݁Aicmp6_error ̎sŜ߁A
						 *  lbg[Nobt@̊ĴݍsB
						 */
#if 0	/* ۗ */
						icmp6_error(ln->hold, ICMP6_DST_UNREACH,
						                      ICMP6_DST_UNREACH_ADDR, 0);
#endif	/* #if 0 */
						syscall(rel_net_buf(ln->hold));
						ln->hold = NULL;
					}
					nd6_free(ln);
					memset((void*)ln, 0, sizeof(*ln));
				}
				break;

			case ND6_LLINFO_REACHABLE:	/* B\		*/
				if (ln->expire) {
					ln->expire = now + ND6_GCOLLECTION_TIME;
					ln->state = ND6_LLINFO_STALE;
				}
				break;

			case ND6_LLINFO_STALE:		/* B\͖mF	*/
				if (ln->expire) {
					if (ln->hold != NULL) {
						syscall(rel_net_buf(ln->hold));
						ln->hold = NULL;
					}
					nd6_free(ln);
					memset((void*)ln, 0, sizeof(*ln));
				}
				break;

			case ND6_LLINFO_DELAY:		/* B\̊mFҋ@	*/
				ln->asked = 1;
				ln->expire = now + ND6_RETRANS_TIME;		/* ߗגTMԊu */
				ln->state = ND6_LLINFO_PROBE;
				nd6_ns_output(ifp, &ln->addr, &ln->addr, ln, false);
				break;

			case ND6_LLINFO_PROBE:		/* B\mF	*/
				if (ln->asked < ND6_MAX_UCAST_QUERY) {
					/*
					 *  jLXgAhXv̍đ񐔈ȉ̏ꍇ̏
					 */
					ln->asked ++;
					ln->expire += ND6_RETRANS_TIME;	/* ߗגTMԊu */
					nd6_ns_output(ifp, &ln->addr, &ln->addr, ln, false);
				}
				else {
					if (ln->hold != NULL) {
						syscall(rel_net_buf(ln->hold));
						ln->hold = NULL;
					}
					nd6_free(ln);
					memset((void*)ln, 0, sizeof(*ln));
				}
				break;

			}
		}
	}
	syscall(sig_sem(SEM_ND6_CACHE));

	/* fBtHg[^EXg̏ */
	nd6_defrtrlist_timer();

	/* vtBbNXEXg̏ */
	nd6_prelist_timer();

	/* lbg[NC^tF[X̃AhX̏ */
	in6_ifaddr_timer(ifp);

	/*
	 *  B\Ԃ̗LԂ̍XV
	 */
	if ((int32_t)(nd6_recalc_reachtm_interval - now) < 0) {
	           /* nd6_recalc_reachtm_interval < now */
		nd6_recalc_reachtm_interval	= now + ND6_RECALC_REACHTM_INTERVAL;
		nd6_reachable_time		= ND6_CALC_REACH_TIME(nd6_base_reachable_time);
	}
	timeout((callout_func)nd6_timer, NULL, ND6_TIMER_TMO);
}

/*
 *  nd6_get_cache -- ߗ׃LbVlB
 */

const T_LLINFO_ND6 *
nd6_get_cache (void)
{
	return nd6_cache;
}

/*
 *  nd6_ifattach -- ߗגT̏ݒsB
 */

void
nd6_ifattach (T_IFNET *ifp)
{
}

/*
 *  nd6_output_hold -- ߗגTLbVɕۗĂ
 *                     AhX҂̃f[^OΑMB
 *
 *    : Z}tH SEM_ND6_CACHE ɂ胍bNԂŌďoƁB
 */

ER
nd6_output_hold (T_IFNET *ifp, T_LLINFO_ND6 *ln)
{
	SYSTIM now;

	/* AhX҂̃f[^OΑMB*/
	if (ln->hold) {

		/* ^CAEg̏ */
		if (ln->tmout != TMO_FEVR) {

			/*
			 *  ^CAEg̎w肪ivłȂAԂ߂Ă΁A
			 *  o͂ȂŏIB
			 */
			syscall(get_tim(&now));
			if ((int32_t)(ln->tmout - now) < 0) {
			           /* ln->tmout < now */
				syscall(rel_net_buf(ln->hold));
				ln->hold = NULL;
				return E_TMOUT;
			}
		}
				
		nd6_output(ifp, ln->hold, &ln->addr, ln, TMO_FEVR);
		ln->hold = NULL;
	}
	return E_OK;
}

/*
 *  nd6_lookup -- ߗגTLbVTB
 *
 *    : Z}tH SEM_ND6_CACHE ɂ胍bNԂŌďoƁB
 *
 */

T_LLINFO_ND6 *
nd6_lookup (T_IN6_ADDR *addr, bool_t create)
{
	SYSTIM	min = 0xffffffff;
	int_t	ix, fix = -1, mix = -1;

	for (ix = NUM_ND6_CACHE_ENTRY; ix -- > 0; ) {
		if (nd6_cache[ix].state == 0) {
			/* gpGg̃CfbNXL^B*/
			if (fix == -1)
				fix = ix;
		}
		else if (IN6_ARE_ADDR_EQUAL(addr, &nd6_cache[ix].addr)) {
			return &nd6_cache[ix];
		}
		else if ((int32_t)(nd6_cache[ix].expire - min) < 0) {	/* nd6_cache[ix].expire < min */
			/* LŒZGg̃CfbNXL^B*/
			min = nd6_cache[ix].expire;
			mix = ix;
		}
	}

	if (create) {
		if (fix == -1)  {
			if (nd6_cache[mix].hold != NULL) {
				syscall(rel_net_buf(nd6_cache[mix].hold));
			}
			fix = mix;
		}
		syscall(get_tim(&nd6_cache[fix].expire));
		nd6_cache[fix].addr   = *addr;
		nd6_cache[fix].state  = ND6_LLINFO_NO_STATE;
		return &nd6_cache[fix];
	}
	else
		return NULL;
}

/*
 *  nd6_cache_lladdr -- ߗגTLbVɓo^B
 */

T_LLINFO_ND6 *
nd6_cache_lladdr (T_IFNET *ifp, T_IN6_ADDR *from,
                  T_IF_ADDR *lladdr, uint8_t type, uint8_t code)
{
	T_LLINFO_ND6	*ln;
	SYSTIM		now;
	bool_t		newentry, olladdr, llchange, doupdate;
	int_t		newstate = ND6_LLINFO_INCOMPLETE;

	/* AhXwȂ牽ȂB*/
	if (IN6_IS_ADDR_UNSPECIFIED(from))
		return NULL;

	/* ߗ׃LbVɓo^B*/
	syscall(wai_sem(SEM_ND6_CACHE));
	if ((ln = nd6_lookup(from, false)) == NULL) {
		ln = nd6_lookup(from, true);
		newentry = true;
	}
	else
		newentry = false;

	olladdr = ln->state > ND6_LLINFO_INCOMPLETE;
	if (!olladdr || lladdr == NULL)
		llchange = false;
	else if (memcmp(lladdr, &ln->ifaddr, sizeof(T_IF_ADDR)))
		llchange = true;
	else
		llchange = false;

	/*
	 *  ԑJڕ\
	 *
	 *  nd_na_flags
	 *  newnetry olladdr lladdr llchange  (L: lladdr o^)
	 *
	 *      F       F       N       -    (1)
	 *      F       T       N       -    (2)
	 *      F       F       Y       -    (3) L * -> STALE
	 *      F       T       Y       F    (4) L
	 *      F       T       Y       T    (5) L * -> STALE
	 *      T       -       N       -    (6)   * -> NO_STATE
	 *      T       -       Y       -    (7) L * -> STALE
	 */

	/* f[^Nw̃AhXʒmĂ΍XVB*/
	if (lladdr != NULL) {
		ln->ifaddr = *(T_IF_ADDR *)lladdr;
	}

	if (newentry) {
		if (lladdr != NULL)					/* (7) */
			newstate = ND6_LLINFO_STALE;
		else							/* (6) */
			newstate = ND6_LLINFO_NO_STATE;
		doupdate = true;
	}
	else {
		if ((!olladdr && lladdr != NULL) ||			/* (3) */
		    ( olladdr && lladdr != NULL && llchange)) {		/* (5) */
			newstate = ND6_LLINFO_STALE;
			doupdate = true;
		}
		else							/* (1),(2),(4) */
			doupdate = false;
	}

	/* ߗ׃LbVGgXVB*/
	if (doupdate) {
		ln->state = newstate;

		syscall(get_tim(&now));
		if (ln->state == ND6_LLINFO_STALE) {
			ln->expire = now + ND6_GCOLLECTION_TIME;

			/* AhX҂̃f[^OΑMB*/
			nd6_output_hold(ifp, ln);
		}
		else if (ln->state == ND6_LLINFO_INCOMPLETE)
			ln->expire = now;
	}
	syscall(sig_sem(SEM_ND6_CACHE));


	/* [^ʒm̏ */
	switch (type) {

	case ND_NEIGHBOR_SOLICIT:
		if (newentry)
			ln->flags &= ~ND6_LLIF_ROUTER;
		break;

	case ND_REDIRECT:
		if (code == ND_REDIRECT_ROUTER)
			ln->flags |=  ND6_LLIF_ROUTER;
		else if (newentry)
			ln->flags &= ~ND6_LLIF_ROUTER;
		break;

	case ND_ROUTER_SOLICIT:
		ln->flags &= ~ND6_LLIF_ROUTER;
		break;

	case ND_ROUTER_ADVERT:
		if ((!newentry && (olladdr || lladdr != NULL)) ||
		    ( newentry && lladdr))
			ln->flags |=  ND6_LLIF_ROUTER;
		break;
	}

	return ln;
}

/*
 *  nd6_is_addr_neighbor -- w肳ꂽAhX̃m[hꃊNɂ邩`FbNB
 */

bool_t
nd6_is_addr_neighbor (T_IFNET *ifp, T_IN6_ADDR *addr)
{
	if (IN6_IS_ADDR_LINKLOCAL(addr))
		return true;

	if (nd6_onlink_prefix_lookup(addr) != NULL)
		return true;

	if (nd6_lookup(addr, false) != NULL)
		return true;

	return false;
}

/*
 *  nd6_output -- ߗגT̏o͊֐
 *
 *    : Z}tH SEM_ND6_CACHE ɂ胍bNԂŌďoƁB
 */

ER
nd6_output (T_IFNET *ifp, T_NET_BUF *output, T_IN6_ADDR *dst, T_LLINFO_ND6 *ln, TMO tmout)
{
	ER	error = E_OK;
	SYSTIM	now;

	/*
	 *  ĐAhX}`LXgAߗ׃LbV
	 *  sv̏ꍇ͒ɑMB
	 */
	if (!(IN6_IS_ADDR_MULTICAST(dst) || !IF_IN6_NEED_CACHE(ifp))) {
		if (ln == NULL) {
			/* ߗ׃LbV`̏ꍇ */
			if (nd6_is_addr_neighbor(ifp, dst)) {
				/*
				 *  w肳ꂽAhX̃m[hꃊNɂ鎞́A
				 *  ߗ׃LbVTA`̏ꍇ͓o^B
				 */
				ln = nd6_lookup(dst, true);
			}
			else {
				error = E_CLS;
				goto err_ret;
			}
		}

		/*
		 *  ߗ׃LbV̏ԂAf[^Nw̃AhXĂĂA
		 *  B\mFĂȂƂ́ABs\ʒmJnB
		 */
		if (ln->state == ND6_LLINFO_STALE) {
			syscall(get_tim(&now));
			ln->expire = now + ND6_DELAY_TIME;
			ln->asked = 0;
			ln->state = ND6_LLINFO_DELAY;
		}

		/*
		 *  ߗ׃LbV̏ԂAf[^Nw̃AhX̏ꍇ
		 *  ߗגTsB
		 */
		if (ln->state <= ND6_LLINFO_INCOMPLETE) {

			/* ^CAEg̎w肪|[OȂ^CAEgŏIB*/
			if (tmout == TMO_POL) {
				error = E_TMOUT;
				goto err_ret;
			}

			if (ln->state == ND6_LLINFO_NO_STATE)
				ln->state = ND6_LLINFO_INCOMPLETE;

			/* łɁÃlbg[Nobt@΁AJB*/
			if (ln->hold != NULL) {
				syscall(rel_net_buf(ln->hold));
			}

			/*
			 *  MyfBOB
			 *  IF Ńlbg[Nobt@JȂtOݒ肳ĂƂ́A
			 *  MyfBOȂB
			 */
			if ((output->flags & NB_FLG_NOREL_IFOUT) == 0) {
				ln->hold = output;

				/* ^CAEg̐ݒ */
				if (tmout == TMO_FEVR)
					ln->tmout = tmout;
				else {
					syscall(get_tim(&now));
					ln->tmout = now + tmout;
				}
			}
			else {
				output->flags &= ~NB_FLG_NOREL_IFOUT;
				syscall(get_tim(&now));
				ln->tmout = now + tmout;
			}

			if (ln->expire) {
				if (ln->asked < ND6_MAX_MCAST_QUERY) {
					syscall(get_tim(&now));
					if ((int32_t)(ln->expire - now) < 0) {
					           /* ln->expire < now */
						ln->expire += ND6_RETRANS_TIME;	/* ߗגTMԊu */
						ln->asked ++;
						nd6_ns_output(ifp, &in6_addr_unspecified, dst, ln, false);
					}
				}
			}
			return error;
		}
	}

	/*
	 *  doꂽC^tF[Xɂ͏o͂ȂB
	 */
	if ((ifp->flags & ND6_IFF_IFDISABLED) != 0) {
		return E_OK;
	}

	IF_SET_PROTO(output, IF_PROTO_IPV6);
	error = IF_OUTPUT(output, dst, ln ? & ln->ifaddr : NULL, tmout);
	return error;

err_ret:
	syscall(rel_net_buf(output));
	return error;
}

/*
 *  nd6_storelladdr -- o͂lbg[NC^tF[X̃AhXԂB
 */

ER
nd6_storelladdr (T_IF_ADDR *out, T_IN6_ADDR *dst, T_IF_ADDR *ifa)
{
	if (IN6_IS_ADDR_MULTICAST(dst)) {
		IF_IN6_RESOLVE_MULTICAST(out, dst);
	}
	else {
		*out = *ifa;
	}

	return E_OK;
}

/*
 *  nd6_option -- ߗגTIvV̏
 *
 *    : IvVItZbgzɂ́AItZbg + 8 ݒ肳ĂB
 */

ER
nd6_options (uint8_t *opt, void *nh, uint_t len)
{
	T_ND_OPT_HDR	*opth;
	ER		error = E_OK;
	int_t		pi_count = 0;	/* vtBbNX̌ */

	opth = (T_ND_OPT_HDR *)nh;
	memset(opt, 0, ND_OPT_OFF_ARRAY_SIZE);

	while (error == E_OK && ((uint8_t *)opth - (uint8_t *)nh) < (256 - 8) && len > 0) {

		/* IvV 0 ̎́AsȃIvVƂďB*/
		if (opth->len == 0) {
			error = E_PAR;
			break;
		}

		/* IvṼ^Cvɂ蕪򂷂B*/
		switch (opth->type) {
		case ND_OPT_SOURCE_LINKADDR:		/* Mlbg[NC^tF[X̃AhX	*/
		case ND_OPT_TARGET_LINKADDR:		/* Ώۃlbg[NC^tF[X̃AhX	*/
		case ND_OPT_REDIRECTED_HEADER:		/* _CNgEwb_				*/
		case ND_OPT_MTU:			/* MTU						*/
			if (opt[ND_OPT_OFF_ARRAY_IX(opth->type)]) {
				/* vtBbNXȊO̓IvVw肳ĂB*/
				error = E_PAR;
			}
			else {
				opt[ND_OPT_OFF_ARRAY_IX(opth->type)] = (uint8_t *)opth - (uint8_t *)nh + 8;
			}
			break;
		case ND_OPT_PREFIX_INFORMATION:		/* vtBbNX				*/
			if (!opt[ND_OPT_OFF_ARRAY_IX(ND_OPT_PREFIX_INFORMATION)]) {
				/*
				 *  vtBbNX͍ŏɌꂽItZbĝ݋L^B
				 */
				opt[ND_OPT_OFF_ARRAY_IX(opth->type)] = (uint8_t *)opth - (uint8_t *)nh + 8;
			}
			pi_count ++;
			break;
		default:
			/*
			 *  `vgRւ̊gɑΉ邽߁A
			 *  FłȂIvV͒PɖA𑱍sB
			 */
			break;
		}
		len -= opth->len << 3;		/* IvV̒Pʂ 8 oCg */
		opth = (T_ND_OPT_HDR *)((uint8_t *)opth + (opth->len << 3));
	}

	opt[ND_OPT_OFF_ARRAY_IX(ND_OPT_PREFIX_INFO_COUNT)] = pi_count;
	return error;
}

#endif /* of #ifdef SUPPORT_INET6 */
