unit Unit1;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes,
  System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Dialogs, FMX.Ani, FMX.Layouts,
  FMX.Gestures,
  FMX.StdCtrls, FMX.TreeView, FMX.ListBox, FMX.Controls.Presentation, FMX.Edit,
  FMX.EditBox, FMX.SpinBox, FMX.Graphics, System.Math, FMX.Effects,
  FMX.Filter.Effects;

type
  TForm1 = class(TForm)
    ToolbarHolder: TLayout;
    ToolbarPopup: TPopup;
    ToolbarPopupAnimation: TFloatAnimation;
    ToolBar1: TToolBar;
    ToolbarApplyButton: TButton;
    ToolbarCloseButton: TButton;
    ToolbarAddButton: TButton;
    Panel1: TPanel;
    Button2: TButton;
    Button3: TButton;
    CheckBox1: TCheckBox;
    Label1: TLabel;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    OpenDialog1: TOpenDialog;
    ListBox1: TListBox;
    Button1: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    SpinBox1: TSpinBox;
    SpinBox2: TSpinBox;
    Button11: TButton;
    Button12: TButton;
    SpinBox3: TSpinBox;
    Label2: TLabel;
    ImageControl1: TImageControl;
    PathLabel1: TPathLabel;
    Button9: TButton;
    Label3: TLabel;
    procedure ToolbarCloseButtonClick(Sender: TObject);
    procedure FormGesture(Sender: TObject; const EventInfo: TGestureEventInfo;
      var Handled: Boolean);
    procedure FormKeyDown(Sender: TObject; var Key: Word; var KeyChar: Char;
      Shift: TShiftState);
    procedure Button3Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ListBox1Change(Sender: TObject);
    procedure FormPaint(Sender: TObject; Canvas: TCanvas; const ARect: TRectF);
    procedure Button4Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure SpinBox3Change(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Single);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Single);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Single);
    procedure Button12Click(Sender: TObject);
  private
    FGestureOrigin: TPointF;
    FGestureInProgress: Boolean;
    MySize: Extended;
    MyRect: TRectF;
    Downed: Boolean;
    St, Gt: TPointF;
    Angle: Single;
    procedure TrimImage;
    function CalMyRect(Size: Extended): TRectF;
    { private 錾 }
    procedure ShowToolbar(AShow: Boolean);
  public
    { public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.fmx}

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word; var KeyChar: Char;
  Shift: TShiftState);
begin
  if Key = vkEscape then
    ShowToolbar(not ToolbarPopup.IsOpen);
end;

procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Single);
begin
  if RadioButton2.IsChecked = true then
  begin
    Downed := true;
    St := PointF(X, Y);
  end;
end;

procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Single);
begin
  if (RadioButton2.IsChecked = true) and (Downed = true) then
  begin
    Gt := PointF(X, Y);
    Invalidate;
  end;
end;

procedure TForm1.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Single);
var
  i: Single;
begin
  if RadioButton2.IsChecked = true then
  begin
    Downed := false;
    if St.X <> X then
    begin
      if X > St.X then
        i := -GradToDeg(50 * (Y - St.Y) / (X - St.X))
      else
        i := -GradToDeg(50 * (St.Y - Y) / (St.X - X));
      ImageControl1.Bitmap.Rotate(i);
      Angle := Angle + i;
    end;
    Invalidate;
  end;
end;

procedure TForm1.FormPaint(Sender: TObject; Canvas: TCanvas;
  const ARect: TRectF);
var
  s, t: TRectF;
  i, j: Extended;
begin
  if ImageControl1.Bitmap.IsEmpty = true then
    Exit;
  if MyRect.Width > 500 then
  begin
    if MyRect.Width > ImageControl1.Bitmap.Width + 200 then
    begin
      i := Floor(ImageControl1.Bitmap.Width / 127);
      SpinBox3.Value := i;
      MyRect := CalMyRect(i);
    end;
    if (MyRect.Width + 500 > ImageControl1.Bitmap.Width) or
      (MyRect.Height + 500 > ImageControl1.Bitmap.Height) then
      Canvas.FillRect(RectF(0, 0, 2 * 350, 2 * 350), 0, 0, [], 1);
    i := MyRect.Left;
    j := MyRect.Top;
    s := RectF(0, 0, 350, 350);
    t := RectF(i - 250, j - 250, i + 100, j + 100);
    Canvas.DrawBitmap(ImageControl1.Bitmap, t, s, 1, true);
    i := MyRect.Right;
    s := RectF(350, 0, 350 * 2, 350);
    t := RectF(i - 100, j - 250, i + 250, j + 100);
    Canvas.DrawBitmap(ImageControl1.Bitmap, t, s, 1, true);
    i := MyRect.Left;
    j := MyRect.Bottom;
    s := RectF(0, 350, 350, 350 * 2);
    t := RectF(i - 250, j - 100, i + 100, j + 250);
    Canvas.DrawBitmap(ImageControl1.Bitmap, t, s, 1, true);
    i := MyRect.Right;
    s := RectF(350, 350, 350 * 2, 350 * 2);
    t := RectF(i - 100, j - 100, i + 250, j + 250);
    Canvas.DrawBitmap(ImageControl1.Bitmap, t, s, 1, true);
    Canvas.DrawDashRect(RectF(250, 250, 450, 450), 0, 0, [], 1,
      TAlphaColors.Black);
  end
  else
  begin
    i := (ImageControl1.Bitmap.Width - 2 * 350) / 2;
    j := (ImageControl1.Bitmap.Height - 2 * 350) / 2;
    s := RectF(i, j, i + 2 * 350, j + 2 * 350);
    Canvas.DrawBitmap(ImageControl1.Bitmap, s,
      RectF(0, 0, 2 * 350, 2 * 350), 1, true);
    i := (2 * 350 - MyRect.Width) / 2;
    j := (2 * 350 - MyRect.Height) / 2;
    Canvas.DrawDashRect(RectF(i, j, 2 * 350 - i, 2 * 350 - j), 0, 0, [], 1,
      TAlphaColors.Black);
  end;
  if (RadioButton2.IsChecked = true) and (Downed = true) then
    Canvas.DrawLine(St, Gt, 0.5);
end;

procedure TForm1.ListBox1Change(Sender: TObject);
var
  s: string;
begin
  s := ListBox1.Items[ListBox1.ItemIndex];
  Button12Click(Sender);
  ImageControl1.Bitmap.LoadFromFile(s);
  Caption := s;
  MyRect := CalMyRect(SpinBox3.Value);
  Invalidate;
end;

procedure TForm1.ToolbarCloseButtonClick(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TForm1.TrimImage;
var
  s: TBitmap;
  t: TRect;
begin
  t.Left:=Floor(MyRect.Left);
  t.Right:=Floor(MyRect.Right);
  t.Top:=Floor(MyRect.Top);
  t.Bottom:=Floor(MyRect.Bottom);
  s:=TBitmap.Create;
  try
    s.Width:=t.Width;
    s.Height:=t.Height;
    s.CopyFromBitmap(ImageControl1.Bitmap,t,0,0);
    s.SaveToFile(Label3.Text + '\' + ExtractFileName(ListBox1.Items[ListBox1.ItemIndex]));
  finally
    s.Free;
  end;
end;

procedure TForm1.Button11Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Button12Click(Sender: TObject);
begin
  ImageControl1.Bitmap.Rotate(-Angle);
  Angle := 0;
  if Sender = Button12 then
    Invalidate;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if ListBox1.ItemIndex > -1 then
  begin
    if (Sender = Button1) and (DirectoryExists(Label3.Text) = false) then
    begin
      Button9Click(Sender);
      if DirectoryExists(Label3.Text) = false then
        Exit;
    end;
    if Sender = Button1 then
      if (CheckBox1.IsChecked = false) or
        (FileExists(Label3.Text + '\' + ExtractFileName(ListBox1.Items
        [ListBox1.ItemIndex])) = false) then
        TrimImage
      else if MessageDlg('Assign File ?', TMsgDlgType.mtConfirmation,
        mbOKCancel, 0) = mrOK then
        TrimImage;
    if ListBox1.ItemIndex < ListBox1.Items.Count - 1 then
      ListBox1.ItemIndex := ListBox1.ItemIndex + 1;
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  if OpenDialog1.Execute = true then
  begin
    ListBox1.Items.Assign(OpenDialog1.Files);
    if ListBox1.Items.Count > 0 then
      ListBox1.ItemIndex := 0;
  end;
end;

procedure TForm1.Button4Click(Sender: TObject);
var
  i: Single;
begin
  if Sender = Button4 then
    i := SpinBox1.Value
  else
    i := -SpinBox1.Value;
  MyRect.Top := MyRect.Top - i;
  MyRect.Bottom := MyRect.Bottom - i;
  Invalidate;
end;

procedure TForm1.Button7Click(Sender: TObject);
var
  i: Single;
begin
  if Sender = Button7 then
    i := SpinBox1.Value
  else
    i := -SpinBox1.Value;
  MyRect.Left := MyRect.Left - i;
  MyRect.Right := MyRect.Right - i;
  Invalidate;
end;

procedure TForm1.Button8Click(Sender: TObject);
var
  i: Extended;
begin
  if ImageControl1.Bitmap.IsEmpty = true then
    Exit;
  MyRect := CalMyRect(20);
  if MyRect.Width > ImageControl1.Bitmap.Width + 200 then
  begin
    i := ImageControl1.Bitmap.Width / 127;
    if i < 1 then
      MySize := 1
    else
      MySize := Floor(i);
    SpinBox3.Value := MySize;
    MyRect := CalMyRect(MySize);
  end
  else
  begin
    MySize := 20;
    SpinBox3.Value := 20;
  end;
  Invalidate;
end;

procedure TForm1.Button9Click(Sender: TObject);
var
  s, t: string;
begin
  GetDir(0, t);
  if SelectDirectory('Save Directory', t, s) = true then
  begin
    Label3.Text := s;
  end;
  if DirectoryExists(s) = false then
    Showmessage('JȂfBNggpĂ܂');
end;

function TForm1.CalMyRect(Size: Extended): TRectF;
var
  i, j, m, n: Extended;
const
  a = 127;
  b = 89;
begin
  i := Size * a;
  j := Size * b;
  m := (ImageControl1.Bitmap.Width - i) / 2;
  n := (ImageControl1.Bitmap.Height - j) / 2;
  result := RectF(m, n, m + i, n + j);
end;

procedure TForm1.FormGesture(Sender: TObject;
  const EventInfo: TGestureEventInfo; var Handled: Boolean);
var
  DX, DY: Single;
begin
  if EventInfo.GestureID = igiPan then
  begin
    if (TInteractiveGestureFlag.gfBegin in EventInfo.Flags) and
      ((Sender = ToolbarPopup) or (EventInfo.Location.Y > (ClientHeight - 70)))
    then
    begin
      FGestureOrigin := EventInfo.Location;
      FGestureInProgress := true;
    end;

    if FGestureInProgress and (TInteractiveGestureFlag.gfEnd in EventInfo.Flags)
    then
    begin
      FGestureInProgress := false;
      DX := EventInfo.Location.X - FGestureOrigin.X;
      DY := EventInfo.Location.Y - FGestureOrigin.Y;
      if (Abs(DY) > Abs(DX)) then
        ShowToolbar(DY < 0);
    end;
  end
end;

procedure TForm1.ShowToolbar(AShow: Boolean);
begin
  ToolbarPopup.Width := ClientWidth;
  ToolbarPopup.PlacementRectangle.Rect :=
    TRectF.Create(0, ClientHeight - ToolbarPopup.Height, ClientWidth - 1,
    ClientHeight - 1);
  ToolbarPopupAnimation.StartValue := ToolbarPopup.Height;
  ToolbarPopupAnimation.StopValue := 0;

  ToolbarPopup.IsOpen := AShow;
end;

procedure TForm1.SpinBox3Change(Sender: TObject);
begin
  if ((SpinBox3.Value > MySize) and (ImageControl1.Width > MyRect.Width)) or
    (SpinBox3.Value < MySize) then
  begin
    MySize := SpinBox3.Value;
    MyRect := CalMyRect(SpinBox3.Value);
  end
  else
  begin
    MySize := SpinBox3.Value;
    MyRect := CalMyRect(MySize);
  end;
  Invalidate;
end;

end.
