from PyQt4 import QtCore, QtGui

class TwitturnSeachingLineEdit(QtGui.QLineEdit):
    def setTreeWidget(self, treeWidget):
        self.treeWidget = treeWidget
    def setSearchTab(self, searchTab):
        self.searchTab = searchTab
    def keyPressEvent(self, keyEvent):
        if keyEvent.key() == QtCore.Qt.Key_Escape:
            self.setVisible(False)
        if keyEvent.key() in (
                QtCore.Qt.Key_Return,
                QtCore.Qt.Key_Enter):
            self.doSearching()
        QtGui.QLineEdit.keyPressEvent(self, keyEvent)
    def doSearching(self):
            self.searchTab.treeWidget.clear()
            rx = QtCore.QRegExp( 
                    self.text(), 
                    QtCore.Qt.CaseInsensitive,
                    QtCore.QRegExp.RegExp2
                    )
            for i in range(self.treeWidget.topLevelItemCount()):
                item = self.treeWidget.topLevelItem(i)
                for c in [1,2]:
                    if not (-1 == rx.indexIn( item.text(c))):
                        self.searchTab.treeWidget.addTopLevelItem(
                                item.clone())
                        break
            self.setVisible(False)
            self.searchTab.changeThisTab()

