from PyQt4 import QtNetwork
class TinyURLEncoder(QtNetwork.QHttp):
    def __init__(self, parent=None):
        QtNetwork.QHttp.__init__(self, parent)

        self.rxURL = QtCore.QRegExp("(https?:\/\/[-_.!~*'()a-zA-Z0-9;/?:&=+$,%#]+)")
        self.url = QtCore.QUrl()
        self.setHost("tinyurl.com")
        self.url.setQueryDelimiters("=",";")
        self.encodeURLQueue = []
        self.encodedURLs = []
        self.progressDialog = QtGui.QProgressDialog(
                self.tr("Waiting response from TinyURL..."),
                self.tr("&Cancel"),
                0,
                100,
                form.textEdit)
        self.progressDialog.setWindowTitle( self.tr("TinyURLEncoder"))
        self.progressDialog.setWindowModality(QtCore.Qt.WindowModal)
        self.connect(self.progressDialog,
                QtCore.SIGNAL("canceled()"),
                self.cancel)
        self.connect(self,
                QtCore.SIGNAL("parseDone"),
                self.queryNext)
        self.connect(self, QtCore.SIGNAL("done(bool)"), self.done)

    def done(self, error):
        self.url.clear()
        print "done"
        if not error and self.lastResponse().statusCode() == 200:
            self.parse()
            self.emit(QtCore.SIGNAL("parseDone"))

    def parse(self):
        byteArray = self.readAll()
        self.encodedURLs.append(QtCore.QString(byteArray))
        print QtCore.QString(byteArray).toAscii()
    def queryEncoding(self, url):
        self.url.setPath('/api-create.php')
        self.url.addQueryItem('url', url)
        return self.get()
    def get(self):
        print self.url.toString()
        return QtNetwork.QHttp.get(self, self.url.toString())

    def encode(self, urls):
        if len(urls) == 0:
            return
        print urls
        self.encodeURLQueue = urls
        print self.encodeURLQueue
        self.progressDialog.setMaximum(len(self.encodeURLQueue))
        self.progressDialog.setValue(0)
        self.progressDialog.show()
        self.queryEncoding(
                QtCore.QString(
                    QtCore.QUrl.toPercentEncoding(
                        self.encodeURLQueue.pop(0))))

    def queryNext(self):
        self.progressDialog.setValue( self.progressDialog.value() + 1)
        if not len(self.encodeURLQueue) == 0:
            self.queryEncoding(self.encodeURLQueue.pop(0))
        else:
            self.applyEncodedURLs()
            self.progressDialog.close()
    def applyEncodedURLs(self):
        str = form.textEdit.toPlainText()
        retStr = QtCore.QString()
        head = self.rxURL.indexIn(str, 0)
        retStr += str.mid(0, head)
        while True:
            if head == -1:
                break;
            url = self.rxURL.cap()
            retStr += self.encodedURLs.pop(0)
            tail = head + self.rxURL.matchedLength()

            head = self.rxURL.indexIn(str, tail)
            len = head - tail
            if len < -1:
                retStr += str.mid(tail, -1)
            else:
                retStr += str.mid(tail, len)
        form.textEdit.setText(retStr)
        return retStr

    def cancel(self):
        self.abort()
        self.url.clear()
        self.encodedURLs[:] = []

        print "Canceled"

    def encodeAllURL(self):
        str = form.textEdit.toPlainText()
        pos = self.rxURL.indexIn(str)
        head = self.rxURL.indexIn(str, 0)
        urls = []
        while True:
            if head == -1:
                break;
            urls.append(self.rxURL.cap())
            tail = head + self.rxURL.matchedLength()
            head = self.rxURL.indexIn(str, tail)
            len = head - tail
        self.encode(urls)

tinyURLEncoder = TinyURLEncoder(form)
actionTinyURLEncode = QtGui.QAction(
        form.tr("Encode all URL by TinyURL"),
        form.textEdit)
actionTinyURLEncode.setShortcut(
        QtGui.QKeySequence(
            form.tr("Ctrl+L")))
tinyURLEncoder.connect(actionTinyURLEncode,
        QtCore.SIGNAL("triggered()"),
        tinyURLEncoder.encodeAllURL)
form.menu_Edit.addAction(actionTinyURLEncode)

def tinyURLEncoderPopupMenuEvent(e):
    menu = form.textEdit.createStandardContextMenu()
    menu.addAction(actionTinyURLEncode)
    menu.exec_(e.globalPos())

form.textEdit.contextMenuEvent = tinyURLEncoderPopupMenuEvent
