﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading;
using System.Windows.Forms;

namespace SkyDriveFolder
{
    public partial class FileListControl : UserControl
    {
        private const int ICON_INDEX_FILE = 0;
        private const int ICON_INDEX_FOLDER = 1;

        private SkyDriveModel _model;

        private SkyDriveFolder _openedFolder;

        public FileListControl()
        {
            InitializeComponent();
        }

        public FileListControl(SkyDriveModel model)
            : this()
        {
            _model = model;

            _model.RequestFolderBeginEvent += new EventHandler<RequestFolderBeginEventArgs>(_model_RequestFolderBeginEvent);
            _model.RequestFolderEndEvent += new EventHandler<RequestFolderEndEventArgs>(_model_RequestFolderEndEvent);
            _model.OpenedFolderEvent += new EventHandler<OpenedFolderEventArgs>(_model_OpenedFolderEvent);
        }

        void _model_OpenedFolderEvent(object sender, OpenedFolderEventArgs e)
        {
            this.Invoke(new MethodInvoker(delegate()
            {
                try
                {
                    _openedFolder = e.OpenedFolder;

                    if (_openedFolder.LastRequestDateTime != null)
                    {
                        fileList.Items.Clear();

                        foreach (SkyDriveFolder folder in _openedFolder.FolderList)
                        {
                            ListViewItem item = new ListViewItem();
                            item.Text = folder.Info.Name;
                            item.SubItems.Add(string.Empty);
                            item.SubItems.Add(folder.Info.DateModified.ToString());
                            item.ImageIndex = ICON_INDEX_FOLDER;

                            fileList.Items.Add(item);
                        }

                        foreach (SkyDriveFile file in _openedFolder.FileList)
                        {
                            ListViewItem item = new ListViewItem();
                            item.Text = file.Info.FullName;
                            item.SubItems.Add(file.Info.Size);
                            item.SubItems.Add(file.Info.DateModified.ToString());
                            item.ImageIndex = ICON_INDEX_FILE;

                            fileList.Items.Add(item);
                        }
                    }
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.ToString());
                    throw ex;
                }
            }));
        }

        void _model_RequestFolderEndEvent(object sender, RequestFolderEndEventArgs e)
        {
            this.Invoke(new MethodInvoker(delegate()
            {
                this.Enabled = true;

                if (e.ParentFolder == _openedFolder)
                {
                    if (_openedFolder.LastRequestDateTime != null)
                    {
                        fileList.Items.Clear();

                        foreach (SkyDriveFolder folder in _openedFolder.FolderList)
                        {
                            ListViewItem item = new ListViewItem();
                            item.SubItems.Add(folder.Info.Name);
                            item.SubItems.Add(string.Empty);
                            item.SubItems.Add("フォルダ");

                            fileList.Items.Add(item);
                        }

                        foreach (SkyDriveFile file in _openedFolder.FileList)
                        {
                            ListViewItem item = new ListViewItem();
                            item.SubItems.Add(file.Info.FullName);
                            item.SubItems.Add(file.Info.Size);
                            item.SubItems.Add("ファイル");

                            fileList.Items.Add(item);
                        }
                    }
                }
            }));
        }

        void _model_RequestFolderBeginEvent(object sender, RequestFolderBeginEventArgs e)
        {
            this.Invoke(new MethodInvoker(delegate()
            {
                this.Enabled = false;
            }));
        }

        private void fileList_DragDrop(object sender, DragEventArgs e)
        {
            List<FileSystemInfo> fsInfoList = new List<FileSystemInfo>();

            string[] paths = (string[])e.Data.GetData(DataFormats.FileDrop, false);

            foreach (string path in paths)
            {
                FileInfo file = new FileInfo(path);
                if (file.Exists)
                {
                    fsInfoList.Add(file);
                }

                DirectoryInfo dir = new DirectoryInfo(path);
                if (dir.Exists)
                {
                    fsInfoList.Add(dir);
                }
            }

            Thread t = new Thread(new ParameterizedThreadStart(DoUploadFile));
            t.Start(fsInfoList);
        }

        private void fileList_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop, false))
            {
                e.Effect = DragDropEffects.Copy;
            }
        }

        private void DoUploadFile(object arg)
        {
            try
            {
                List<FileSystemInfo> fsInfoList = (List<FileSystemInfo>)arg;

                this.Invoke(new MethodInvoker(delegate()
                {
                    this.Enabled = false;
                }));

                _model.UploadFile(_openedFolder, fsInfoList);

                _model.RequestFolder(_openedFolder);

                this.Invoke(new MethodInvoker(delegate()
                {
                    this.Enabled = true;
                }));

                _model.OpenedFolder = _openedFolder;
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
                throw ex;
            }
        }
    }
}
