﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Reflection;
using System.Windows.Forms;
using System.Threading;

using HgCo.WindowsLive.SkyDrive;

namespace SkyDriveFolder
{
    public partial class MainForm : Form
    {
        private SkyDriveModel _model;

        private SplitContainer _container;
        private SigninControl _signinControl;
        private FolderControl _folderControl;
        private FileListControl _fileListControl;

        public MainForm()
        {
            try
            {
                InitializeComponent();

                _model = new SkyDriveModel();
                _model.SigninBeginEvent += new EventHandler<SigninBeginEventArgs>(_model_SigninBeginEvent);
                _model.SigninEndEvent += new EventHandler<SigninEndEventArgs>(_model_SigninEndEvent);
                _model.RequestFolderBeginEvent += new EventHandler<RequestFolderBeginEventArgs>(_model_RequestFolderBeginEvent);
                _model.RequestFolderEndEvent += new EventHandler<RequestFolderEndEventArgs>(_model_RequestFolderEndEvent);
                _model.UploadFileBeginEvent += new EventHandler<UploadFileBeginEventArgs>(_model_UploadFileBeginEvent);
                _model.UploadFileEndEvent += new EventHandler<UploadFileEndEventArgs>(_model_UploadFileEndEvent);
                _model.UploadFileProgressedEvent += new EventHandler<UploadFileProgressedEventArgs>(_model_UploadFileProgressedEvent);

                _signinControl = new SigninControl(_model);
                _signinControl.Dock = DockStyle.Fill;
                mainPanel.Controls.Add(_signinControl);
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
                throw ex;
            }
        }

        void _model_UploadFileProgressedEvent(object sender, UploadFileProgressedEventArgs e)
        {
            this.Invoke(new MethodInvoker(delegate()
            {
                try
                {
                    this.toolStripProgressBar1.Style = ProgressBarStyle.Blocks;
                    this.toolStripProgressBar1.Value = e.ProgressPercentage;
                    this.toolStripStatusLabel1.Text = string.Format("\"{0}\"をアップロードしています({1}%)", e.LocalFile.Name, e.ProgressPercentage);
                    this.Cursor = Cursors.WaitCursor;
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.ToString());
                    throw ex;
                }
            }));
        }

        void _model_UploadFileEndEvent(object sender, UploadFileEndEventArgs e)
        {
            this.Invoke(new MethodInvoker(delegate()
            {
                try
                {
                    this.toolStripProgressBar1.Visible = false;
                    this.toolStripStatusLabel1.Text = string.Empty;
                    this.Cursor = Cursors.Default;
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.ToString());
                    throw ex;
                }
            }));
        }

        void _model_UploadFileBeginEvent(object sender, UploadFileBeginEventArgs e)
        {
            this.Invoke(new MethodInvoker(delegate()
            {
                try
                {
                    this.toolStripProgressBar1.Style = ProgressBarStyle.Marquee;
                    this.toolStripProgressBar1.Visible = true;
                    this.toolStripStatusLabel1.Text = string.Format("\"{0}\"をアップロードしています...", e.LocalFile.Name);
                    this.Cursor = Cursors.WaitCursor;
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.ToString());
                    throw ex;
                }
            }));
        }

        void _model_RequestFolderEndEvent(object sender, RequestFolderEndEventArgs e)
        {
            this.Invoke(new MethodInvoker(delegate()
            {
                try
                {
                    this.toolStripProgressBar1.Visible = false;
                    this.toolStripStatusLabel1.Text = string.Empty;
                    this.Cursor = Cursors.Default;
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.ToString());
                    throw ex;
                }
            }));
        }

        void _model_RequestFolderBeginEvent(object sender, RequestFolderBeginEventArgs e)
        {
            this.Invoke(new MethodInvoker(delegate()
            {
                try
                {
                    this.toolStripProgressBar1.Style = ProgressBarStyle.Marquee;
                    this.toolStripProgressBar1.Visible = true;
                    this.toolStripStatusLabel1.Text = "フォルダを取得しています...";
                    this.Cursor = Cursors.WaitCursor;
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.ToString());
                    throw ex;
                }
            }));
        }

        void _model_SigninEndEvent(object sender, SigninEndEventArgs e)
        {
            this.Invoke(new MethodInvoker(delegate()
            {
                try
                {
                    this.toolStripProgressBar1.Visible = false;
                    this.toolStripStatusLabel1.Text = string.Empty;
                    this.Cursor = Cursors.Default;

                    if (e.Exception == null)
                    {
                        mainPanel.Controls.Remove(_signinControl);
                        _signinControl.Dispose();

                        _container = new SplitContainer();
                        _container.Dock = DockStyle.Fill;

                        _folderControl = new FolderControl(_model);
                        _folderControl.Dock = DockStyle.Fill;
                        _container.Panel1.Controls.Add(_folderControl);

                        _fileListControl = new FileListControl(_model);
                        _fileListControl.Dock = DockStyle.Fill;
                        _container.Panel2.Controls.Add(_fileListControl);

                        mainPanel.Controls.Add(_container);

                        _folderControl.Initialize();
                    }
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.ToString());
                    throw ex;
                }
            }));
        }

        void _model_SigninBeginEvent(object sender, SigninBeginEventArgs e)
        {
            this.Invoke(new MethodInvoker(delegate()
            {
                try
                {
                    this.toolStripProgressBar1.Style = ProgressBarStyle.Marquee;
                    this.toolStripProgressBar1.Visible = true;
                    this.toolStripStatusLabel1.Text = "ログインしています...";
                    this.Cursor = Cursors.WaitCursor;
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.ToString());
                    throw ex;
                }
            }));
        }

        private void createFolderMenuItem_Click(object sender, EventArgs e)
        {
            // TODO: フォルダを作成する。
        }

        private void createFileMenuItem_Click(object sender, EventArgs e)
        {
            // TODO: ファイルを作成する。
        }

        private void deleteMenuItem_Click(object sender, EventArgs e)
        {
            // TODO: 削除する。
        }

        private void renameMenuItem_Click(object sender, EventArgs e)
        {
            // TODO: 名前を変更する。
        }

        private void propertyMenuItem_Click(object sender, EventArgs e)
        {
            // TODO: プロパティを表示する。
        }

        private void closeMenuItem_Click(object sender, EventArgs e)
        {
            // TODO: 閉じる。
        }

        private void cutMenuItem_Click(object sender, EventArgs e)
        {
            // TODO: 切り取る。
        }

        private void copyMenuItem_Click(object sender, EventArgs e)
        {
            // TODO: コピーする。
        }

        private void pasteMenuItem_Click(object sender, EventArgs e)
        {
            // TODO: 貼り付ける。
        }

        private void versionMenuItem_Click(object sender, EventArgs e)
        {
            // TODO: バージョン情報を表示する。
        }

        private void uploadMenuItem_Click(object sender, EventArgs e)
        {
            // TODO: アップロードする。
        }

        private void downloadMenuItem_Click(object sender, EventArgs e)
        {
            // TODO: ダウンロードする。
        }

        private void copyToFolderMenuItem_Click(object sender, EventArgs e)
        {
            // TODO: フォルダへコピーする。
        }

        private void moveToFolderMenuItem_Click(object sender, EventArgs e)
        {
            // TODO: フォルダへ移動する。
        }

        private void largeIconViewMenuItem_Click(object sender, EventArgs e)
        {
            // TODO: 大きいアイコンで表示する。
        }

        private void smallIconViewMenuItem_Click(object sender, EventArgs e)
        {
            // TODO: 小さいアイコンで表示する。
        }

        private void listViewMenuItem_Click(object sender, EventArgs e)
        {
            // TODO: リスト表示する。
        }

        private void detailsViewMenuItem_Click(object sender, EventArgs e)
        {
            // TODO: 詳細表示する。
        }

        private void tileViewMenuItem_Click(object sender, EventArgs e)
        {
            // TODO: タイル表示する。
        }

        private void refreshMenuItem_Click(object sender, EventArgs e)
        {
            // TODO: 最新の情報に更新する。
        }
    }
}
