require "socket"
require "json"
require "./app/vem"

require 'config'



class FEIControl < VEM

    def initialize
        @tcp_port = FEI_TCP_PORT
        @ip_address = FEI_IP_ADDRESS
        @port = TCPSocket.new(@ip_address, @tcp_port)
    end

    def stageseta(data)

        puts "FEI StagesetA"
        send_buf = {
            :method => "stagesetA",
            :X => data["x"],
            :Y => data["y"],
            :Z => data["z"],
            :A => data["a"],
            :B => data["b"]
        }

        socket = TCPSocket.open("192.168.4.129", 2000)
        socket.puts send_buf.to_json
        result = socket.gets.chomp
        arr = result.split(" ")

        current_buf = {
            :X => arr[0],
            :Y => arr[1],
            :Z => arr[2],
            :A => arr[3],
            :B => arr[4]
        }

        return current_buf.to_json
    end

    def StagesetB(data)
        puts "FEI StagesetB"
        puts data
    end

    def magnification(data)
    end

    def spotsize(data)

        puts "FEI spotsize"
        send_buf = {
            :method => "spotsize",
            :spotsize => data["sp"]
        }

        socket = TCPSocket.open("192.168.4.129", 2000)
        socket.puts send_buf.to_json
        result = socket.gets.chomp

        current_buf = {
            :method => "spotsize",
            :spotsize => result
        }

        return current_buf.to_json
    end

    def Brightnesset(data)
        puts "FEI Brightnesset"
        puts data
    end

    def Voltageset(data)
        puts "FEI Voltageset"
        puts data
    end

    def request

        puts "FEI request"

        send_buf = {
            :method => request
        }

        socket = TCPSocket.open("192.168.4.129", 2000)
        socket.puts send_buf.to_json
        result = socket.gets.chomp

        current_buf = {
            :method => "spotsize",
            :spotsize => result
        }

        return current_buf.to_json
    end


end

