require "./vem"

class JEOLControl < VEM
     @@condition = {
         "TEM" => "JEOL",
        "GonioX" => 0,
        "GonioY" => 0,
        "GonioZ" => 0,
        "GonioA" => 0,
        "SpotSizeIndex" => 0,
        "MagIndex" => 0,
        "Obj" => 0,
        "BeamTiltX" => 0,
        "BeamTiltY" => 0,
        "Speed" => 0
    }

    def initialize
    end

    def setStageA(params)
        @@condition["GonioX"] = params["x"]
        @@condition["GonioY"] = params["y"]
        @@condition["GonioZ"] = params["z"]
        @@condition["GonioA"] = params["a"]
        return @@condition.to_json
    end

    def setStageR(params)
    end

    def setSpotSize(params)
        @@condition["SpotSizeIndex"] = params["sps"]
        return @@condition.to_json
    end

    def setMagnification(params)        
        @@condition["MagIndex"] = params["mag"]
        return @@condition.to_json
    end

    def setObj(params)
        @@condition["Obj"] = params["obj"]
        return @@condition.to_json
    end

    def setBeamTilt(params)
        @@condition["BeamTiltX"] = params["btx"]
        @@condition["BeamTiltY"] = params["bty"]
        return @@condition.to_json
    end

    def setSpeed(params)
        @@condition["Speed"] = params["sp"]
        return @@condition.to_json
    end

    def getCondition
        return @@condition.to_json
    end
end

