﻿package vocaloplus.threads 
{
	import com.seacolorswind.dbi.AirDao;
	import jp.seagirl.genius.threads.GeniusThread;
	import org.libspark.thread.threads.utils.FunctionThread;
	import vocaloplus.modules.ISoundModule;
	
	/**
	 * 音声モジュールをロードします。
	 * @author Kazushi Tominaga (Seacolor)
	 * @see vocaloplus.models.SoundHolder
	 * @see mx.events.ModuleEvent.READY
	 */
	public class LoadSoundThread extends GeniusThread
	{
		/**
		 * モジュールの定義情報を格納したデータベースです。
		 */
		protected var _db:AirDao;
		
		/**
		 * コンストラクタです。
		 * @param	db	モジュールの定義情報を格納したデータベースです。
		 * @param	id_or_name モジュールID:int もしくは モジュール名:String
		 */
		public function LoadSoundThread(db:AirDao, id_or_name:Object) {
			if (! (id_or_name is int || id_or_name is String)) throw new ArgumentError();
			trace("constructor(", arguments, ")");
			_db = db;
			data = id_or_name;
		}
		
		private var lmt:LoadModuleThread;
		override protected function run():void
		{
			trace("run");
			if (data == null) throw new ArgumentError();
			lmt = new LoadModuleThread(_db, data, "voice");
			lmt.start();
			lmt.join();
		}

		public function get module():ISoundModule { return lmt.module as ISoundModule; }
		public function play():void {
			if (module != null) module.content.play();
		}
		public function get player():FunctionThread {
			return new FunctionThread(play);
		}
	}
	
}