#include "compiler.h"
#include "scrnmng.h"

SCRNMNG scrnmng;
static SCRNSURF scrnsurf;

void scrnmng_initialize( void )
{
	ZeroMemory( &scrnmng,  sizeof(SCRNMNG)  );
	ZeroMemory( &scrnsurf, sizeof(SCRNSURF) );

	VSUN86_VIDEO_INFO info;
	if ( 0 != Vsun86_GetVideoInfo( &info ) )
		return;

	scrnmng.flag = SCRNFLAG_ENABLE | SCRNFLAG_FULLSCREEN;
	scrnmng.bpp	 = info.bpp;

	scrnsurf.width	= info.width;
	scrnsurf.height	= info.height;
	scrnsurf.bpp	= info.bpp;
	scrnsurf.xalign	= info.bpp >> 3;
	scrnsurf.yalign	= scrnsurf.xalign * scrnsurf.width;
	scrnsurf.ptr	= (UINT8 *)info.vram;
}

void scrnmng_setwidth( int posx, int width )
{
	fprintf( stderr, "[STUB] scrnmng_setwidth( posx=%d, width=%d )\n", posx, width );
}

void scrnmng_setextend( int extend )
{
//	fprintf( stderr, "scrnmng_setextend( extend=%d )\n", extend );
//	scrnsurf.extend = extend;
	(void)extend;
}

void scrnmng_setheight( int posy, int height )
{
	fprintf( stderr, "[STUB] scrnmng_setheight( posy=%d, height=%d )\n", posy, height );
}

const SCRNSURF *scrnmng_surflock( void )
{
//	fprintf( stderr, "[STUB] scrnmng_surflock()\n" );
	return &scrnsurf;
}

void scrnmng_surfunlock( const SCRNSURF *surf )
{
//	fprintf( stderr, "[STUB] scrnmng_surfunlock( surf=%08x )\n", surf );
	Vsun86_BitBlt( surf->ptr );
}
