/*!
******************************************************************************

	@file	acpi.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __ACPI_H__
#define __ACPI_H__

#ifndef _VSUN86_PCSIM

#pragma pack(1)

typedef struct {
	char	sig[8];
	u8		checksum;
	char	oem_id[6];
	u8		revision;
	u32		rsdt_addr;
	u32		len;
	u64		xsdt_addr;
	u8		ext_checksum;
	u8		rsvd[3];
} ACPI_RSDP;

typedef struct {
	char	sig[4];
	u32		len;
	u8		revision;
	u8		checksum;
	char	oem_id[6];
	char	oem_table_id[8];
	u32		oem_revision;
	u32		creator_id;
	u32		creator_revision;
} ACPI_DESC_HEADER;

typedef struct {
	u8		addr_space_id;
	u8		bit_width;
	u8		bit_off;
	u8		access_size;
	u64		addr;
} ACPI_GAS;

typedef struct {
	ACPI_DESC_HEADER	hdr;
	u32					entry[1];
} ACPI_RSDT;

typedef struct {
	ACPI_DESC_HEADER	hdr;
	u32					facs_addr;
	u32					dsdt_addr;
	u8					rsvd;
	u8					pref_pm_prof;
	u16					sci_int;
	u32					smi_cmd;
	u8					acpi_enable;
	u8					acpi_disable;
	u8					s4bios_req;
	u8					pstate_cnt;
	u32					pm1a_evt_blk;
	u32					pm1b_evt_blk;
	u32					pm1a_cnt_blk;
	u32					pm1b_cnt_blk;
	u32					pm2_cnt_blk;
	u32					pm_tmr_blk;
	u32					gpe0_blk;
	u32					gpe1_blk;
	u8					pm1_evt_len;
	u8					pm1_cnt_len;
	u8					pm2_cnt_len;
	u8					pm_tmr_len;
	u8					gpe0_blk_len;
	u8					gpe1_blk_len;
	u8					gpe1_base;
	u8					cst_cnt;
	u16					p_lvl2_lat;
	u16					p_lvl3_lat;
	u16					flush_size;
	u16					flush_stride;
	u8					duty_off;
	u8					duty_width;
	u8					day_alrm;
	u8					mon_alrm;
	u8					century;
	u16					iapc_boot_arch;
	u8					rsvd2;
	union {
		u32				flags;
		struct {
			u32			wbinvd						: 1;
			u32			wbinvd_flush				: 1;
			u32			proc_c1						: 1;
			u32			p_lvl2_up					: 1;
			u32			pwr_button					: 1;
			u32			slp_button					: 1;
			u32			fix_rtc						: 1;
			u32			rtc_s4						: 1;
			u32			tmr_val_ext					: 1;
			u32			dck_cap						: 1;
			u32			reset_reg_sup				: 1;
			u32			sealed_case					: 1;
			u32			headless					: 1;
			u32			cpu_sw_slp					: 1;
			u32			pci_exp_wak					: 1;
			u32			use_platform_clock			: 1;
			u32			s4_rtc_sts_valid			: 1;
			u32			remote_power_on_capable		: 1;
			u32			force_apic_cluster_model	: 1;
			u32			force_apic_phys_dst_mode	: 1;
			u32			rsvd						: 12;
		} f;
	};
	ACPI_GAS			reset_reg;
	u8					reset_val;
	u8					rsvd3[3];
	u64					x_facs_addr;
	u64					x_dsdt_addr;
	ACPI_GAS			x_pm1a_evt_blk;
	ACPI_GAS			x_pm1b_evt_blk;
	ACPI_GAS			x_pm1a_cnt_blk;
	ACPI_GAS			x_pm1b_cnt_blk;
	ACPI_GAS			x_pm2_cnt_blk;
	ACPI_GAS			x_pm_tmr_blk;
	ACPI_GAS			x_gpe0_blk;
	ACPI_GAS			x_gpe1_blk;
} ACPI_FADT;

#define ACPI_PM1_TMR_STS			0x00000001
#define ACPI_PM1_BM_STS				0x00000010
#define ACPI_PM1_GBL_STS			0x00000020
#define ACPI_PM1_PWRBTN_STS			0x00000100
#define ACPI_PM1_SLPBTN_STS			0x00000200
#define ACPI_PM1_RTC_STS			0x00000400
#define ACPI_PM1_PCIEXP_WAKE_STS	0x00004000
#define ACPI_PM1_WAK_STS			0x00008000

#define ACPI_PM1_TMR_EN				0x00000001
#define ACPI_PM1_GBL_EN				0x00000020
#define ACPI_PM1_PWRBTN_EN			0x00000100
#define ACPI_PM1_SLPBTN_EN			0x00000200
#define ACPI_PM1_RTC_EN				0x00000400
#define ACPI_PM1_PCIEXP_WAKE_DIS	0x00004000

typedef struct {
	u64		addr;
	u64		len;
	u32		type;
	u32		ext_attr;
} ACPIBIOS_SMAP;

#define ACPIBIOS_SIG_SMAP	0x534d4150	// 'SMAP'

#define ACPIBIOS_SMAP_TYPE_RAM		1
#define ACPIBIOS_SMAP_TYPE_RSVD		2
#define ACPIBIOS_SMAP_TYPE_ACPI		3
#define ACPIBIOS_SMAP_TYPE_NVS		4
#define ACPIBIOS_SMAP_TYPE_UNUSABLE	5

#pragma pack()

extern bool acpi_init( void );
extern u64	acpi_get_tick_freq( void );
extern u64  acpi_get_tick_count( void );

#endif	//!_VSUN86_PCSIM

#endif //!__ACPI_H__
