/*!
******************************************************************************

	@file	atomic.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __ATOMIC_H__
#define __ATOMIC_H__

inline bool try_lock( volatile int *p )
{
	int	result;

#ifdef	_MSC_VER
	__asm {
		xor				eax, eax;
		mov				ecx, 1;
		mov				edx, dword ptr [p];
		lock cmpxchg	[edx], ecx;
		mov				result, eax;
	}
#else	//!_MSC_VER
	__ASM__( "lock; cmpxchg %1, %2" : "=a"(result) : "r"(1), "m"(*(p)), "0"(0) : "memory" );
#endif	//!_MSC_VER

	return result? false:true;
}

#define lock( p )		while ( !try_lock( p ) )
#define unlock( p )		{ *(p) = 0; }

#endif // !__ATOMIC_H__
