/*!
******************************************************************************

	@file	floppy.cpp

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include "vsun86.h"
#include "fdc.h"
#include "dmac.h"
#include "io.h"
#include "printf.h"

#define FDC_DMA_BUF			NON_CACHED_PTR( _dma_buf, void )
#define FDC_DMA_BUF_SIZE	0x00010000
ALIGN(4096) static u8 _dma_buf[FDC_DMA_BUF_SIZE];

bool floppy_read( u32 disk_id, u32 sector, u16 sector_cnt, void *buf, u32 buf_len )
{
	(void)buf_len;

	if ( disk_id > 0 )
		return false;

	if ( sector >= 2880 )
	{	// 1.44MB FDの場合「1474560 / 512 = 2880」なので、2880セクタしか扱えない
		vmm_printf( VMM_DEBUG, "sector %d >= 2880\n", sector );
		return false;
	}

	if ( sector_cnt >= 0x100 )
		return false;

	// FDCを動かす準備する
	if ( !fdc_prepare( 0 ) )
		return false;

	for ( u32 i=0; i<sector_cnt; i++ )
	{	// 1セクタずつ読み取る
		u32 lba = sector + i;
		const u8 s = (u8)((lba % 18) + 1);
		lba /= 18;
		const u8 h = (u8)(lba & 0x01);
		const u8 c = (u8)(lba >> 1);
//		vmm_printf( VMM_DEBUG, "lba(%08x)->chs(%02x:%02x:%02x) ... ", sector + i, c, h, s );

		// シークする
		if ( !fdc_seek( 0, c, h ) ) {
//			vmm_printf( VMM_DEBUG, "seek error.\n" );
			return false;
		}

		// 1セクタ読み出す
		dmac_enable( DMAC_CH_FDC, virt_to_phys( FDC_DMA_BUF ), 512,
					 DMAC_MODE_DEMAND | DMAC_MODE_READ );
		const bool result = fdc_read_data( 0, c, h, s );
		dmac_disable( DMAC_CH_FDC );
		if ( !result ) {
//			vmm_printf( VMM_DEBUG, "read error.\n" );
			return false;
		}
//		vmm_printf( VMM_DEBUG, "OK.\n" );

		// DMAバッファの内容をコピーする
		memcpy( (u8 *)buf + (512 * i), FDC_DMA_BUF, 512 );
	}

	return true;
}
