/*!
******************************************************************************

	@file	disp.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __DISP_H__
#define __DISP_H__

#include "video.h"

typedef struct {
	bool			enable_text;
	u32				page_bytes;
	const VIDEO *	video;
} DISPLAY;

typedef u32	RGB32;

#define COLOR_NONE		(RGB32)0x00000000
#define COLOR_BLACK		(RGB32)0x00000000
#define COLOR_RED		(RGB32)0x00FF0000
#define COLOR_GREEN		(RGB32)0x0000FF00
#define COLOR_BLUE		(RGB32)0x000000FF
#define COLOR_YELLOW	(RGB32)0x00FFFF00
#define COLOR_GREY		(RGB32)0x00C0C0C0
#define COLOR_WHITE		(RGB32)0x00FFFFFF

extern bool disp_init( void );
extern void disp_enable_text ( void );
extern void disp_disable_text( void );
extern void * disp_lock( void );
extern void disp_unlock( void );
extern u32  disp_get_vram_size( void );
extern int  disp_write_char( int x, int y, int c, RGB32 color );
extern int  disp_draw_text( int x, int y, const char *buf, size_t buf_len, RGB32 color );
extern bool disp_get_video_info( void *p );
extern void disp_bitblt( void *src );
extern void disp_update( int x, int y, int w, int h );
extern void disp_vertical_scroll( int top, int bottom, int scroll_y, RGB32 bgcolor );

#endif // !__DISP_H__
