/*!
******************************************************************************

	@file	dmac.cpp

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include "vsun86.h"
#include "dmac.h"
#include "io.h"

typedef struct {
	u16		page;
	u16		addr;
	u16		cnt;
	u16		mask;
} DMAC_REGS;

const DMAC_REGS dmac_regs[8] =
{
	{ IO_DMAC_CH0_PAGE, IO_DMAC_CH0_ADDR, IO_DMAC_CH0_CNT, IO_DMAC0_MASK },
	{ IO_DMAC_CH1_PAGE, IO_DMAC_CH1_ADDR, IO_DMAC_CH1_CNT, IO_DMAC0_MASK },
	{ IO_DMAC_CH2_PAGE, IO_DMAC_CH2_ADDR, IO_DMAC_CH2_CNT, IO_DMAC0_MASK },
	{ IO_DMAC_CH3_PAGE, IO_DMAC_CH3_ADDR, IO_DMAC_CH3_CNT, IO_DMAC0_MASK },
	{ IO_DMAC_CH4_PAGE, IO_DMAC_CH4_ADDR, IO_DMAC_CH4_CNT, IO_DMAC1_MASK },
	{ IO_DMAC_CH5_PAGE, IO_DMAC_CH5_ADDR, IO_DMAC_CH5_CNT, IO_DMAC1_MASK },
	{ IO_DMAC_CH6_PAGE, IO_DMAC_CH6_ADDR, IO_DMAC_CH6_CNT, IO_DMAC1_MASK },
	{ IO_DMAC_CH7_PAGE, IO_DMAC_CH7_ADDR, IO_DMAC_CH7_CNT, IO_DMAC1_MASK }
};

bool dmac_init( void )
{
	outb( IO_DMAC0_MASTER_CLR, 0x00 );
	outb( IO_DMAC1_MASTER_CLR, 0x00 );

	outb( IO_DMAC1_MODE, DMAC_CH4 | DMAC_MODE_CASCADE );
	outb( IO_DMAC0_MODE, DMAC_CH2 | DMAC_MODE_DEMAND | DMAC_MODE_READ );
	outb( IO_DMAC1_MASK, DMAC_CH4 | DMAC_MASK_CLR );

	return true;
}

void dmac_enable( u8 ch, u32 addr, u16 len, u8 mode )
{
	const DMAC_REGS *regs = &dmac_regs[ch & 0x07];

	if ( ch < 4 ) {
		outb( IO_DMAC0_MASK, ch | DMAC_MASK_CLR );
		outb( IO_DMAC0_MODE, ch | mode );
		outb( IO_DMAC0_CLR_FF, 0x00 );
	}
	else {
		ch &= 0x03;
		outb( IO_DMAC1_MASK, ch | DMAC_MASK_CLR );
		outb( IO_DMAC1_MODE, ch | mode );
		outb( IO_DMAC1_CLR_FF, 0x00 );
	}

	len--;
	outb( regs->cnt,  (u8)(len       ) );
	outb( regs->cnt,  (u8)(len  >>  8) );
	outb( regs->addr, (u8)(addr      ) );
	outb( regs->addr, (u8)(addr >>  8) );
	outb( regs->page, (u8)(addr >> 16) );
	outb( regs->mask, ch | DMAC_MASK_CLR );
}

void dmac_disable( u8 ch )
{
	if ( ch < 4 ) {
		outb( IO_DMAC0_MASK, ch | DMAC_MASK_SET );
	}
	else {
		ch &= 0x03;
		outb( IO_DMAC1_MASK, ch | DMAC_MASK_SET );
	}
}
