/*!
******************************************************************************

	@file	fdc.h

	Copyright (C) 2008 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __FDC_H__
#define __FDC_H__

#define IO_FDC_DOR					0x03F2	// R/W
#define IO_FDC_MSR					0x03F4	// R
#define IO_FDC_FIFO					0x03F5	// R/W
#define IO_FDC_DIR					0x03F7	// R
#define IO_FDC_CCR					0x03F7	// W

#define FDC_DOR_CONTROLLER_RESET	0x04
#define FDC_DOR_DMA_INT_ENABLE		0x08
#define FDC_DOR_MOTOR0_ENABLE		0x10
#define FDC_DOR_MOTOR1_ENABLE		0x20

#define FDC_MSR_DRIVE0_BUSY			0x01
#define FDC_MSR_DRIVE1_BUSY			0x02
#define FDC_MSR_CMD_BUSY			0x10
#define FDC_MSR_NON_DMA				0x20
#define FDC_MSR_DIO					0x40
#define FDC_MSR_DIO_IN				0x40
#define FDC_MSR_DIO_OUT				0x00
#define FDC_MSR_REQ_MASTER			0x80

#define FDC_CMDOPT_MT				0x80
#define FDC_CMDOPT_MFM				0x40
#define FDC_CMDOPT_SK				0x20

#define FDC_CMD_READ_DIAG			0x02
#define FDC_CMD_SPECIFY				0x03
#define FDC_CMD_SENSE_DEV_STATUS	0x04
#define FDC_CMD_WRITE_DATA			0x05
#define FDC_CMD_READ_DATA			0x06
#define FDC_CMD_RECALIBRATE			0x07
#define FDC_CMD_SENSE_INT_STATUS	0x08
#define FDC_CMD_READ_ID				0x0A
#define FDC_CMD_READ_DELETED_DATA	0x0C
#define FDC_CMD_WRITE_ID			0x0D
#define FDC_CMD_SEEK				0x0F

#define FDC_SRT_4MS					0xC0
#define FDC_HUT_16MS				0x01

#define FDC_N_128					0x00
#define FDC_N_256					0x01
#define FDC_N_512					0x02
#define FDC_N_1024					0x03
#define FDC_N_2048					0x04
#define FDC_N_4096					0x05

#define FDC_DRIVE_IGNORE			0xFF

extern bool fdc_init( void );
extern bool fdc_prepare( u8 drive );
extern bool fdc_specify( u8 srt_hut, u8 hlt_nd );
extern bool fdc_read_data( u8 drive, u8 c, u8 h, u8 s );
extern bool fdc_recalibrate( u8 drive );
extern bool fdc_sense_int_status( u8 *buf, size_t buf_len );
extern bool fdc_seek( u8 drive, u8 c, u8 h );

#endif // !__FDC_H__
