/*!
******************************************************************************

	@file	heap.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __HEAP_H__
#define __HEAP_H__

#pragma pack(1)

typedef struct _HEAP_ENTRY {
	u8 *	addr;
	size_t	size;
	struct _HEAP_ENTRY	*next;
	struct _HEAP_ENTRY	*prev;
} HEAP_ENTRY;

#define HEAP_ENTRY_MAX	4096

#pragma pack()

extern void heap_init( void );
extern void *heap_alloc( size_t size );
extern int heap_free( void *ptr );

#endif //!__HEAP_H__
