/*!
******************************************************************************

	@file	pci.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __PCI_H__
#define __PCI_H__

#include "common.h"
#include "irq.h"

#pragma pack(1)

#define IO_PCI_CONFIG_ADDR	0xCF8
#define IO_PCI_CONFIG_DATA	0xCFC

typedef struct {
	u32		dev_addr;
	u16		vendor_id;
	u16		device_id;
	u8		revision_id;
	u8		header_type;
	bool	is_multi_func;
	u8		rsvd;
	u32		class_code;
	u32		base_addr[6];
	u16		subsystem_vendor_id;
	u16		subsystem_id;
	u8		interrupt_line;
	u8		interrupt_pin;
	u8		min_gnt;
	u8		max_lat;
} PCI_DEVICE;

#define PCI_BUS_MAX		256
#define PCI_DEV_MAX		32
#define PCI_FUNC_MAX	8

#define PCI_BUS_SHIFT	16
#define PCI_DEV_SHIFT	11
#define PCI_FUNC_SHIFT	8

#define PCI_BUS_NUMBER(dev)		(((dev)->dev_addr >> PCI_BUS_SHIFT ) & (PCI_BUS_MAX -1))
#define PCI_DEV_NUMBER(dev)		(((dev)->dev_addr >> PCI_DEV_SHIFT ) & (PCI_DEV_MAX -1))
#define PCI_FUNC_NUMBER(dev)	(((dev)->dev_addr >> PCI_FUNC_SHIFT) & (PCI_FUNC_MAX-1))

#define PCI_VENDOR_ATI		0x1002
#define PCI_VENDOR_AMD		0x1022
#define PCI_VENDOR_APPLE	0x106B
#define PCI_VENDOR_REALTEK	0x10EC
#define PCI_VENDOR_VIA		0x1106
#define PCI_VENDOR_VIA_2	0x1412
#define PCI_VENDOR_VMWARE	0x15AD
#define PCI_VENDOR_INTEL	0x8086
#define PCI_VENDOR_INNOTEK	0x80EE

#define PCI_CLASS_TYPE(dev)				((dev)->class_code & 0xFF0000)
#define PCI_CLASS_TYPE_UNCLASSIFIED		0x000000
#define PCI_CLASS_TYPE_MASS_STORAGE		0x010000
#define PCI_CLASS_TYPE_NETWORK			0x020000
#define PCI_CLASS_TYPE_DISPLAY			0x030000
#define PCI_CLASS_TYPE_MULTIMEDIA		0x040000
#define PCI_CLASS_TYPE_MEMORY			0x050000
#define PCI_CLASS_TYPE_BRIDGE			0x060000
#define PCI_CLASS_TYPE_COMMUNICATION	0x070000
#define PCI_CLASS_TYPE_PERIPHERAL		0x080000
#define PCI_CLASS_TYPE_INPUT			0x090000
#define PCI_CLASS_TYPE_DOCK				0x0A0000
#define PCI_CLASS_TYPE_PROCESSOR		0x0B0000
#define PCI_CLASS_TYPE_SERIAL_BUS		0x0C0000
#define PCI_CLASS_TYPE_WIRELESS			0x0D0000
#define PCI_CLASS_TYPE_INTELLIGENT		0x0E0000
#define PCI_CLASS_TYPE_SATELLITE		0x0F0000
#define PCI_CLASS_TYPE_ENCRYPTION		0x100000
#define PCI_CLASS_TYPE_SIG_PROC			0x110000

#define PCI_CLASS_IDE_CONTROLLER		0x010100
#define PCI_CLASS_ETHERNET_ADAPTER		0x020000
#define PCI_CLASS_VGA_CONTROLLER		0x030000
#define PCI_CLASS_MM_VIDEO_CONTROLLER	0x040000
#define PCI_CLASS_MM_AUDIO_CONTROLLER	0x040100
#define PCI_CLASS_TEL_DEVICE			0x040200
#define PCI_CLASS_AUDIO_DEVICE			0x040300
#define PCI_CLASS_HOST_BRIDGE			0x060000
#define PCI_CLASS_ISA_BRIDGE			0x060100
#define PCI_CLASS_PCI_BRIDGE			0x060400
#define PCI_CLASS_PCI_BRIDGE_SUBTRACT	0x060401
#define PCI_CLASS_OTHER_BRIDGE			0x068000
#define PCI_CLASS_SYSTEM_PERIPHERAL		0x088000
#define PCI_CLASS_IEEE1394_CONTROLLER	0x0C0000
#define PCI_CLASS_IEEE1394_OHCI			0x0C0010
#define PCI_CLASS_USB_UHCI_CONTROLLER	0x0C0300
#define PCI_CLASS_USB_OHCI_CONTROLLER	0x0C0310
#define PCI_CLASS_USB_EHCI_CONTROLLER	0x0C0320
#define PCI_CLASS_SMBUS_CONTROLLER		0x0C0500

#define PCI_ADDR_IS_IO(addr)	((addr) & 0x00000001)
#define PCI_ADDR_IS_MEM(addr)	(!PCI_ADDR_IS_IO(addr))

#pragma pack()

extern bool pci_init( void );
extern void pci_write_config( PCI_DEVICE *dev, u8 reg, u32 data );
extern u32  pci_read_config ( PCI_DEVICE *dev, u8 reg );
extern bool pci_irq_register( PCI_DEVICE *dev, IRQ_HANDLER proc, void *param );

#endif // !__PCI_H__
