/*!
******************************************************************************

	@file	vmemdump.cpp

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include "vsun86.h"
#include "shell.h"
#include "uart.h"
#include "cpu.h"
#include "pfemu.h"

#include <stdio.h>

void shell_cmd_vmemdump( void )
{
	VSUN86_VM *vm = pfemu_get_vm();
	if ( vm == NULL )
		return;

	cpu_disable_interrupt();
	{
		puts( "Sending VM memory image ... " );
		uart_send_binary( vm->mem, 0x100000 );	// 下位1MBを転送する
		puts( "finished.\n" );
	}
	cpu_enable_interrupt();
}
