/*!
******************************************************************************

	@file	vmrun.cpp

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include "vsun86.h"
#include "task.h"
#include "shell.h"
#include "disp.h"
#include "pfemu.h"

bool shell_cmd_vmrun( const char *p )
{
	static char args[256];

	if ( p == NULL )
		return false;

	if ( (p[0] == ' ') && (p[1] != '\0') )
		strcpy( args, &p[1] );
	else
		args[0] = '\0';

	if ( !task_create( TASK_ID_VM, "VM", (TASK_PROC)VM_MODULE, args, 65536 ) )
		return false;

	disp_disable_text();
	return true;
}
