/*!
******************************************************************************

	@file	timer.h

	Copyright (C) 2008 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __TIMER_H__
#define __TIMER_H__

#include "task.h"
#include "syscall.h"

typedef bool (CALLBACK *TIMER_HANDLER)( void *args );

typedef struct {
	bool			used;
	TIMER_HANDLER	proc;
	void *			args;
	u32				msec;
	u64				expire_tick;
	bool			realtime;
	TASK_ID			task_id;
} TIMER;

typedef enum {
	MSG_TIMER_BASE = TASK_MSG_BASE( TASK_ID_TIMER ),
	MSG_TIMER_EXPIRED,		// arg1=(timer_id), arg2=(0)
} TIMER_EVENT;

#define TIMER_MAX			64
#define TIMER_ID_INVALID	0xFFFFFFFF

#define TIMER_INTERVAL_1MS	1193
#define TIMER_INTERVAL_10MS	11932

#define rdtsc() 									\
({													\
	u64 _value;										\
	__asm__ __volatile__("rdtsc" : "=A"(_value));	\
	_value;											\
})

#define IO_PIT_CNT0		0x0040
#define IO_PIT_CNT1		0x0041
#define IO_PIT_CNT2		0x0042
#define IO_PIT_CTRL		0x0043

extern bool timer_init( void );
extern u64  timer_get_tick_count( void );
extern bool timer_get_system_time( VSUN86_SYSTEM_TIME *tp );
extern bool timer_get_local_time( VSUN86_SYSTEM_TIME *tp );
extern void timer_rtc_to_system_time( bool rtc_is_local );
extern void timer_task( void *args );
extern u32  timer_add( u32 msec, TIMER_HANDLER proc, void *args, bool realtime, TASK_ID task_id = TASK_ID_INVALID );
extern void timer_del( u32 id );
extern void timer_usleep( u32 usec );

#endif // !__TIMER_H__
