/*!
******************************************************************************

	@file	uart.cpp

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include "vsun86.h"
#include "uart.h"
#include "irq.h"
#include "io.h"
#include "timer.h"
#include "shell.h"
#include "printf.h"

#define UART_POLLING_INTERVAL	50

//static bool uart_irq_handler( u8 irq, void *args );

bool uart_init( u32 baudrate, u8 flags )
{
	if ( baudrate > 115200 )
		return false;

	flags &= ~UART_DLAB;

	// ポートの初期設定を行う
	outb( IO_COM1_LCR, UART_DLAB );		// DLAB=1
	const u16 b = 115200 / baudrate;
	outb( IO_COM1_DLL, (u8)b );
	outb( IO_COM1_DLH, (u8)(b>>8) );
	outb( IO_COM1_LCR, flags );			// DLAB=0
	outb( IO_COM1_MCR, UART_MCR_RTS | UART_MCR_DTR );
	outb( IO_COM1_FCR, UART_FCR_ENABLE | UART_FCR_DMA | UART_FCR_TRIG_1BYTE );
	outb( IO_COM1_FCR, UART_FCR_TX_RESET | UART_FCR_RX_RESET );
	outb( IO_COM1_IER, UART_IER_ERBFI | UART_IER_ELSI );
//	outb( IO_COM1_IER, UART_IER_NONE );

	uart_send( "\e[m\nHello !\n" );

	return true;
}

void uart_task( void *args )
{
	(void)args;

	char cmd_buf[256];
	int  cmd_len = 0;
	bool cmd_exec = false;
	memset( cmd_buf, 0, sizeof(cmd_buf) );

//	if ( !irq_register( IRQ_COM1, IRQ_TRIGGER_LEVEL, uart_irq_handler, NULL ) )
//		abort();

//	// 受信バッファ確認用にタイマハンドラを登録する
//	u32 timer_id_check_fifo = timer_add( UART_POLLING_INTERVAL, NULL, NULL, false, TASK_ID_UART );

	TASK_EVENT e;
	while ( task_wait_event( &e ) )
	{
		switch ( e.msg )
		{
			/*
		case MSG_TIMER_EXPIRED:
			{	// タイマ満了
				if ( e.arg1 == timer_id_check_fifo )
				{	// 受信バッファを確認する
					if ( !cmd_exec ) {
						char c;
						while ( '\0' != (c = uart_recv_char()) ) {
							if ( (c == '\r') && (cmd_len > 0) ) {
								task_send_event( TASK_ID_SHELL, MSG_SHELL_EXEC_CMD, (u32)cmd_buf, 0 );
								cmd_exec = true;
							}
							else if ( c == '\n' )
								continue;
							else
								cmd_buf[cmd_len++] = c;
						}
					}
					timer_id_check_fifo = timer_add( UART_POLLING_INTERVAL, NULL, NULL, false, TASK_ID_UART );
				}
			}
			break;
			*/
		case MSG_UART_RECV:
			{	// キャラクタ受信
				if ( !cmd_exec ) {
					char c;
					while ( '\0' != (c = uart_recv_char()) ) {
						if ( (c == '\r') && (cmd_len > 0) ) {
							task_send_event( TASK_ID_SHELL, MSG_SHELL_EXEC_CMD, (u32)cmd_buf, 0 );
							cmd_exec = true;
						}
						else if ( c == '\n' )
							continue;
						else
							cmd_buf[cmd_len++] = c;
					}
				}
			}
			break;

		case MSG_SHELL_EXEC_FINISHED:
			{	// コマンド実行終了
				memset( cmd_buf, 0, sizeof(cmd_buf) );
				cmd_len = 0;
				cmd_exec = false;
			}
			break;
		}
	}
}

void uart_send_char( char c )
{
	while ( !(inb( IO_COM1_LSR ) & UART_LSR_TEMT) )
		;	// 転送が終わるまでビジーウェイト
	outb( IO_COM1_THR, c );
	while ( !(inb( IO_COM1_LSR ) & UART_LSR_THRE) )
		;	// 転送が終わるまでビジーウェイト
}

void uart_send( const char *str )
{
	for ( u32 i=0; str[i] != '\0'; i++ ) {
		if ( str[i] == '\r' )
			continue;
		else if ( str[i] == '\n' )
			uart_send_char( '\r' );		// CR+LFで送信
		uart_send_char( str[i] );
	}
}

void uart_send_binary( void *p, size_t len )
{
	for ( u32 i=0; i<len; i++ )
		uart_send_char( ((u8 *)p)[i] );
}

char uart_recv_char( void )
{
	if ( !(inb( IO_COM1_LSR ) & UART_LSR_RBF) )
		return '\0';
	return inb( IO_COM1_RBR );
}

/*
bool uart_irq_handler( u8 irq, void *args )
{
	(void)args;

	vmm_printf( VMM_DEBUG, "\nserial: irq %d\n", irq );
	const u8 iir = inb( IO_COM1_IIR );
	switch ( iir & UART_IIR_IID_MASK )
	{
	case UART_IIR_LINE_STATUS:
		{	// Receiver Line Status
			const u8 lsr = inb( IO_COM1_LSR );
			vmm_printf( VMM_DEBUG, "serial: Receiver Line Status = %02x\n", lsr );
		}
		break;

	case UART_IIR_RX:
		{	// Received Data Available
//			if ( inb( IO_COM1_LSR ) & UART_LSR_RBF )
//				task_send_event( TASK_ID_UART, MSG_UART_RECV, 0, 0 );
			while ( uart_recv_char() != '\0' );
		}
		break;

	case UART_IIR_RX_TIMEOUT:
		{	// Character Timeout Indication
		}
		break;

	case UART_IIR_TX_EMPTY:
		{	// Transmitter Holding Register Empty
		}
		break;

	case UART_IIR_MODEM_STATUS:
		{	// MODEM Status
			const u8 msr = inb( IO_COM1_MSR );
			vmm_printf( VMM_DEBUG, "serial: MODEM Status = %02x\n", msr );
		}
		break;
	}

	return true;
}
*/
