/*!
******************************************************************************

	@file	ehci.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __USB_HOST_EHCI_H__
#define __USB_HOST_EHCI_H__

#include "pci.h"

#pragma pack(1)

typedef volatile struct {
	u8		caplength;
	u8		rsvd;
	u16		hciversion;
	u32		hcsparams;
	u32		hccparams;
	u64		hcsp_portroute;
} EHCI_CAP_REGS;

typedef volatile struct {
	u32		usbcmd;
	u32		usbsts;
	u32		usbintr;
	u32		frindex;
	u32		ctrldssegment;
	u32		periodiclistbase;
	u32		asynclistaddr;
	u32		rsvd[9];
	u32		configflag;
	u32		portsc[1];
} EHCI_OP_REGS;

typedef struct {
	u8				id;
	u8				ports;
	EHCI_CAP_REGS *	cap_regs;
	EHCI_OP_REGS *	op_regs;
} EHCI_HCD;

#pragma pack()

#define EHCI_HOST_MAX	16
#define EHCI_PORT_MAX	15

extern bool ehci_init( void );
extern bool ehci_probe( PCI_DEVICE *dev );
extern bool ehci_start( void );

#endif // !__USB_HOST_EHCI_H__
