/*!
******************************************************************************

	@file	uhci.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __USB_HOST_UHCI_H__
#define __USB_HOST_UHCI_H__

#include "pci.h"

#pragma pack(1)

typedef union {
	u32		d[8];
	struct {
		u32		link_ptr;
		u32		act_len		: 11;
		u32		rsvd2		:  5;
		u32		status		:  8;
		u32		ioc			:  1;
		u32		iso_select	:  1;
		u32		low_speed	:  1;
		u32		c_err		:  2;
		u32		spd			:  1;
		u32		rsvd3		:  2;
		u32		pid			:  8;
		u32		dev_addr	:  7;
		u32		endpoint	:  4;
		u32		toggle		:  1;
		u32		rsvd4		:  1;
		u32		max_len		: 11;
		u32		buf_ptr;
	};
} UHCI_TD;

typedef struct {
	u32		qh_link;
	u32		qe_link;
	u32		rsvd[2];
} UHCI_QH;

#define UHCI_QH_INT		0
#define UHCI_QH_CTRL	1
#define UHCI_QH_BULK_R	2
#define UHCI_QH_BULK_W	3
#define UHCI_QH_MAX		4

#define TD_LINK_PTR(addr, vf, term)	(((u32)(addr) & 0xFFFFFFF0) | ((vf) << 2) | (term))
#define QH_LINK_PTR(addr, term)		(((u32)(addr) & 0xFFFFFFF0) | 0x02 | (term))

#define TD_STATUS_ACTIVE			0x80
#define TD_STATUS_STALLED			0x40
#define TD_STATUS_DATA_BUF_ERROR	0x20
#define TD_STATUS_BABBLE_DETECTED	0x10
#define TD_STATUS_NAK_RECEIVED		0x08
#define TD_STATUS_CRC_TIMEOUT_ERR	0x04
#define TD_STATUS_BITSTUFF_ERROR	0x02

#define PID_IN		0x69
#define PID_OUT		0xE1
#define PID_SETUP	0x2D

typedef struct {
	u8			id;
	u8			ports;
	u16			io_base;
	u32			dbg_cnt;
	u32 *		frame_list;
	UHCI_QH *	qh;
} UHCI_HCD;

#define UHCI_HOST_MAX	16
#define UHCI_PORT_MAX	15

#pragma pack()

// uhci.h
extern bool uhci_init( void );
extern bool uhci_probe( PCI_DEVICE *dev );
extern bool uhci_start( void );

// uhci_q.h
extern bool uhci_queue_init( UHCI_HCD *hcd );

#endif // !__USB_HOST_UHCI_H__
