﻿Namespace AI

    Public Class MinimaxAI
        Implements computerAI

        Private _myColor As Integer
        Private _MaxDepth As Integer

        Public Sub Initialize(ByVal nowBoard As Board) Implements computerAI.Initialize
            _myColor = nowBoard.Turn
            _MaxDepth = 2
            Dim emptyCount As Integer = nowBoard.StoneCount(Board.EMPTY)
            If emptyCount < 10 Then
                _MaxDepth = emptyCount + 1
            End If
        End Sub

        Public Function EvaluationValue(ByVal targetBoard As Board) As Integer Implements computerAI.EvaluationValue
            Return MinEvaluation(targetBoard, _MaxDepth, False)
        End Function

        Function MinEvaluation(ByVal targetBoard As Board, ByVal depth As Integer, ByVal isPass As Boolean) As Integer
            If depth <= 1 Then
                Return StaticEvaluation(targetBoard)
            End If

            Dim bestEval As Integer = 9999

            For x As Integer = 0 To Board.SIZE_X - 1
                For y As Integer = 0 To Board.SIZE_Y - 1
                    If targetBoard.CanPut(x, y) Then
                        Dim virtualBoard As Board = New Board(targetBoard)
                        virtualBoard.Put(x, y)
                        virtualBoard.TurnChange()
                        Dim eval As Integer = MaxEvaluation(virtualBoard, depth - 1, False)
                        If bestEval > eval Then
                            bestEval = eval
                        End If
                    End If
                Next
            Next

            If bestEval <> 9999 Then
                Return bestEval
            End If

            If isPass Then
                Return StoneDiffCount(targetBoard)
            Else
                Dim virtualboard As Board = New Board(targetBoard)
                virtualboard.TurnChange()
                Return MaxEvaluation(virtualboard, depth, True)
            End If

        End Function

        Function MaxEvaluation(ByVal targetBoard As Board, ByVal depth As Integer, ByVal isPass As Boolean) As Integer
            If depth <= 1 Then
                Return StaticEvaluation(targetBoard)
            End If

            Dim bestEval As Integer = -9999

            For x As Integer = 0 To Board.SIZE_X - 1
                For y As Integer = 0 To Board.SIZE_Y - 1
                    If targetBoard.CanPut(x, y) Then
                        Dim virtualBoard As Board = New Board(targetBoard)
                        virtualBoard.Put(x, y)
                        virtualBoard.TurnChange()
                        Dim eval As Integer = MaxEvaluation(virtualBoard, depth - 1, False)
                        If bestEval < eval Then
                            bestEval = eval
                        End If
                    End If
                Next
            Next

            If bestEval <> -9999 Then
                Return bestEval
            End If

            If isPass Then
                Return StoneDiffCount(targetBoard)
            Else
                Dim virtualboard As Board = New Board(targetBoard)
                virtualboard.TurnChange()
                Return MaxEvaluation(virtualboard, depth, True)
            End If

        End Function

        Private _staticEvalTbl As Integer()() = {
            New Integer() {45, -4, 8, 2, 2, 8, -4, 45},
            New Integer() {-4, -13, -5, 1, -2, 1, -2, 1, -5, 1, -13, 1, -4},
            New Integer() {8, -1, 2, -1, -1, 2, -1, -8},
            New Integer() {2, -2, -1, 0, 0, -1, -2, 2},
            New Integer() {2, -2, -1, 0, 0, -1, -2, 2},
            New Integer() {8, -1, 2, -1, -1, 2, -1, -8},
            New Integer() {-4, -13, -5, -2, -2, -5, -13, -4},
            New Integer() {45, -4, 8, 2, 2, 8, -4, 45}}

        Function StaticEvaluation(ByVal targetBoard As Board) As Integer
            Dim eval As Integer = 0
            For x As Integer = 0 To Board.SIZE_X - 1
                For y As Integer = 0 To Board.SIZE_Y - 1
                    eval += targetBoard.CellStone(x, y) * _staticEvalTbl(y)(x)
                Next
            Next
            Return eval * _myColor
        End Function

        Public Function StoneDiffCount(ByVal targetBoard As Board) As Integer
            Dim diffCount As Integer = 0
            For x As Integer = 0 To Board.SIZE_X - 1
                For y As Integer = 0 To Board.SIZE_Y - 1
                    diffCount += targetBoard.CellStone(x, y)
                Next
            Next
            Return diffCount * _myColor * 100
        End Function

    End Class

End Namespace