﻿Public Class frmMain
    Private Property CellSize As Integer = 40

    Private _nowBoard As New Board
    Private _computerAIPlayer1 As computerPlayer
    Private _computerAIPlayer2 As computerPlayer

    Public Sub Draw(ByVal g As Graphics, ByVal target As Board)

        Dim X As Integer
        Dim Y As Integer
        Dim BorderPen As New Pen(Color.Black, 2)

        '▼グリッドの描画

        '深緑の四角形
        g.FillRectangle(Brushes.DarkGreen, 0, 0, Board.SIZE_X * CellSize, Board.SIZE_Y * CellSize)

        '縦の9本の線
        For X = 0 To Board.SIZE_X
            g.DrawLine(BorderPen, X * CellSize, 0, X * CellSize, Board.SIZE_Y * CellSize)
        Next

        '横の9本の線
        For Y = 0 To Board.SIZE_Y
            g.DrawLine(BorderPen, 0, Y * CellSize, Board.SIZE_X * CellSize, Y * CellSize)
        Next


        '▼セルの状態を描画
        For Y = 1 To Board.SIZE_Y
            For X = 1 To Board.SIZE_X
                Dim rect As Rectangle
                rect.X = (X - 1) * CellSize + 2
                rect.Y = (Y - 1) * CellSize + 2
                rect.Width = CellSize - 4
                rect.Height = CellSize - 4
                If target.Cells(X, Y) = DiscColor.BLACK Then
                    DrawCell(g, rect, Brushes.Black, Brushes.White)
                ElseIf target.Cells(X, Y) = DiscColor.WHITE Then
                    DrawCell(g, rect, Brushes.White, Brushes.Black)
                End If
            Next
        Next

    End Sub

    Private Sub DrawCell(ByVal g As Graphics, ByVal cellRect As Rectangle, ByVal frontBrush As Brush, ByVal backBrush As Brush)
        cellRect.Y += 2
        g.FillEllipse(backBrush, cellRect)
        cellRect.Y -= 2
        g.FillEllipse(frontBrush, cellRect)
    End Sub


    Private Sub PictureBox1_Paint(ByVal sender As System.Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles PictureBox1.Paint
        CellSize = (PictureBox1.Width - 10) \ 8
        Draw(e.Graphics, _nowBoard)
    End Sub


    Private Sub PictureBox1_MouseClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles PictureBox1.MouseClick

        If _nowBoard.CurrentColor = _computerAIPlayer1.MyColor Then
            Return
        End If
        If _nowBoard.CurrentColor = _computerAIPlayer2.MyColor Then
            Return
        End If

        Dim x As Integer = e.X \ CellSize + 1
        Dim y As Integer = e.Y \ CellSize + 1

        If Not Board.ValidPosition(x, y) Then
            Return
        End If
        If _nowBoard.CanMove(x, y) Then
            _nowBoard.Move(New Point(x, y))
            frmReflesh()
            TurnChangeAndDecideGameWinner()
        End If
    End Sub

    Private Sub frmReflesh()

        FormDispacher.GetInstance.ShowCode(_nowBoard)
        PictureBox1.Invalidate()
    End Sub
    Private Sub TurnChangeAndDecideGameWinner()
        If _nowBoard.IsGameEnd Then
            Dim whiteCount As Integer = _nowBoard.StoneCount(DiscColor.WHITE)
            Dim blackCount As Integer = _nowBoard.StoneCount(DiscColor.BLACK)
            If whiteCount > blackCount Then
                MessageBox.Show(String.Format("{0}対{1}で白の勝ち", whiteCount, blackCount))
            ElseIf whiteCount < blackCount Then
                MessageBox.Show(String.Format("{0}対{1}で黒の勝ち", blackCount, whiteCount))
            Else
                MessageBox.Show(String.Format("{0}対{1}で引き分け", blackCount, whiteCount))
            End If
        ElseIf Not _nowBoard.CanMoveAny() Then
            Dim currentColor As DiscColor = _nowBoard.CurrentColor
            If _nowBoard.CurrentColor <> _computerAIPlayer1.MyColor AndAlso
               _nowBoard.CurrentColor <> _computerAIPlayer2.MyColor Then
                _nowBoard.Pass()
            End If
            If currentColor = DiscColor.WHITE Then
                MessageBox.Show("白は打てません。")
            Else
                MessageBox.Show("黒は打てません。")
            End If

        End If

    End Sub


    Private Sub frmMain_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        FormDispacher.GetInstance.ShowCode(_nowBoard)
        _computerAIPlayer1 = New computerPlayer
        _computerAIPlayer2 = New computerPlayer

        ShowPlayerChange()



    End Sub

    Private Sub BackgroundWorker1_DoWork(ByVal sender As System.Object, ByVal e As System.ComponentModel.DoWorkEventArgs) Handles BackgroundWorker1.DoWork
        While _computerAIPlayer1.MyColor <> DiscColor.EMPTY
            If Not _nowBoard.IsGameEnd Then
                If _nowBoard.CurrentColor = _computerAIPlayer1.MyColor Then
                    _computerAIPlayer1.DoPut(_nowBoard)
                    frmReflesh()
                    TurnChangeAndDecideGameWinner()
                End If
            End If
            Threading.Thread.Sleep(10)
        End While
    End Sub

    Private Sub BackgroundWorker2_DoWork(ByVal sender As System.Object, ByVal e As System.ComponentModel.DoWorkEventArgs) Handles BackgroundWorker2.DoWork
        While _computerAIPlayer2.MyColor <> DiscColor.EMPTY
            If Not _nowBoard.IsGameEnd Then
                If _nowBoard.CurrentColor = _computerAIPlayer2.MyColor Then
                    _computerAIPlayer2.DoPut(_nowBoard)
                    frmReflesh()
                    TurnChangeAndDecideGameWinner()
                End If
            End If
            Threading.Thread.Sleep(10)
        End While
    End Sub

    Private Sub frmMain_SizeChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.SizeChanged
        If Me.Width > Me.Height Then
            PictureBox1.Height = Me.Height - 50
            PictureBox1.Width = Me.Height - 50
        Else
            PictureBox1.Height = Me.Width - 50
            PictureBox1.Width = Me.Width - 50
        End If
        frmReflesh()
    End Sub

    Private Sub btnPlayer_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPlayer.Click
        ShowPlayerChange()
    End Sub

    Private Sub ShowPlayerChange()

        Dim frm As New frmSelect
        frm.PlayerBlack = _computerAIPlayer1
        frm.PlayerWhite = _computerAIPlayer2

        frm.ShowDialog()
        If Not BackgroundWorker1.IsBusy Then
            BackgroundWorker1.RunWorkerAsync()
        End If
        If Not BackgroundWorker2.IsBusy Then
            BackgroundWorker2.RunWorkerAsync()
        End If
    End Sub


    Private Sub btnNew_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnNew.Click
        ShowPlayerChange()
        _nowBoard = New Board
        frmReflesh()
    End Sub

    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click
        If _nowBoard.CanUndo Then
            _nowBoard.Undo()
           frmReflesh()
        End If
    End Sub

    Private Sub Button2_Click(sender As System.Object, e As System.EventArgs) Handles Button2.Click
        If _nowBoard.CanUndo Then
            _nowBoard.Undo()
            If _nowBoard.CanUndo() Then
                _nowBoard.Undo()
            End If
           frmReflesh()
        End If
    End Sub

    Private Sub btnCodes_Click(sender As System.Object, e As System.EventArgs) Handles btnCodes.Click

        FormDispacher.GetInstance.ShowCode(_nowBoard)

    End Sub
End Class
