﻿Imports ReversiGame

Imports Microsoft.VisualStudio.TestTools.UnitTesting

Imports ReversiGame.AI.Level2



'''<summary>
'''EdgeStatTest のテスト クラスです。すべての
'''EdgeStatTest 単体テストをここに含めます
'''</summary>
<TestClass()> _
Public Class EdgeStatTest


    Private testContextInstance As TestContext

    '''<summary>
    '''現在のテストの実行についての情報および機能を
    '''提供するテスト コンテキストを取得または設定します。
    '''</summary>
    Public Property TestContext() As TestContext
        Get
            Return testContextInstance
        End Get
        Set(value As TestContext)
            testContextInstance = Value
        End Set
    End Property

#Region "追加のテスト属性"
    '
    'テストを作成するときに、次の追加属性を使用することができます:
    '
    'クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
    '<ClassInitialize()>  _
    'Public Shared Sub MyClassInitialize(ByVal testContext As TestContext)
    'End Sub
    '
    'クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
    '<ClassCleanup()>  _
    'Public Shared Sub MyClassCleanup()
    'End Sub
    '
    '各テストを実行する前にコードを実行するには、TestInitialize を使用
    '<TestInitialize()>  _
    'Public Sub MyTestInitialize()
    'End Sub
    '
    '各テストを実行した後にコードを実行するには、TestCleanup を使用
    '<TestCleanup()>  _
    'Public Sub MyTestCleanup()
    'End Sub
    '
#End Region


    '''<summary>
    '''GetData のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub GetDataTest()
        Dim target As EdgeStat = New EdgeStat()
        target.GetData(DiscColor.BLACK).CMove = 1
        target.GetData(DiscColor.EMPTY).Mountain = 2
        target.GetData(DiscColor.WHITE).Stable = 4
        Assert.AreEqual(1, target.GetData(DiscColor.BLACK).CMove)
        Assert.AreEqual(2, target.GetData(DiscColor.EMPTY).Mountain)
        Assert.AreEqual(4, target.GetData(DiscColor.WHITE).Stable)
        Assert.AreEqual(0, target.GetData(DiscColor.BLACK).Stable)
    End Sub

    '''<summary>
    '''Add のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub AddTest()
        Dim target As EdgeStat = New EdgeStat()
        target.GetData(DiscColor.BLACK).CMove = 1
        target.GetData(DiscColor.EMPTY).Mountain = 2
        target.GetData(DiscColor.WHITE).Stable = 4
        Dim e As EdgeStat = New EdgeStat
        e.GetData(DiscColor.BLACK).CMove = 3
        e.GetData(DiscColor.EMPTY).Mountain = 5
        e.GetData(DiscColor.WHITE).Stable = 7
        e.GetData(DiscColor.BLACK).Wing = 9
        target.Add(e)
        Assert.AreEqual(0, target(DiscColor.BLACK).Stable)
        Assert.AreEqual(4, target(DiscColor.BLACK).CMove)
        Assert.AreEqual(0, target(DiscColor.BLACK).Mountain)
        Assert.AreEqual(9, target(DiscColor.BLACK).Wing)
        Assert.AreEqual(7, target(DiscColor.EMPTY).Mountain)
        Assert.AreEqual(11, target(DiscColor.WHITE).Stable)

    End Sub
End Class
