﻿Public Class computerPlayer

    Private _AI As AI.computerAI

    Public Sub ChangeAI(ByVal AI As AI.computerAI, ByVal Color As DiscColor)
        _AI = AI
        MyColor = Color
        If _AI Is Nothing Then
            MyColor = DiscColor.EMPTY
        End If
    End Sub

    Public Property MyColor As DiscColor

    Public Sub DoPut(ByVal nowBoard As Board)

        If nowBoard.MovablePostions.Count = 0 Then
            nowBoard.Pass()
            Return
        End If

        If nowBoard.MovablePostions.Count = 1 Then
            nowBoard.Move(nowBoard.MovablePostions(0))
            Return
        End If

        Dim tempBoard As Board = New Board(nowBoard)
        _AI.Initialize(tempBoard)

        Dim bookManager As New Book.BookManager
        Dim movables As IList(Of Point) = bookManager.Find(tempBoard)
        Dim bestPoint As New Point(-1, -1)
        Dim bestEvaluation As Integer = -9999
        For Each discPoint As Point In movables
            tempBoard.Move(discPoint)
            Dim evaluation As Integer = _AI.EvaluationValue(tempBoard)
            tempBoard.Undo()
            If evaluation > bestEvaluation Then
                bestPoint = discPoint
                bestEvaluation = evaluation
            End If
        Next
        Debug.Assert(bestPoint.X <> -1)
        Debug.Assert(bestPoint.Y <> -1)
        Debug.Assert(bestEvaluation <> -9999)
        nowBoard.Move(bestPoint)

    End Sub




End Class
