﻿Public Class Point
    Public Property X As Integer
    Public Property Y As Integer

    Sub New(ByVal x As Integer, ByVal y As Integer)
        Me.X = x
        Me.Y = y
    End Sub

    Sub New(ByVal coordinate As String)
        Debug.Assert(coordinate.Length = 2)
        Dim coordXAsc As Integer = Asc(coordinate(0))
        If Asc("a"c) <= coordXAsc AndAlso coordXAsc <= Asc("h") Then
            X = coordXAsc - Asc("a"c) + 1
        End If
        If Asc("A"c) <= coordXAsc AndAlso coordXAsc <= Asc("H") Then
            X = coordXAsc - Asc("A"c) + 1
        End If
        Dim coordYAsc As Integer = Asc(coordinate(1))
        If Asc("1"c) <= coordYAsc AndAlso coordYAsc <= Asc("8"c) Then
            Y = Asc(coordinate(1)) - Asc("1"c) + 1
        End If
    End Sub

    Public Shared Operator =(ByVal op1 As Point, ByVal op2 As Point) As Boolean
        Return op1.X = op2.X AndAlso op1.Y = op2.Y
    End Operator

    Public Shared Operator <>(ByVal op1 As Point, ByVal op2 As Point) As Boolean
        Return Not (op1 = op2)
    End Operator

    Public Overrides Function ToString() As String
        If 1 <= X AndAlso X <= Board.SIZE_X Then
            Return String.Format("{0}{1}", Chr(Asc("a"c) + X - 1), Y)
        End If
        Return String.Format("{0}{1}", X, Y)
    End Function

End Class
