﻿Imports System.IO, com
Imports iTextSharp.text.pdf
Imports iTextSharp.text
Imports WindowsApp1


Public Class Form1

    Private Class Form1Logger
        Inherits LoggerTemplate
        Private form As Form1
        Public Sub New(form As Form1)
            Me.form = form
        End Sub
        Public Overrides Sub output(message As String)
            form.lstLog.Items.Add(message)
        End Sub
    End Class
    Private log As Logger = New Form1Logger(Me)


    Private Sub btnExecute_Click(sender As Object, e As EventArgs) Handles btnExecute.Click
        log.Info("処理開始")
        Dim allPath = TextBox1.Text '全冊フォルダ
        '全冊フォルダのzipファイルを列挙するし以下を繰り返す。
        Dim files As String() = System.IO.Directory.GetDirectories(allPath)
        For Each path In files
            log.Info(path)
            topdf(path)
        Next

        log.Info("処理終了")
    End Sub




    Private Sub topdf(path As String)

        Dim dirInfo = New System.IO.DirectoryInfo(path)

        '２番目以降のファイルを読み込む。
        '2つに分割し右側をfilename_count.jpeg,左側をfilename_count+1.jpegとして保存する
        'tempフォルダをpdf化する
        'A4サイズを横向きで
        Dim psize As New iTextSharp.text.Rectangle(1000, 1200)
        Dim pdfDocument = New Document(psize, 0, 0, 0, 0)
        '出力先のファイル名
        Dim makePdfFilePath = $"{dirInfo.Name}.pdf"
        Dim fileStream = New FileStream(makePdfFilePath, FileMode.Create)
        Dim writer = PdfWriter.GetInstance(pdfDocument, fileStream)
        'PDFドキュメントを開く
        pdfDocument.Open()
        Dim files = System.IO.Directory.GetFiles(path, "*.jpg", System.IO.SearchOption.AllDirectories)
        Dim fileIdx(files.Count + 1) As Integer
        For i = 0 To fileIdx.Count - 1
            Dim j = 0
            For Each filepath In files
                Dim filename = System.IO.Path.GetFileName(filepath)
                Dim st = filename.IndexOf("-")
                Dim et = filename.IndexOf(".")
                Dim countstr = filename.Substring(st + 1, et - st - 1)
                Dim count As Integer
                If Integer.TryParse(countstr, count) Then
                    If count = i Then
                        fileIdx(i) = j
                    End If
                End If
                j += 1
            Next

        Next
        For i = 0 To fileIdx.Count - 1
            Dim img = iTextSharp.text.Image.GetInstance(New Uri(files(fileIdx(i))))
            If 1000 < img.Width Then
                img.RotationDegrees = 90
            End If
            pdfDocument.Add(img)
        Next
        'PDFドキュメントを閉じる
        pdfDocument.Close()

    End Sub

    Private Sub Button1_Click(sender As Object, e As EventArgs) Handles Button1.Click
        Dim dirs As String() = System.IO.Directory.GetDirectories("C:\Users\bellm\Downloads\test")
        Dim psize As New iTextSharp.text.Rectangle(768, 1024)
        '出力先のファイル名
        Dim makePdfFilePath = $"HH.pdf"
        Dim fileStream = New FileStream(makePdfFilePath, FileMode.Create)
        Dim pdfDocument = New Document(psize, 0, 0, 0, 0)
        Dim writer = PdfWriter.GetInstance(pdfDocument, fileStream)
        'PDFドキュメントを開く
        pdfDocument.Open()

        For Each path In dirs


            Dim dirInfo = New System.IO.DirectoryInfo(path)



            Dim files = System.IO.Directory.GetFiles(path, "*.jpg", System.IO.SearchOption.AllDirectories)
            For Each filepath As String In files
                Dim img = iTextSharp.text.Image.GetInstance(New Uri(filepath))
                If 768 < img.Width Then
                    img.RotationDegrees = 90
                End If
                pdfDocument.Add(img)
            Next

        Next
        'PDFドキュメントを閉じる
        pdfDocument.Close()
    End Sub
End Class
